/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.exceptions.XMLParseException;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveFactoryImpl;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.deployment.xml.parser.PersistenceContentHandler;
import org.eclipse.persistence.internal.jpa.deployment.xml.parser.XMLException;
import org.eclipse.persistence.internal.jpa.deployment.xml.parser.XMLExceptionHandler;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProcessor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.jpa.Archive;
import org.eclipse.persistence.jpa.ArchiveFactory;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class PersistenceUnitProcessor {
    public static ArchiveFactory ARCHIVE_FACTORY = null;
    private static final String WEBINF_CLASSES_STR = "WEB-INF/classes/";
    private static final int WEBINF_CLASSES_LEN = "WEB-INF/classes/".length();

    public static String buildClassNameFromEntryString(String classEntryString) {
        String classNameForLoader = classEntryString;
        if (classEntryString.endsWith(".class")) {
            classNameForLoader = classNameForLoader.substring(0, classNameForLoader.length() - 6);
            classNameForLoader = classNameForLoader.replace("/", ".");
        }
        return classNameForLoader;
    }

    public static Set<String> buildClassSet(PersistenceUnitInfo persistenceUnitInfo, Map properties) {
        HashSet<String> set = new HashSet<String>();
        set.addAll(persistenceUnitInfo.getManagedClassNames());
        ClassLoader loader = persistenceUnitInfo.getClassLoader();
        Iterator i = persistenceUnitInfo.getJarFileUrls().iterator();
        while (i.hasNext()) {
            set.addAll(PersistenceUnitProcessor.getClassNamesFromURL((URL)i.next(), loader, properties));
        }
        if (!persistenceUnitInfo.excludeUnlistedClasses()) {
            set.addAll(PersistenceUnitProcessor.getClassNamesFromURL(persistenceUnitInfo.getPersistenceUnitRootUrl(), loader, properties));
        }
        return set;
    }

    public static Collection<MetadataClass> buildEntityList(MetadataProcessor processor, ClassLoader loader) {
        ArrayList<MetadataClass> entityList = new ArrayList<MetadataClass>();
        for (String className : processor.getProject().getWeavableClassNames()) {
            entityList.add(processor.getMetadataFactory().getMetadataClass(className));
        }
        return entityList;
    }

    public static URL computePURootURL(URL pxmlURL, String descriptorLocation) throws IOException, URISyntaxException {
        URL result;
        StringTokenizer tokenizer = new StringTokenizer(descriptorLocation, "/\\");
        int descriptorDepth = tokenizer.countTokens() - 1;
        String protocol = pxmlURL.getProtocol();
        if ("file".equals(protocol)) {
            StringBuffer path = new StringBuffer();
            boolean firstElement = true;
            int i = 0;
            while (i < descriptorDepth) {
                if (!firstElement) {
                    path.append("/");
                }
                path.append("..");
                firstElement = false;
                ++i;
            }
            result = new URL(pxmlURL, path.toString());
        } else if ("jar".equals(protocol)) {
            JarURLConnection conn = (JarURLConnection)JarURLConnection.class.cast(pxmlURL.openConnection());
            result = conn.getJarFileURL();
        } else if ("zip".equals(protocol)) {
            String spec = pxmlURL.getFile();
            int separator = spec.lastIndexOf("!/");
            if (separator == -1) {
                separator = spec.length() - 1;
            }
            result = new URL("file", "", spec.substring(0, separator++));
        } else if ("wsjar".equals(protocol)) {
            String spec = pxmlURL.getFile();
            int separator = spec.lastIndexOf("!/");
            if (separator == -1) {
                separator = spec.length();
            } else if (spec.regionMatches(true, (separator += 2) - 6, ".war", 0, 4) && spec.regionMatches(true, separator, WEBINF_CLASSES_STR, 0, WEBINF_CLASSES_LEN)) {
                separator += WEBINF_CLASSES_LEN;
            }
            result = new URL("jar", "", spec.substring(0, separator));
        } else if ("bundleentry".equals(protocol)) {
            result = new URL("bundleentry://" + pxmlURL.getAuthority());
        } else if ("bundleresource".equals(protocol)) {
            result = new URL("bundleresource://" + pxmlURL.getAuthority());
        } else {
            StringBuffer path = new StringBuffer();
            int i = 0;
            while (i < descriptorDepth) {
                path.append("../");
                ++i;
            }
            result = new URL(pxmlURL, path.toString());
        }
        result = PersistenceUnitProcessor.fixUNC(result);
        return result;
    }

    private static URL fixUNC(URL url) throws URISyntaxException, MalformedURLException, UnsupportedEncodingException {
        String protocol = url.getProtocol();
        if (!"file".equalsIgnoreCase(protocol)) {
            return url;
        }
        String authority = url.getAuthority();
        String file = url.getFile();
        if (authority != null) {
            AbstractSessionLog.getLog().finer("fixUNC: before fixing: url = " + url + ", authority = " + authority + ", file = " + file);
            assert (url.getPort() == -1);
            String prefix = "";
            if (authority.length() > 0) {
                prefix = "////";
            } else if (file.startsWith("//")) {
                prefix = "//";
            }
            file = prefix.concat(authority).concat(file);
            url = new URL(protocol, null, file);
            AbstractSessionLog.getLog().finer("fixUNC: after fixing: url = " + url + ", authority = " + url.getAuthority() + ", file = " + url.getFile());
        }
        return url;
    }

    public static Set<Archive> findPersistenceArchives() {
        ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
        return PersistenceUnitProcessor.findPersistenceArchives(threadLoader);
    }

    public static Set<Archive> findPersistenceArchives(ClassLoader loader) {
        String descriptorLocation = PrivilegedAccessHelper.getSystemProperty("eclipselink.persistencexml", "META-INF/persistence.xml");
        return PersistenceUnitProcessor.findPersistenceArchives(loader, descriptorLocation);
    }

    /*
     * Unable to fully structure code
     */
    public static Set<Archive> findPersistenceArchives(ClassLoader loader, String descriptorPath) {
        block7: {
            archive = null;
            archives = new HashSet<Archive>();
            splitPosition = descriptorPath.indexOf("!/");
            try {
                if (splitPosition == -1) {
                    resources = loader.getResources(descriptorPath);
                    while (resources.hasMoreElements()) {
                        descUrl = resources.nextElement();
                        if (descUrl == null) continue;
                        puRootUrl = PersistenceUnitProcessor.computePURootURL(descUrl, descriptorPath);
                        archive = PersistenceUnitProcessor.getArchiveFactory(loader).createArchive(puRootUrl, descriptorPath, null);
                        if (archive == null) continue;
                        archives.add(archive);
                    }
                } else {
                    jarPrefixPath = descriptorPath.substring(0, splitPosition);
                    descPath = descriptorPath.substring(splitPosition + 2);
                    prefixUrl = loader.getResource(jarPrefixPath);
                    archive = PersistenceUnitProcessor.getArchiveFactory(loader).createArchive(prefixUrl, descPath, null);
                    if (archive != null) {
                        archives.add(archive);
                    }
                }
                break block7;
            }
            catch (Exception ex) {
                ** for (a : archives)
            }
lbl-1000:
            // 1 sources

            {
                a.close();
                continue;
            }
lbl29:
            // 1 sources

            throw PersistenceUnitLoadingException.exceptionSearchingForPersistenceResources(loader, ex);
        }
        return archives;
    }

    /*
     * Unable to fully structure code
     */
    public static Set<Archive> findPersistenceArchives(ClassLoader loader, String descriptorPath, List<URL> jarFileUrls) {
        block6: {
            archive = null;
            archives = new HashSet<Archive>();
            splitPosition = descriptorPath.indexOf("!/");
            if (splitPosition != -1) {
                descriptorPath = descriptorPath.substring(splitPosition + 2);
            }
            try {
                i = 0;
                while (i < jarFileUrls.size()) {
                    puRootUrl = jarFileUrls.get(i);
                    archive = PersistenceUnitProcessor.getArchiveFactory(loader).createArchive(puRootUrl, descriptorPath, null);
                    if (archive != null) {
                        archives.add(archive);
                    }
                    ++i;
                }
                break block6;
            }
            catch (Exception ex) {
                ** for (a : archives)
            }
lbl-1000:
            // 1 sources

            {
                a.close();
                continue;
            }
lbl21:
            // 1 sources

            throw PersistenceUnitLoadingException.exceptionSearchingForPersistenceResources(loader, ex);
        }
        return archives;
    }

    /*
     * Unable to fully structure code
     */
    public static Set<SEPersistenceUnitInfo> getPersistenceUnits(ClassLoader loader, Map m, List<URL> jarFileUrls) {
        descriptorPath = (String)m.get("eclipselink.persistencexml");
        if (descriptorPath == null) {
            descriptorPath = PrivilegedAccessHelper.getSystemProperty("eclipselink.persistencexml", "META-INF/persistence.xml");
        }
        archives = PersistenceUnitProcessor.findPersistenceArchives(loader, descriptorPath, jarFileUrls);
        puInfos = new HashSet<SEPersistenceUnitInfo>();
        try {
            for (Archive archive : archives) {
                puInfosFromArchive = PersistenceUnitProcessor.getPersistenceUnits(archive, loader);
                puInfos.addAll(puInfosFromArchive);
            }
        }
        finally {
            ** for (archive : archives)
        }
lbl-1000:
        // 1 sources

        {
            archive.close();
            continue;
        }
lbl17:
        // 1 sources

        return puInfos;
    }

    public static ArchiveFactory getArchiveFactory(ClassLoader loader) {
        ArchiveFactory factory;
        block9: {
            if (ARCHIVE_FACTORY != null) {
                return ARCHIVE_FACTORY;
            }
            factory = null;
            String factoryClassName = PrivilegedAccessHelper.getSystemProperty("eclipselink.archive.factory", null);
            if (factoryClassName == null) {
                return new ArchiveFactoryImpl();
            }
            try {
                if (loader == null) break block9;
                Class<?> archiveClass = loader.loadClass(factoryClassName);
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        factory = (ArchiveFactory)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(archiveClass));
                        break block9;
                    }
                    catch (PrivilegedActionException exception) {
                        throw PersistenceUnitLoadingException.exceptionCreatingArchiveFactory(factoryClassName, exception);
                    }
                }
                factory = (ArchiveFactory)PrivilegedAccessHelper.newInstanceFromClass(archiveClass);
            }
            catch (ClassNotFoundException cnfe) {
                throw PersistenceUnitLoadingException.exceptionCreatingArchiveFactory(factoryClassName, cnfe);
            }
            catch (IllegalAccessException iae) {
                throw PersistenceUnitLoadingException.exceptionCreatingArchiveFactory(factoryClassName, iae);
            }
            catch (InstantiationException ie) {
                throw PersistenceUnitLoadingException.exceptionCreatingArchiveFactory(factoryClassName, ie);
            }
        }
        return factory;
    }

    public static Set<String> getClassNamesFromURL(URL url, ClassLoader loader, Map properties) {
        HashSet<String> classNames = new HashSet<String>();
        try (Archive archive = null;){
            try {
                archive = PersistenceUnitProcessor.getArchiveFactory(loader).createArchive(url, properties);
                if (archive != null) {
                    Iterator<String> entries = archive.getEntries();
                    while (entries.hasNext()) {
                        String entry = entries.next();
                        if (!entry.endsWith(".class")) continue;
                        classNames.add(PersistenceUnitProcessor.buildClassNameFromEntryString(entry));
                    }
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("url = [" + url + "]", e);
            }
            catch (IOException e) {
                throw new RuntimeException("url = [" + url + "]", e);
            }
        }
        return classNames;
    }

    public static MetadataAnnotation getConverterAnnotation(MetadataClass candidateClass) {
        return candidateClass.getAnnotation("javax.persistence.Converter");
    }

    public static MetadataAnnotation getEmbeddableAnnotation(MetadataClass candidateClass) {
        return candidateClass.getAnnotation("javax.persistence.Embeddable");
    }

    public static MetadataAnnotation getEntityAnnotation(MetadataClass candidateClass) {
        return candidateClass.getAnnotation("javax.persistence.Entity");
    }

    public static List<SEPersistenceUnitInfo> getPersistenceUnits(Archive archive, ClassLoader loader) {
        return PersistenceUnitProcessor.processPersistenceArchive(archive, loader);
    }

    public static MetadataAnnotation getMappedSuperclassAnnotation(MetadataClass candidateClass) {
        return candidateClass.getAnnotation("javax.persistence.MappedSuperclass");
    }

    public static MetadataAnnotation getStaticMetamodelAnnotation(MetadataClass candidateClass) {
        return candidateClass.getAnnotation("javax.persistence.metamodel.StaticMetamodel");
    }

    public static boolean isConverter(MetadataClass candidateClass) {
        return candidateClass.isAnnotationPresent("javax.persistence.Converter");
    }

    public static boolean isEmbeddable(MetadataClass candidateClass) {
        return candidateClass.isAnnotationPresent("javax.persistence.Embeddable");
    }

    public static boolean isEntity(MetadataClass candidateClass) {
        return candidateClass.isAnnotationPresent("javax.persistence.Entity");
    }

    public static boolean isStaticMetamodelClass(MetadataClass candidateClass) {
        return candidateClass.isAnnotationPresent("javax.persistence.metamodel.StaticMetamodel");
    }

    public static boolean isMappedSuperclass(MetadataClass candidateClass) {
        return candidateClass.isAnnotationPresent("javax.persistence.MappedSuperclass");
    }

    public static Class loadClass(String className, ClassLoader loader, boolean throwExceptionIfNotFound, MetadataProject project) {
        Class<?> candidateClass = null;
        try {
            candidateClass = loader.loadClass(className);
        }
        catch (ClassNotFoundException exc) {
            if (throwExceptionIfNotFound) {
                throw PersistenceUnitLoadingException.exceptionLoadingClassWhileLookingForAnnotations(className, exc);
            }
            AbstractSessionLog.getLog().log(6, "persistence_unit_processor_error_loading_class", exc.getClass().getName(), (Object)exc.getLocalizedMessage(), (Object)className);
        }
        catch (NullPointerException nullPointerException) {
            AbstractSessionLog.getLog().log(6, "weaver", "persistence_unit_processor_error_loading_class_weaving_disabled", (Object)loader, (Object)project.getPersistenceUnitInfo().getPersistenceUnitName(), (Object)className);
            project.disableWeaving();
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(6, "weaver", "persistence_unit_processor_error_loading_class", (Object)exception.getClass().getName(), (Object)exception.getLocalizedMessage(), (Object)className);
        }
        catch (Error error) {
            AbstractSessionLog.getLog().log(6, "weaver", "persistence_unit_processor_error_loading_class", (Object)error.getClass().getName(), (Object)error.getLocalizedMessage(), (Object)className);
            throw error;
        }
        return candidateClass;
    }

    public static void processORMetadata(MetadataProcessor processor, boolean throwExceptionOnFail, Mode mode) {
        if (mode == Mode.ALL || mode == Mode.COMPOSITE_MEMBER_INITIAL) {
            processor.loadMappingFiles(throwExceptionOnFail);
        }
        processor.processEntityMappings(mode);
        processor.processORMMetadata(mode);
    }

    public static List<SEPersistenceUnitInfo> processPersistenceArchive(Archive archive, ClassLoader loader) {
        URL puRootURL = archive.getRootURL();
        try {
            return PersistenceUnitProcessor.processPersistenceXML(puRootURL, archive.getDescriptorStream(), loader);
        }
        catch (Exception e) {
            throw PersistenceUnitLoadingException.exceptionLoadingFromUrl(puRootURL.toString(), e);
        }
    }

    private static List<SEPersistenceUnitInfo> processPersistenceXML(URL baseURL, InputStream input, ClassLoader loader) {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        XMLReader xmlReader = null;
        SAXParser sp = null;
        XMLExceptionHandler xmlErrorHandler = new XMLExceptionHandler();
        try {
            sp = spf.newSAXParser();
        }
        catch (ParserConfigurationException exc) {
            throw XMLParseException.exceptionCreatingSAXParser(baseURL, exc);
        }
        catch (SAXException exc) {
            throw XMLParseException.exceptionCreatingSAXParser(baseURL, exc);
        }
        try {
            xmlReader = sp.getXMLReader();
            xmlReader.setErrorHandler(xmlErrorHandler);
        }
        catch (SAXException exc) {
            throw XMLParseException.exceptionCreatingXMLReader(baseURL, exc);
        }
        PersistenceContentHandler myContentHandler = new PersistenceContentHandler();
        xmlReader.setContentHandler(myContentHandler);
        InputSource inputSource = new InputSource(input);
        try {
            xmlReader.parse(inputSource);
        }
        catch (IOException exc) {
            throw PersistenceUnitLoadingException.exceptionProcessingPersistenceXML(baseURL, exc);
        }
        catch (SAXException sAXException) {}
        XMLException xmlError = xmlErrorHandler.getXMLException();
        if (xmlError != null) {
            throw PersistenceUnitLoadingException.exceptionProcessingPersistenceXML(baseURL, xmlError);
        }
        for (SEPersistenceUnitInfo info : myContentHandler.getPersistenceUnits()) {
            info.setPersistenceUnitRootUrl(baseURL);
            info.setClassLoader(loader);
            info.setNewTempClassLoader(loader);
        }
        return myContentHandler.getPersistenceUnits();
    }

    public static void setArchiveFactory(ArchiveFactory factory) {
        ARCHIVE_FACTORY = factory;
    }

    public static String buildPersistenceUnitName(URL url, String puName) {
        String fullPuName = null;
        try {
            fullPuName = String.valueOf(URLDecoder.decode(url.toString(), "UTF8")) + "_" + puName;
        }
        catch (UnsupportedEncodingException e) {
            throw PersistenceUnitLoadingException.couldNotBuildPersistenceUntiName(e, url.toString(), puName);
        }
        return fullPuName;
    }

    public static enum Mode {
        ALL,
        COMPOSITE_MEMBER_INITIAL,
        COMPOSITE_MEMBER_MIDDLE,
        COMPOSITE_MEMBER_FINAL;

    }
}

