/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.monitor;

import com.ibm.websphere.monitor.annotation.Monitor;
import com.ibm.websphere.monitor.annotation.ProbeAtEntry;
import com.ibm.websphere.monitor.annotation.ProbeAtReturn;
import com.ibm.websphere.monitor.annotation.ProbeSite;
import com.ibm.websphere.monitor.annotation.PublishedMetric;
import com.ibm.websphere.monitor.annotation.This;
import com.ibm.websphere.monitor.meters.MeterCollection;
import com.ibm.websphere.servlet.container.WebContainer;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.webcontainer.monitor.ServletStats;
import com.ibm.ws.webcontainer.servlet.ServletWrapper;
import javax.servlet.GenericServlet;

@Monitor(group={"WebContainer"})
public class WebContainerMonitor {
    private static final String APP_NAME_FROM_CONTEXT = "com.ibm.websphere.servlet.enterprise.application.name";
    private final ThreadLocal<Long> startTimes = new ThreadLocal();
    @PublishedMetric
    public MeterCollection<ServletStats> servletCountByName = new MeterCollection("Servlet", (Object)this);

    public WebContainerMonitor() {
        if (!PmiRegistry.isDisabled()) {
            WebContainer.addGlobalListener((String)"com.ibm.ws.webcontainer.monitor.WebAppMonitorListener");
        }
    }

    @ProbeAtEntry
    @ProbeSite(clazz="com.ibm.ws.webcontainer.servlet.ServletWrapper", method="service", args="javax.servlet.ServletRequest,javax.servlet.ServletResponse,com.ibm.ws.webcontainer.webapp.WebAppServletInvocationEvent")
    public void atServletStart(@This GenericServlet s) {
        this.startTimes.set(System.nanoTime());
    }

    public synchronized ServletStats initServletStats(String _key, String _app, String _ser) {
        ServletStats nStats = (ServletStats)this.servletCountByName.get(_key);
        if (nStats == null) {
            nStats = new ServletStats(_app, _ser);
            this.servletCountByName.put(_key, (Object)nStats);
        }
        return nStats;
    }

    @ProbeAtReturn
    @ProbeSite(clazz="com.ibm.ws.webcontainer.servlet.ServletWrapper", method="service", args="javax.servlet.ServletRequest,javax.servlet.ServletResponse,com.ibm.ws.webcontainer.webapp.WebAppServletInvocationEvent")
    public void atServletEnd(@This GenericServlet s) {
        String metricsKey = ((ServletWrapper)s).getMetricsKey();
        ServletStats stats = (ServletStats)this.servletCountByName.get(metricsKey);
        if (stats == null) {
            String servletName = s.getServletConfig().getServletName();
            String appName = (String)s.getServletContext().getAttribute(APP_NAME_FROM_CONTEXT);
            stats = this.initServletStats(metricsKey, appName, servletName);
        }
        stats.incrementCountBy(1);
        Long times = this.startTimes.get();
        if (times != null) {
            long elapsed = System.nanoTime() - times;
            stats.updateRT(elapsed < 0L ? 0L : elapsed);
        }
    }

    @ProbeAtEntry
    @ProbeSite(clazz="com.ibm.ws.webcontainer.servlet.ServletWrapper", method="destroy")
    public void atServletDestroy(@This GenericServlet s) {
        String metricsKey = ((ServletWrapper)s).getMetricsKey();
        this.servletCountByName.remove(metricsKey);
    }
}

