/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal.chains;

import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channelfw.internal.ChannelFactoryDataImpl;
import com.ibm.ws.channelfw.internal.ChannelFrameworkImpl;
import com.ibm.ws.channelfw.internal.ChildChannelDataImpl;
import com.ibm.ws.channelfw.internal.chains.Chain;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channelfw.ChannelFactory;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.channelfw.OutboundChannel;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.channelfw.exception.ChannelFactoryException;
import com.ibm.wsspi.channelfw.exception.IncoherentChainException;
import com.ibm.wsspi.channelfw.exception.InvalidChannelNameException;

public class OutboundChain
extends Chain {
    private static final TraceComponent tc = Tr.register(OutboundChain.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");

    public OutboundChain(ChainData config, ChannelFrameworkImpl framework) throws ChannelException, IncoherentChainException {
        super(config);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"constructor", (Object[])new Object[0]);
        }
        ChannelFactory channelFactory = null;
        OutboundChannel prevChannel = null;
        this.channels = new OutboundChannel[this.channelDataArray.length];
        for (int i = this.channelDataArray.length - 1; i >= 0; --i) {
            channelFactory = framework.getChannelFactoryInternal(this.channelDataArray[i].getFactoryType(), true);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Create channel, " + this.channelDataArray[i].getName()), (Object[])new Object[0]);
            }
            if (i != this.channelDataArray.length - 1) {
                ((ChildChannelDataImpl)this.channelDataArray[i]).setDeviceInterface(this.channels[i + 1].getApplicationInterface());
            }
            ((ChildChannelDataImpl)this.channelDataArray[i]).setIsInbound(false);
            this.channels[i] = channelFactory.findOrCreateChannel(this.channelDataArray[i]);
            if (null == this.channels[i]) {
                InvalidChannelNameException e = new InvalidChannelNameException("Chain cannot be created because of channel, " + this.channelDataArray[i].getName());
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".constructor"), (String)"79", (Object)this, (Object[])new Object[]{this.channelDataArray[i]});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"constructor");
                }
                throw e;
            }
            if (null != prevChannel) {
                int numAppAddressTypes = prevChannel.getApplicationAddress().length;
                String prevType = ((OutboundChannel)this.channels[i]).getDeviceAddress().toString();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("DevAddress: " + prevType), (Object[])new Object[0]);
                    for (int j = 0; j < numAppAddressTypes; ++j) {
                        Tr.debug((TraceComponent)tc, (String)("AppAddress[" + j + "]: " + prevChannel.getApplicationAddress()[j].toString()), (Object[])new Object[0]);
                    }
                }
                boolean bMatchedAddress = false;
                String nextType = null;
                for (int j = 0; j < numAppAddressTypes; ++j) {
                    nextType = prevChannel.getApplicationAddress()[j].toString();
                    if (!prevType.equals(nextType)) continue;
                    bMatchedAddress = true;
                    break;
                }
                if (!bMatchedAddress) {
                    IncoherentChainException e = new IncoherentChainException("Unmatching addresses between channels: " + prevChannel.getName() + ", " + this.channels[i].getName());
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".constructor"), (String)"109", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"constructor");
                    }
                    throw e;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("prev.AppInterface: " + prevChannel.getApplicationInterface()), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("next.DevInterface: " + this.channels[i].getDeviceInterface()), (Object[])new Object[0]);
                }
                if (prevChannel.getApplicationInterface() != this.channels[i].getDeviceInterface()) {
                    IncoherentChainException e = new IncoherentChainException("Unmatching channels: " + prevChannel.getName() + ", " + this.channels[i].getName());
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".constructor"), (String)"124", (Object)this, (Object[])new Object[]{prevChannel, this.channels[i]});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"constructor");
                    }
                    throw e;
                }
            }
            prevChannel = (OutboundChannel)this.channels[i];
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"constructor");
        }
    }

    public static void verifyChainCoherency(ChainData chainData) throws IncoherentChainException {
        ChannelData[] channelDataArray;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"verifyChainCoherency", (Object[])new Object[0]);
        }
        if ((channelDataArray = chainData.getChannelList()).length > 1) {
            ChannelFrameworkImpl fw = (ChannelFrameworkImpl)ChannelFrameworkFactory.getChannelFramework();
            ChannelFactoryDataImpl current = null;
            ChannelFactoryDataImpl next = null;
            Class<?>[] currentDevClasses = null;
            Class<?> nextAppClass = null;
            try {
                current = fw.findOrCreateChannelFactoryData(channelDataArray[0].getFactoryType());
            }
            catch (ChannelFactoryException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found invalid channel factory of type " + channelDataArray[0].getFactoryType().getName()), (Object[])new Object[0]);
                }
                throw new IncoherentChainException("Invalid channel factory");
            }
            for (int i = 1; i < channelDataArray.length; ++i) {
                currentDevClasses = current.getDeviceInterface();
                try {
                    next = fw.findOrCreateChannelFactoryData(channelDataArray[i].getFactoryType());
                }
                catch (ChannelFactoryException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found invalid channel factory of type " + channelDataArray[i].getFactoryType().getName()), (Object[])new Object[0]);
                    }
                    throw new IncoherentChainException("Invalid channel factory");
                }
                nextAppClass = next.getApplicationInterface();
                if (null == currentDevClasses || null == nextAppClass) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found null interface classes between two channel factories: " + current.getFactory().getName() + ", " + next.getFactory().getName()), (Object[])new Object[0]);
                    }
                    throw new IncoherentChainException("Found null interface classes between two channel factories: " + current.getFactory().getName() + ", " + next.getFactory().getName());
                }
                boolean foundMatch = false;
                for (int j = 0; j < currentDevClasses.length; ++j) {
                    if (!nextAppClass.isAssignableFrom(currentDevClasses[j])) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found compatible class: " + nextAppClass + " " + currentDevClasses[j]), (Object[])new Object[0]);
                    }
                    foundMatch = true;
                    break;
                }
                if (!foundMatch) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found incoherency between two channel factories: " + current.getFactory().getName() + ", " + next.getFactory().getName()), (Object[])new Object[0]);
                    }
                    throw new IncoherentChainException("Found incoherency between two channel factories: " + current.getFactory().getName() + ", " + next.getFactory().getName());
                }
                current = next;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"verifyChainCoherency");
        }
    }
}

