/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.j2ee;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class J2EEManagementObjectNameFactory {
    public static final String DOMAIN_NAME = "WebSphere";
    public static final String KEY_TYPE = "j2eeType";
    public static final String KEY_NAME = "name";
    public static final String KEY_SERVER = "server";
    public static final String KEY_JAVA_VMS = "javaVMs";
    public static final String DEPLOYMENT_DESCRIPTOR = "deploymentDescriptor";
    public static final String SERVLETS = "servlets";
    public static final String TYPE_DOMAIN = "J2EEDomain";
    public static final String TYPE_SERVER = "J2EEServer";
    public static final String TYPE_JVM = "JVM";
    public static final String TYPE_APPLICATION = "J2EEApplication";
    public static final String TYPE_EJB_MODULE = "EJBModule";
    public static final String TYPE_WEB_MODULE = "WebModule";
    public static final String TYPE_RESOURCE_ADAPTER_MODULE = "ResourceAdapterModule";
    public static final String TYPE_APP_CLIENT_MODULE = "AppClientModule";
    public static final String TYPE_SERVLET = "Servlet";
    public static final String TYPE_JAVA_MAIL_RESOURCE = "JavaMailResource";
    public static final String TYPE_JNDI_RESOURCE = "JNDIResource";
    public static final String TYPE_ORB_RESOURCE = "RMI_IIOPResource";
    public static final String NAME_JAVA_MAIL_RESOURCE = "JavaMailResourceMBeanImpl";
    public static final String MAIL_SESSION_ID = "mailSessionID";
    public static final String RESOURCE_ID = "resourceID";
    static final long serialVersionUID = 694990471849151274L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    private static ObjectName createObjectName(String type, String name, Hashtable<String, String> props) {
        props.put(KEY_TYPE, type);
        props.put(KEY_NAME, name);
        try {
            return new ObjectName(DOMAIN_NAME, props);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            void e;
            FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.websphere.management.j2ee.J2EEManagementObjectNameFactory", (String)"113", null, (Object[])new Object[]{type, name, props});
            throw new IllegalArgumentException((Throwable)e);
        }
    }

    public static ObjectName createJ2EEDomainObjectName() {
        return J2EEManagementObjectNameFactory.createObjectName(TYPE_DOMAIN, DOMAIN_NAME, new Hashtable<String, String>());
    }

    public static ObjectName createJ2EEServerObjectName(String name) {
        return J2EEManagementObjectNameFactory.createObjectName(TYPE_SERVER, name, new Hashtable<String, String>());
    }

    public static ObjectName createJVMObjectName(String serverName) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put(TYPE_SERVER, serverName);
        return J2EEManagementObjectNameFactory.createObjectName(TYPE_JVM, TYPE_JVM, props);
    }

    public static ObjectName createApplicationObjectName(String name, String serverName) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put(TYPE_SERVER, serverName);
        return J2EEManagementObjectNameFactory.createObjectName(TYPE_APPLICATION, name, props);
    }

    public static ObjectName createModuleObjectName(ModuleType moduleType, String uri, String appName, String serverName) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put(TYPE_APPLICATION, appName == null ? "null" : appName);
        props.put(TYPE_SERVER, serverName);
        return J2EEManagementObjectNameFactory.createObjectName(moduleType.name(), uri, props);
    }

    public static ObjectName createEJBModuleObjectName(String uri, String appName, String serverName) {
        return J2EEManagementObjectNameFactory.createModuleObjectName(ModuleType.EJBModule, uri, appName, serverName);
    }

    public static ObjectName createEJBObjectName(EJBType type, String name, String moduleURI, String appName, String serverName) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put(ModuleType.EJBModule.name(), moduleURI);
        props.put(TYPE_APPLICATION, appName == null ? "null" : appName);
        props.put(TYPE_SERVER, serverName);
        return J2EEManagementObjectNameFactory.createObjectName(type.name(), name, props);
    }

    public static ObjectName createWebModuleObjectName(String moduleURI, String appName, String serverName) {
        return J2EEManagementObjectNameFactory.createModuleObjectName(ModuleType.WebModule, moduleURI, appName, serverName);
    }

    public static ObjectName createServletObjectName(String servletName, String moduleURI, String appName, String serverName) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put(ModuleType.WebModule.name(), moduleURI);
        props.put(TYPE_APPLICATION, appName == null ? "null" : appName);
        props.put(TYPE_SERVER, serverName);
        return J2EEManagementObjectNameFactory.createObjectName(TYPE_SERVLET, servletName, props);
    }

    public static ObjectName createJavaMailObjectName(String serverName, String mailSessionID, int resourceCounter) {
        ObjectName objectName;
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put(TYPE_SERVER, serverName);
        props.put(MAIL_SESSION_ID, mailSessionID);
        props.put(RESOURCE_ID, "JavaMailResource-" + resourceCounter);
        try {
            objectName = J2EEManagementObjectNameFactory.createObjectName(TYPE_JAVA_MAIL_RESOURCE, NAME_JAVA_MAIL_RESOURCE, props);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.websphere.management.j2ee.J2EEManagementObjectNameFactory", (String)"187", null, (Object[])new Object[]{serverName, mailSessionID, resourceCounter});
            props.remove(MAIL_SESSION_ID);
            objectName = J2EEManagementObjectNameFactory.createObjectName(TYPE_JAVA_MAIL_RESOURCE, NAME_JAVA_MAIL_RESOURCE, props);
        }
        return objectName;
    }

    public static ObjectName createResourceObjectName(String serverName, String resourceType, String keyName) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put(TYPE_SERVER, serverName);
        ObjectName objectName = J2EEManagementObjectNameFactory.createObjectName(resourceType, keyName, props);
        return objectName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.websphere.management.j2ee.J2EEManagementObjectNameFactory", J2EEManagementObjectNameFactory.class, (String)"jmx", null);
    }

    public static enum ModuleType {
        WebModule,
        EJBModule,
        ResourceAdapterModule,
        AppClientModule;

    }

    public static enum EJBType {
        StatelessSessionBean,
        StatefulSessionBean,
        SingletonSessionBean,
        EntityBean,
        MessageDrivenBean;

    }

    public static enum ResourceType {
        JCAResource,
        JTAResource,
        JDBCResource,
        JMSResource,
        JNDIResource,
        RMI_IIOPResource,
        JavaMailResource,
        URLResource;

    }
}

