/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client.proxyqueue.asynch;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.proxyqueue.AsynchConsumerProxyQueue;
import com.ibm.ws.sib.jfapchannel.framework.Framework;
import com.ibm.ws.sib.jfapchannel.threadpool.ThreadPool;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class AsynchConsumerThreadPool {
    private static final TraceComponent tc = SibTr.register(AsynchConsumerThreadPool.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    public static final String $sccsid = "@(#) 1.28 SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/proxyqueue/asynch/AsynchConsumerThreadPool.java, SIB.comms, WASX.SIB, uu1215.01 10/05/11 10:39:07 [4/12/12 22:14:06]";
    private static final int DEFAULT_MAX_THREADS = 10;
    private static int MAX_THREADS;
    public static final String CLIENT_ASYNC_CONSUMER_THREADPOOL_MAX_SIZE_PROPERTY = "com.ibm.ws.sib.comms.client.impl.MaximumClientAsyncConsumerThreadPoolSize";
    private static final String THREADPOOL_NAME = "Asynchronous Consumer";
    private final ScheduleQueue[] scheduleQueues;
    private final EmptyScheduleQueueStack emptyStack;
    private Map<AsynchConsumerProxyQueue, ScheduleQueue> inUseScheduleQueues = Collections.synchronizedMap(new HashMap());
    private static AsynchConsumerThreadPool instance;
    private int roundRobinCounter = 0;

    public static AsynchConsumerThreadPool getInstance() {
        return instance;
    }

    private AsynchConsumerThreadPool() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        ThreadPool threadPool = Framework.getInstance().getThreadPool(THREADPOOL_NAME, 0, MAX_THREADS);
        this.scheduleQueues = new ScheduleQueue[MAX_THREADS];
        this.emptyStack = new EmptyScheduleQueueStack(MAX_THREADS);
        for (int i = 0; i < MAX_THREADS; ++i) {
            this.scheduleQueues[i] = new ScheduleQueue(threadPool);
            this.emptyStack.push(this.scheduleQueues[i]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(AsynchConsumerProxyQueue queue) {
        ScheduleQueue scheduleQueue;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dispatch", (Object)queue);
        }
        Object object = this.inUseScheduleQueues;
        synchronized (object) {
            if (this.inUseScheduleQueues.containsKey(queue)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("We have a scheduleQueue already in use: " + queue + " " + this.inUseScheduleQueues));
                }
                scheduleQueue = this.inUseScheduleQueues.get(queue);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"No ScheduleQueue servicing this queue, using emptyStack");
                }
                if ((scheduleQueue = this.emptyStack.pop()) != null) {
                    this.inUseScheduleQueues.put(queue, scheduleQueue);
                }
            }
        }
        if (scheduleQueue == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"No ScheduleQueues on the emptyStack, round-robin on the running scheduleQueues");
            }
            object = this;
            synchronized (object) {
                scheduleQueue = this.scheduleQueues[this.roundRobinCounter];
                this.roundRobinCounter = (this.roundRobinCounter + 1) % MAX_THREADS;
            }
        }
        scheduleQueue.addWork(queue);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dispatch");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source Info: @(#) 1.28 SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/proxyqueue/asynch/AsynchConsumerThreadPool.java, SIB.comms, WASX.SIB, uu1215.01 10/05/11 10:39:07 [4/12/12 22:14:06]");
        }
        try {
            MAX_THREADS = Integer.parseInt(RuntimeInfo.getPropertyWithMsg((String)CLIENT_ASYNC_CONSUMER_THREADPOOL_MAX_SIZE_PROPERTY, (String)Integer.toString(10)));
        }
        catch (NumberFormatException nfe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"NumberFormatException was thrown for custom property com.ibm.ws.sib.comms.client.impl.MaximumClientAsyncConsumerThreadPoolSize", (Object)nfe);
            }
            MAX_THREADS = 10;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Max async consumer threads: " + MAX_THREADS));
        }
        instance = new AsynchConsumerThreadPool();
    }

    private static class EmptyScheduleQueueStack {
        private ScheduleQueue[] stackArray;
        private int currentStackSize = 0;

        private EmptyScheduleQueueStack(int maxStackSize) {
            this.stackArray = new ScheduleQueue[maxStackSize];
        }

        public synchronized void push(ScheduleQueue queue) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"EmptyScheduleQueueStack.push", (Object)queue);
            }
            boolean alreadyOnStack = false;
            for (int i = 0; i < this.currentStackSize; ++i) {
                alreadyOnStack |= this.stackArray[i] == queue;
            }
            if (!alreadyOnStack) {
                this.stackArray[this.currentStackSize] = queue;
                ++this.currentStackSize;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"EmptyScheduleQueueStack.push");
            }
        }

        public synchronized ScheduleQueue pop() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"EmptyScheduleQueueStack.pop");
            }
            ScheduleQueue queue = null;
            if (this.currentStackSize != 0) {
                queue = this.stackArray[--this.currentStackSize];
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"EmptyScheduleQueueStack.pop", queue);
            }
            return queue;
        }
    }

    private class ScheduleQueue
    implements Runnable {
        LinkedList<AsynchConsumerProxyQueue> work = new LinkedList();
        private StateEnum state = StateEnum.IDLE_STATE;
        ThreadPool threadPool;
        private String CLASS_NAME_SCHQ = ScheduleQueue.class.getName();

        public ScheduleQueue(ThreadPool threadPool) {
            this.threadPool = threadPool;
        }

        public synchronized void addWork(AsynchConsumerProxyQueue queue) {
            block10: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"ScheduleQueue.addWork", (Object)queue);
                }
                this.work.addLast(queue);
                if (this.state != StateEnum.RUNNING_STATE) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"State != RUNNING_STATE");
                    }
                    if (this.state == StateEnum.WAITING_STATE) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"State == WAITING_STATE");
                        }
                        this.state = StateEnum.RUNNING_STATE;
                        this.notify();
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Servicing this queue");
                        }
                        try {
                            this.state = StateEnum.RUNNING_STATE;
                            this.threadPool.execute(this);
                        }
                        catch (InterruptedException e) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Interrupted", (Object)e);
                        }
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"ScheduleQueue.addWork");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"ScheduleQueue.run");
                }
                AsynchConsumerProxyQueue queue = null;
                ScheduleQueue scheduleQueue = this;
                // MONITORENTER : scheduleQueue
                queue = this.work.removeFirst();
                // MONITOREXIT : scheduleQueue
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Processing queue: " + queue));
                }
                boolean running = true;
                while (running) {
                    block22: {
                        try {
                            queue.deliverMessages();
                        }
                        catch (RuntimeException re) {
                            FFDCFilter.processException((Throwable)re, (String)(this.CLASS_NAME_SCHQ + ".run"), (String)"1-017-0001", (Object)this);
                        }
                        ScheduleQueue scheduleQueue2 = this;
                        // MONITORENTER : scheduleQueue2
                        if (this.work.isEmpty()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Work queue is empty");
                            }
                            this.state = StateEnum.WAITING_STATE;
                            Map map = AsynchConsumerThreadPool.this.inUseScheduleQueues;
                            // MONITORENTER : map
                            AsynchConsumerThreadPool.this.emptyStack.push(this);
                            AsynchConsumerThreadPool.this.inUseScheduleQueues.remove(queue);
                            // MONITOREXIT : map
                            try {
                                this.wait(10000L);
                            }
                            catch (InterruptedException e) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Interrupted", (Object)e);
                                }
                                break block22;
                            }
                        }
                        AsynchConsumerThreadPool.this.inUseScheduleQueues.remove(queue);
                    }
                    if (this.state == StateEnum.RUNNING_STATE) {
                        queue = this.work.removeFirst();
                        AsynchConsumerThreadPool.this.inUseScheduleQueues.put(queue, this);
                    } else {
                        this.state = StateEnum.IDLE_STATE;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("State is now: " + (Object)((Object)this.state)));
                    }
                    running = this.state == StateEnum.RUNNING_STATE;
                    // MONITOREXIT : scheduleQueue2
                }
            }
            catch (RuntimeException re) {
                FFDCFilter.processException((Throwable)re, (String)(this.CLASS_NAME_SCHQ + ".run"), (String)"1-017-0002", (Object)this);
                throw re;
            }
            catch (Error err) {
                FFDCFilter.processException((Throwable)err, (String)(this.CLASS_NAME_SCHQ + ".run"), (String)"1-017-0003", (Object)this);
                throw err;
            }
            if (!TraceComponent.isAnyTracingEnabled()) return;
            if (!tc.isEntryEnabled()) return;
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"ScheduleQueue.run");
        }
    }

    static enum StateEnum {
        IDLE_STATE,
        RUNNING_STATE,
        WAITING_STATE;

    }
}

