/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.config.ConfigAdapter;
import com.ibm.ws.transport.iiop.internal.ServerPolicySourceImpl;
import com.ibm.ws.transport.iiop.spi.AdapterActivatorOp;
import com.ibm.ws.transport.iiop.spi.ClientORBRef;
import com.ibm.ws.transport.iiop.spi.IIOPEndpoint;
import com.ibm.ws.transport.iiop.spi.ORBRef;
import com.ibm.ws.transport.iiop.spi.ServerPolicySource;
import com.ibm.ws.transport.iiop.spi.SubsystemFactory;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.rmi.CORBA.Util;
import org.apache.felix.scr.ext.annotation.DSExt;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyManager;
import org.omg.CORBA.SetOverrideType;
import org.omg.PortableServer.AdapterActivator;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(factory="com.ibm.ws.transport.iiop.internal.ORBWrapperInternal", property={"service.vendor=IBM"})
@DSExt.PersistentFactoryComponent
public class ORBWrapperInternal
extends ServerPolicySourceImpl
implements ORBRef,
ClientORBRef,
ServerPolicySource {
    private static final TraceComponent tc = Tr.register(ORBWrapperInternal.class, (String)"IIOP", (String)"com.ibm.ws.transport.iiop.resources.IiopMessages");
    private static final String KEY = "AdapterActivatorOp";
    private static final String POA_NAME = "POAName";
    private ConfigAdapter configAdapter;
    private ORB orb;
    private POA rootPOA;
    private final List<IIOPEndpoint> endpoints = new ArrayList<IIOPEndpoint>();
    private final Map<String, java.lang.Object> extraConfig = new HashMap<String, java.lang.Object>();
    private final transient ConcurrentServiceReferenceMap<String, AdapterActivatorOp> map = new ConcurrentServiceReferenceMap("AdapterActivatorOp");
    private final CheckpointPhase checkpointPhase = CheckpointPhase.getPhase();
    static final long serialVersionUID = 3282688190881194001L;

    @Activate
    protected void activate(Map<String, java.lang.Object> properties, ComponentContext cc) throws Exception {
        this.map.activate(cc);
        super.activate(properties, cc.getBundleContext());
        try {
            if (this.checkpointPhase != CheckpointPhase.INACTIVE) {
                Util.createValueHandler().getRunTimeCodeBase();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transport.iiop.internal.ORBWrapperInternal", (String)"91", (java.lang.Object)this, (java.lang.Object[])new java.lang.Object[]{properties, cc});
        }
        try {
            if (this.endpoints.isEmpty()) {
                this.orb = this.configAdapter.createClientORB(properties, this.subsystemFactories);
            } else {
                this.orb = this.configAdapter.createServerORB(properties, this.extraConfig, this.endpoints, this.subsystemFactories);
                Object obj = this.orb.resolve_initial_references("RootPOA");
                this.rootPOA = POAHelper.narrow((Object)obj);
                this.rootPOA.the_activator((AdapterActivator)new DelegatingAdapterActivator());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("activate() using ORB: " + this.orb), (java.lang.Object[])new java.lang.Object[0]);
            }
            PolicyManager policyManager = (PolicyManager)this.orb.resolve_initial_references("ORBPolicyManager");
            ArrayList<Policy> policies = new ArrayList<Policy>();
            for (SubsystemFactory sf : this.subsystemFactories) {
                Policy policy = sf.getClientPolicy(this.orb, properties);
                if (policy == null) continue;
                policies.add(policy);
            }
            policyManager.set_policy_overrides(policies.toArray(new Policy[policies.size()]), SetOverrideType.ADD_OVERRIDE);
            for (IIOPEndpoint endpoint : this.endpoints) {
                Tr.audit((TraceComponent)tc, (String)"NAME_SERVER_AVAILABLE", (java.lang.Object[])new java.lang.Object[]{"corbaloc:iiop:" + endpoint.getHost() + ":" + endpoint.getIiopPort() + "/NameService"});
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            FFDCFilter.processException((Throwable)noSuchMethodError, (String)"com.ibm.ws.transport.iiop.internal.ORBWrapperInternal", (String)"118", (java.lang.Object)this, (java.lang.Object[])new java.lang.Object[]{properties, cc});
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transport.iiop.internal.ORBWrapperInternal", (String)"123", (java.lang.Object)this, (java.lang.Object[])new java.lang.Object[]{properties, cc});
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        if (this.orb != null) {
            this.orb.destroy();
            this.orb = null;
            for (IIOPEndpoint endpoint : this.endpoints) {
                Tr.audit((TraceComponent)tc, (String)"NAME_SERVER_UNAVAILABLE", (java.lang.Object[])new java.lang.Object[]{"corbaloc:iiop:" + endpoint.getHost() + ":" + endpoint.getIiopPort() + "/NameService"});
            }
        }
        super.deactivate();
        this.map.deactivate(cc);
    }

    @Reference
    protected void setConfigAdapter(ConfigAdapter configAdapter) {
        this.configAdapter = configAdapter;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setIiopEndpoint(IIOPEndpoint ep) {
        this.endpoints.add(ep);
    }

    @Reference(service=AdapterActivatorOp.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setAdapterActivatorOp(ServiceReference<AdapterActivatorOp> ops) {
        this.map.putReference((java.lang.Object)((String)ops.getProperty(POA_NAME)), ops);
    }

    protected void unsetAdapterActivatorOp(ServiceReference<AdapterActivatorOp> ops) {
        this.map.removeReference((java.lang.Object)((String)ops.getProperty(POA_NAME)), ops);
    }

    @Override
    public ORB getORB() {
        return this.orb;
    }

    @Override
    public POA getPOA() {
        return this.rootPOA;
    }

    @Override
    public Map<String, java.lang.Object> getExtraConfig() {
        return this.extraConfig;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class DelegatingAdapterActivator
    extends LocalObject
    implements AdapterActivator {
        private static final long serialVersionUID = 1L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private DelegatingAdapterActivator() {
        }

        public boolean unknown_adapter(POA parent, String name) {
            AdapterActivatorOp ops = (AdapterActivatorOp)ORBWrapperInternal.this.map.getService((java.lang.Object)name);
            if (ops != null) {
                return ops.unknown_adapter(parent, name, ORBWrapperInternal.this);
            }
            return false;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.transport.iiop.internal.ORBWrapperInternal$DelegatingAdapterActivator", DelegatingAdapterActivator.class, (String)"IIOP", (String)"com.ibm.ws.transport.iiop.resources.IiopMessages");
        }
    }
}

