/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.transaction;

import com.ibm.tx.jta.embeddable.EmbeddableTransactionManagerFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.transaction.ServerTransactionPolicy;
import com.ibm.ws.transport.iiop.transaction.ServerTransactionPolicyConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.Codec;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ServerTransactionInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(ServerTransactionInterceptor.class, null, null);
    private final Codec codec;
    private final TransactionManager tranManager;
    private final Map<Integer, Transaction> txMap;

    public ServerTransactionInterceptor(Codec codec) {
        this.codec = codec;
        this.tranManager = EmbeddableTransactionManagerFactory.getTransactionManager();
        this.txMap = new ConcurrentHashMap<Integer, Transaction>();
    }

    /*
     * WARNING - void declaration
     */
    public void receive_request(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        block10: {
            try {
                Transaction currentTx = this.txMap.remove(serverRequestInfo.request_id());
                if (currentTx != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"colocated call, resuming transaction on dispatch thread", (Object[])new Object[0]);
                    }
                    this.tranManager.resume(currentTx);
                    return;
                }
            }
            catch (InvalidTransactionException currentTx) {
                FFDCFilter.processException((Throwable)currentTx, (String)"com.ibm.ws.transport.iiop.transaction.ServerTransactionInterceptor", (String)"62", (Object)((Object)this), (Object[])new Object[]{serverRequestInfo});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)"Could not resume transaction", (Object[])new Object[]{e});
                }
            }
            catch (IllegalStateException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.transport.iiop.transaction.ServerTransactionInterceptor", (String)"65", (Object)((Object)this), (Object[])new Object[]{serverRequestInfo});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Could not resume transaction", (Object[])new Object[]{e});
                }
            }
            catch (SystemException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.transport.iiop.transaction.ServerTransactionInterceptor", (String)"68", (Object)((Object)this), (Object[])new Object[]{serverRequestInfo});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                Tr.debug((TraceComponent)tc, (String)"Could not resume transaction", (Object[])new Object[]{e});
            }
        }
        ServerTransactionPolicy policy = (ServerTransactionPolicy)serverRequestInfo.get_server_policy(1095976450);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"receive_request has retrieved transaction policy - ", (Object[])new Object[]{policy});
        }
        if (policy != null) {
            ServerTransactionPolicyConfig serverTransactionPolicyConfig = policy.getServerTransactionPolicyConfig();
            serverTransactionPolicyConfig.importTransaction(serverRequestInfo, this.codec);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        block4: {
            try {
                Transaction currentTx = this.tranManager.suspend();
                if (currentTx != null) {
                    int requestId = ri.request_id();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("suspend transaction " + currentTx + ", and put in map with requestId " + requestId), (Object[])new Object[0]);
                    }
                    this.txMap.put(requestId, currentTx);
                }
            }
            catch (SystemException requestId) {
                void e;
                FFDCFilter.processException((Throwable)requestId, (String)"com.ibm.ws.transport.iiop.transaction.ServerTransactionInterceptor", (String)"97", (Object)((Object)this), (Object[])new Object[]{ri});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Could not suspend transaction", (Object[])new Object[]{e});
            }
        }
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
        this.suspendTxOnSend();
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
        this.suspendTxOnSend();
    }

    public void send_reply(ServerRequestInfo ri) {
        this.suspendTxOnSend();
    }

    /*
     * WARNING - void declaration
     */
    private void suspendTxOnSend() {
        block2: {
            try {
                this.tranManager.suspend();
            }
            catch (SystemException systemException) {
                void e;
                FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.transport.iiop.transaction.ServerTransactionInterceptor", (String)"125", (Object)((Object)this), (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Could not suspend transaction", (Object[])new Object[]{e});
            }
        }
    }

    public void destroy() {
    }

    public String name() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

