/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.subsystem;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.AppForceRestart;
import com.ibm.ws.kernel.feature.ProcessType;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureManifestException;
import com.ibm.ws.kernel.feature.internal.subsystem.SubsystemFeatureDefinitionImpl;
import com.ibm.ws.kernel.feature.provisioning.ActivationType;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.feature.LibertyFeature;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class FeatureRepository
implements FeatureResolver.Repository {
    private static final TraceComponent tc = Tr.register(FeatureRepository.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
    private static final int FEATURE_CACHE_VERSION = 4;
    private static final String EMPTY = "";
    private boolean isDirty;
    private boolean cacheOk = true;
    private final WsResource cacheResource;
    private final BundleContext bundleContext;
    private volatile Set<String> resolvedFeatures = Collections.emptySet();
    private volatile Set<String> platforms = Collections.emptySet();
    private volatile String platformEnvVar = null;
    private volatile Set<String> configuredFeatures = Collections.emptySet();
    private volatile boolean configurationError = true;
    private final Map<String, SubsystemFeatureDefinitionImpl> installedFeatures = new HashMap<String, SubsystemFeatureDefinitionImpl>();
    private final Map<String, String> publicFeatureNameToSymbolicName = new HashMap<String, String>();
    private final Map<String, String> alternateFeatureNameToPublicName = new HashMap<String, String>();
    private final ConcurrentMap<String, LibertyFeatureServiceFactory> featureServiceFactories = new ConcurrentHashMap<String, LibertyFeatureServiceFactory>();
    private Map<File, SubsystemFeatureDefinitionImpl> knownGoodFeatureFiles;
    private Map<File, BadFeature> knownBadFeatureFiles;
    private List<SubsystemFeatureDefinitionImpl> autoFeatures;
    private Map<String, SubsystemFeatureDefinitionImpl> compatibilityFeatures;
    private static final String TOLERATE_PREFIX = "tolerates.";
    private static String FEATURE_SERVICE_NAME = "ibm.featureName";
    private static String FEATURE_SERVICE_SYMBOLIC_NAME = "osgi.symbolicName";
    private static String FEATURE_SERVICE_VERSION = "osgi.version";
    private static String FEATURE_SERVICE_CATEGORY = "osgi.category";
    private static final String FEATURE_SUBSYSTEM_CATEGORY = "Subsystem-Category";
    static final long serialVersionUID = -7734563436556075515L;

    private static void debug(String message, String parm) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)message, (Object[])new Object[]{parm});
        }
    }

    private static void debug(String message) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)message, (Object[])new Object[0]);
        }
    }

    public static int getCacheVersion() {
        return 4;
    }

    public FeatureRepository() {
        this.cacheResource = null;
        this.isDirty = true;
        this.bundleContext = null;
    }

    public FeatureRepository(WsResource res, BundleContext bundleContext) {
        this.cacheResource = res;
        this.bundleContext = bundleContext;
    }

    public String matchesAlternate(String featureName) {
        return this.alternateFeatureNameToPublicName.get(FeatureRepository.lowerFeature(featureName));
    }

    public boolean disableAllFeaturesOnConflict(String featureName) {
        SubsystemFeatureDefinitionImpl feature = (SubsystemFeatureDefinitionImpl)this.getFeature(featureName);
        if (feature != null) {
            return feature.getImmutableAttributes().disableOnConflict;
        }
        return false;
    }

    public void init() {
        this.isDirty = false;
        boolean firstInit = this.installedFeatures.isEmpty();
        this.autoFeatures = new ArrayList<SubsystemFeatureDefinitionImpl>();
        this.knownGoodFeatureFiles = new HashMap<File, SubsystemFeatureDefinitionImpl>();
        this.knownBadFeatureFiles = new HashMap<File, BadFeature>();
        this.compatibilityFeatures = new HashMap<String, SubsystemFeatureDefinitionImpl>();
        this.readCache(firstInit);
        this.readFeatureManifests();
        if (this.isDirty && firstInit) {
            this.resolvedFeatures = Collections.emptySet();
            this.configuredFeatures = Collections.emptySet();
            this.platforms = Collections.emptySet();
            this.platformEnvVar = null;
        }
    }

    public void dispose() {
        this.storeCache();
        this.autoFeatures = null;
        this.knownGoodFeatureFiles = null;
        this.knownBadFeatureFiles = null;
        this.compatibilityFeatures = null;
        for (SubsystemFeatureDefinitionImpl def : this.installedFeatures.values()) {
            def.setProvisioningDetails(null);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readCache(boolean firstInit) {
        String envVar;
        HashSet<String> cachedPlatforms;
        boolean configError;
        HashMap<File, BadFeature> knownBad;
        HashSet<String> configured;
        HashSet<String> resolved;
        ArrayList<SubsystemFeatureDefinitionImpl> cachedInstalledFeatures;
        block33: {
            if (!this.cacheOk) return;
            if (this.cacheResource == null) return;
            if (!this.cacheResource.exists()) {
                return;
            }
            cachedInstalledFeatures = new ArrayList<SubsystemFeatureDefinitionImpl>();
            resolved = new HashSet<String>();
            configured = new HashSet<String>();
            knownBad = new HashMap<File, BadFeature>();
            configError = false;
            cachedPlatforms = new HashSet<String>();
            envVar = null;
            try {
                InputStream input = this.cacheResource.get();
                try {
                    DataInputStream in;
                    block32: {
                        block30: {
                            in = new DataInputStream(new BufferedInputStream(input));
                            if (in.readInt() == FeatureRepository.getCacheVersion()) break block30;
                            in.close();
                            if (input == null) return;
                            input.close();
                            return;
                        }
                        try {
                            int numFeatures = in.readInt();
                            for (int i = 0; i < numFeatures; ++i) {
                                FeatureDefinitionUtils.ImmutableAttributes installedAttr;
                                FeatureDefinitionUtils.ImmutableAttributes cachedAttr = FeatureRepository.loadFeatureAttributes(in);
                                FeatureDefinitionUtils.ProvisioningDetails cachedDetails = FeatureRepository.loadProvisioningDetails(in, cachedAttr);
                                String symbolicName = cachedAttr.symbolicName;
                                SubsystemFeatureDefinitionImpl installedFeature = this.installedFeatures.get(symbolicName);
                                FeatureDefinitionUtils.ImmutableAttributes immutableAttributes = installedAttr = installedFeature == null ? null : installedFeature.getImmutableAttributes();
                                if (!cachedAttr.featureFile.exists()) {
                                    cachedAttr = null;
                                } else if (installedAttr != null) {
                                    cachedAttr = installedAttr;
                                }
                                if (cachedAttr != null) {
                                    if (installedAttr == cachedAttr) {
                                        installedFeature.setProvisioningDetails(cachedDetails);
                                    } else {
                                        if (!firstInit) {
                                            this.isDirty = true;
                                        }
                                        installedFeature = new SubsystemFeatureDefinitionImpl(cachedAttr, cachedDetails);
                                    }
                                } else if (installedAttr != null) {
                                    this.isDirty = true;
                                    this.installedFeatures.remove(symbolicName);
                                    installedFeature = null;
                                } else {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"cacheAttr and newAttr BOTH null while reading cache", (Object[])new Object[]{symbolicName});
                                    }
                                    this.isDirty = true;
                                    installedFeature = null;
                                }
                                cachedInstalledFeatures.add(installedFeature);
                            }
                            int numResolved = in.readInt();
                            for (int i = 0; i < numResolved; ++i) {
                                resolved.add(in.readUTF());
                            }
                            int numConfigured = in.readInt();
                            for (int i = 0; i < numConfigured; ++i) {
                                configured.add(in.readUTF());
                            }
                            configError = in.readBoolean();
                            int numBad = in.readInt();
                            for (int i = 0; i < numBad; ++i) {
                                File f = new File(in.readUTF());
                                long lastModified = in.readLong();
                                long length = in.readLong();
                                if (!f.isFile()) continue;
                                knownBad.put(f, new BadFeature(lastModified, length));
                            }
                            int numPlatforms = in.readInt();
                            for (int i = 0; i < numPlatforms; ++i) {
                                cachedPlatforms.add(in.readUTF());
                            }
                            boolean hasPlatformEnv = in.readBoolean();
                            if (!hasPlatformEnv) break block32;
                            envVar = in.readUTF();
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository", (String)"303", (Object)this, (Object[])new Object[]{firstInit});
                            try {
                                in.close();
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository", (String)"303", (Object)this, (Object[])new Object[]{firstInit});
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    in.close();
                    if (input == null) break block33;
                }
                catch (Throwable in) {
                    FFDCFilter.processException((Throwable)in, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository", (String)"303", (Object)this, (Object[])new Object[]{firstInit});
                    if (input == null) throw in;
                    try {
                        input.close();
                        throw in;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository", (String)"303", (Object)this, (Object[])new Object[]{firstInit});
                        in.addSuppressed(throwable);
                    }
                    throw in;
                }
                input.close();
            }
            catch (IOException input) {
                void e;
                FFDCFilter.processException((Throwable)input, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository", (String)"399", (Object)this, (Object[])new Object[]{firstInit});
                this.cacheWarning((IOException)e);
                return;
            }
        }
        this.resolvedFeatures = Collections.unmodifiableSet(resolved);
        this.configuredFeatures = Collections.unmodifiableSet(configured);
        this.platforms = Collections.unmodifiableSet(cachedPlatforms);
        this.configurationError = configError;
        this.knownBadFeatureFiles.putAll(knownBad);
        this.platformEnvVar = envVar;
        Iterator iterator = cachedInstalledFeatures.iterator();
        while (iterator.hasNext()) {
            SubsystemFeatureDefinitionImpl cachedInstalledFeature = (SubsystemFeatureDefinitionImpl)iterator.next();
            this.updateMaps(cachedInstalledFeature);
        }
    }

    public Set<String> getPlatformsForVersionlessFeature(String versionlessFeatureName) {
        ProvisioningFeatureDefinition versionlessFeature = this.getFeature(versionlessFeatureName);
        HashSet<String> platforms = new HashSet<String>();
        if (versionlessFeature != null && versionlessFeature.isVersionless()) {
            for (ProvisioningFeatureDefinition child : this.findAllPossibleVersions(versionlessFeature)) {
                if (child == null) continue;
                platforms.addAll(child.getPlatformNames());
            }
        }
        return platforms;
    }

    public String getVersionlessFeatureVersionForPlatform(String versionlessFeatureName, String platformName) {
        ProvisioningFeatureDefinition versionlessFeature = this.getFeature(versionlessFeatureName);
        if (versionlessFeature != null && versionlessFeature.isVersionless()) {
            for (ProvisioningFeatureDefinition child : this.findAllPossibleVersions(versionlessFeature)) {
                if (!child.getPlatformNames().contains(platformName)) continue;
                return child.getIbmShortName();
            }
        }
        return null;
    }

    private List<ProvisioningFeatureDefinition> findAllPossibleVersions(ProvisioningFeatureDefinition versionlessFeature) {
        ArrayList<ProvisioningFeatureDefinition> result = new ArrayList<ProvisioningFeatureDefinition>();
        for (FeatureResource dependency : versionlessFeature.getConstituents(null)) {
            result.add(this.getVersionedFeature(dependency.getSymbolicName()));
            String baseName = this.getFeatureBaseNameWithDash(dependency.getSymbolicName());
            List<String> tolerates = dependency.getTolerates();
            if (tolerates == null) continue;
            for (String toleratedVersion : tolerates) {
                String featureName = baseName + toleratedVersion;
                result.add(this.getVersionedFeature(featureName));
            }
        }
        return result;
    }

    private ProvisioningFeatureDefinition getVersionedFeature(String versionlessLinkingFeatureName) {
        ProvisioningFeatureDefinition result = null;
        ProvisioningFeatureDefinition feature = this.getFeature(versionlessLinkingFeatureName);
        if (feature != null) {
            for (FeatureResource versionedFeature : feature.getConstituents(null)) {
                ProvisioningFeatureDefinition versionedFeatureDef = this.getFeature(versionedFeature.getSymbolicName());
                if (versionedFeatureDef == null || versionedFeatureDef.getVisibility() != Visibility.PUBLIC) continue;
                result = versionedFeatureDef;
            }
        }
        return result;
    }

    private String getFeatureBaseNameWithDash(String nameAndVersion) {
        int dashPosition = nameAndVersion.lastIndexOf(45);
        if (dashPosition != -1) {
            return nameAndVersion.substring(0, dashPosition + 1);
        }
        return nameAndVersion;
    }

    public String getFeatureBaseName(String nameAndVersion) {
        int dashPosition = nameAndVersion.lastIndexOf(45);
        if (dashPosition != -1) {
            return nameAndVersion.substring(0, dashPosition);
        }
        return nameAndVersion;
    }

    public Set<String> getCommonPlatformsForFeatureSet(Set<String> features) {
        HashSet<String> commonPlatforms = null;
        for (String featureName : features) {
            ProvisioningFeatureDefinition versionedFeature = this.getFeature(featureName);
            if (versionedFeature == null || versionedFeature.isVersionless()) continue;
            HashSet<String> featurePlatforms = new HashSet<String>(versionedFeature.getPlatformNames());
            if (commonPlatforms == null) {
                commonPlatforms = featurePlatforms;
                continue;
            }
            commonPlatforms.retainAll(featurePlatforms);
        }
        return commonPlatforms;
    }

    /*
     * WARNING - void declaration
     */
    public void storeCache() {
        if (!this.cacheOk || this.cacheResource == null || !this.isDirty) {
            return;
        }
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(this.cacheResource.putStream()));
            try {
                ArrayList<AbstractMap.SimpleEntry<FeatureDefinitionUtils.ImmutableAttributes, FeatureDefinitionUtils.ProvisioningDetails>> features = new ArrayList<AbstractMap.SimpleEntry<FeatureDefinitionUtils.ImmutableAttributes, FeatureDefinitionUtils.ProvisioningDetails>>();
                for (SubsystemFeatureDefinitionImpl subsystemFeatureDefinitionImpl : this.installedFeatures.values()) {
                    FeatureDefinitionUtils.ImmutableAttributes immutableAttributes = subsystemFeatureDefinitionImpl.getImmutableAttributes();
                    FeatureDefinitionUtils.ProvisioningDetails provDetails = subsystemFeatureDefinitionImpl.getProvisioningDetails();
                    if (immutableAttributes != null && provDetails != null) {
                        features.add(new AbstractMap.SimpleEntry<FeatureDefinitionUtils.ImmutableAttributes, FeatureDefinitionUtils.ProvisioningDetails>(immutableAttributes, provDetails));
                        continue;
                    }
                    FeatureRepository.debug("Unable to write out " + subsystemFeatureDefinitionImpl.getFeatureName() + " to cache because the provisioning detail: " + provDetails + " or imAttrs: " + immutableAttributes + " is null");
                }
                out.writeInt(FeatureRepository.getCacheVersion());
                out.writeInt(features.size());
                for (Map.Entry entry : features) {
                    FeatureRepository.writeFeatureAttributes((FeatureDefinitionUtils.ImmutableAttributes)entry.getKey(), (FeatureDefinitionUtils.ProvisioningDetails)entry.getValue(), out);
                }
                Set<String> curResolved = this.resolvedFeatures;
                out.writeInt(curResolved.size());
                for (String string : curResolved) {
                    out.writeUTF(string);
                }
                Set<String> set = this.configuredFeatures;
                out.writeInt(set.size());
                for (String configured : set) {
                    out.writeUTF(configured);
                }
                out.writeBoolean(this.configurationError);
                Map<File, BadFeature> map = this.knownBadFeatureFiles;
                out.writeInt(map.size());
                for (Map.Entry<File, BadFeature> entry : this.knownBadFeatureFiles.entrySet()) {
                    out.writeUTF(entry.getKey().getAbsolutePath());
                    out.writeLong(entry.getValue().lastModified);
                    out.writeLong(entry.getValue().length);
                }
                out.writeInt(this.platforms.size());
                for (String plat : this.platforms) {
                    out.writeUTF(plat);
                }
                if (this.platformEnvVar == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    out.writeUTF(this.platformEnvVar);
                }
                this.isDirty = false;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository", (String)"571", (Object)this, (Object[])new Object[0]);
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository", (String)"571", (Object)this, (Object[])new Object[0]);
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            out.close();
        }
        catch (IOException out) {
            void e;
            FFDCFilter.processException((Throwable)out, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository", (String)"635", (Object)this, (Object[])new Object[0]);
            this.cacheWarning((IOException)e);
        }
    }

    static void writeFeatureAttributes(FeatureDefinitionUtils.ImmutableAttributes iAttr, FeatureDefinitionUtils.ProvisioningDetails details, DataOutputStream out) throws IOException {
        if (iAttr == null || details == null) {
            throw new NullPointerException("Both attributes and details are required for caching: attr=" + iAttr + ", details=" + details);
        }
        out.writeUTF(iAttr.bundleRepositoryType == null ? EMPTY : iAttr.bundleRepositoryType);
        out.writeUTF(iAttr.symbolicName);
        out.writeUTF(iAttr.featureFile == null ? EMPTY : iAttr.featureFile.getAbsolutePath());
        out.writeLong(iAttr.lastModified);
        out.writeLong(iAttr.length);
        out.writeUTF(iAttr.shortName == null ? EMPTY : iAttr.shortName);
        out.writeInt(iAttr.featureVersion);
        out.writeUTF(iAttr.visibility.toString());
        out.writeUTF(iAttr.appRestart.toString());
        out.writeInt(iAttr.version.getMajor());
        out.writeInt(iAttr.version.getMinor());
        out.writeInt(iAttr.version.getMicro());
        String qualifier = iAttr.version.getQualifier();
        out.writeUTF(qualifier == null ? EMPTY : qualifier);
        out.writeBoolean(iAttr.isAutoFeature);
        out.writeBoolean(iAttr.hasApiServices);
        out.writeBoolean(iAttr.hasApiPackages);
        out.writeBoolean(iAttr.hasSpiPackages);
        out.writeBoolean(iAttr.isSingleton);
        out.writeBoolean(iAttr.disableOnConflict);
        out.writeInt(iAttr.processTypes.size());
        for (ProcessType type : iAttr.processTypes) {
            out.writeUTF(type.toString());
        }
        out.writeUTF(iAttr.activationType.toString());
        out.writeInt(iAttr.alternateNames.size());
        for (String s : iAttr.alternateNames) {
            out.writeUTF(s);
        }
        out.writeInt(iAttr.platforms.size());
        for (String s : iAttr.platforms) {
            out.writeUTF(s);
        }
        if (iAttr.isAutoFeature) {
            FeatureRepository.writeLongString(out, details.getCachedRawHeader("IBM-Provision-Capability"));
        }
        if (iAttr.hasApiServices) {
            FeatureRepository.writeLongString(out, details.getCachedRawHeader("IBM-API-Service"));
        }
        if (iAttr.hasApiPackages) {
            FeatureRepository.writeLongString(out, details.getCachedRawHeader("IBM-API-Package"));
        }
        if (iAttr.hasSpiPackages) {
            FeatureRepository.writeLongString(out, details.getCachedRawHeader("IBM-SPI-Package"));
        }
    }

    private static void writeLongString(DataOutputStream out, String longString) throws IOException {
        byte[] data = longString.getBytes();
        if (data.length > 65535) {
            out.writeBoolean(true);
            out.writeInt(data.length);
            out.write(data);
        } else {
            out.writeBoolean(false);
            out.writeUTF(longString);
        }
    }

    private static String readLongString(DataInputStream in) throws IOException {
        if (in.readBoolean()) {
            byte[] data = new byte[in.readInt()];
            in.readFully(data);
            return new String(data, StandardCharsets.UTF_8);
        }
        return in.readUTF();
    }

    static FeatureDefinitionUtils.ImmutableAttributes loadFeatureAttributes(DataInputStream in) throws IOException {
        String repositoryType = in.readUTF();
        if (repositoryType.isEmpty()) {
            repositoryType = EMPTY;
        }
        String symbolicName = in.readUTF();
        String featurePath = in.readUTF();
        File featureFile = featurePath.isEmpty() ? null : new File(featurePath);
        long lastModified = in.readLong();
        long fileSize = in.readLong();
        String shortName = in.readUTF();
        if (shortName.isEmpty()) {
            shortName = null;
        }
        int featureVersion = in.readInt();
        Visibility visibility = FeatureRepository.valueOf(in.readUTF(), Visibility.PRIVATE);
        AppForceRestart appRestart = FeatureRepository.valueOf(in.readUTF(), AppForceRestart.NEVER);
        Version version = new Version(in.readInt(), in.readInt(), in.readInt(), in.readUTF());
        boolean isAutoFeature = in.readBoolean();
        boolean hasApiServices = in.readBoolean();
        boolean hasApiPackages = in.readBoolean();
        boolean hasSpiPackages = in.readBoolean();
        boolean isSingleton = in.readBoolean();
        boolean disableOnConflict = in.readBoolean();
        int processTypeNum = in.readInt();
        EnumSet<ProcessType> processTypes = EnumSet.noneOf(ProcessType.class);
        for (int i = 0; i < processTypeNum; ++i) {
            processTypes.add(FeatureRepository.valueOf(in.readUTF(), ProcessType.SERVER));
        }
        ActivationType activationType = FeatureRepository.valueOf(in.readUTF(), ActivationType.SEQUENTIAL);
        int altNamesCount = in.readInt();
        ArrayList<String> altNames = new ArrayList<String>(altNamesCount);
        for (int x = 0; x < altNamesCount; ++x) {
            altNames.add(in.readUTF());
        }
        int platformsCount = in.readInt();
        ArrayList<String> platforms = new ArrayList<String>(platformsCount);
        for (int i = 0; i < platformsCount; ++i) {
            platforms.add(in.readUTF());
        }
        return new FeatureDefinitionUtils.ImmutableAttributes(repositoryType, symbolicName, shortName, altNames, featureVersion, visibility, appRestart, version, featureFile, lastModified, fileSize, isAutoFeature, hasApiServices, hasApiPackages, hasSpiPackages, isSingleton, disableOnConflict, processTypes, activationType, platforms);
    }

    static FeatureDefinitionUtils.ProvisioningDetails loadProvisioningDetails(DataInputStream in, FeatureDefinitionUtils.ImmutableAttributes iAttr) throws IOException {
        String autoFeatureCapability = iAttr.isAutoFeature ? FeatureRepository.readLongString(in) : null;
        String apiServices = iAttr.hasApiServices ? FeatureRepository.readLongString(in) : null;
        String apiPackages = iAttr.hasApiPackages ? FeatureRepository.readLongString(in) : null;
        String spiPackages = iAttr.hasSpiPackages ? FeatureRepository.readLongString(in) : null;
        return new FeatureDefinitionUtils.ProvisioningDetails(iAttr, autoFeatureCapability, apiServices, apiPackages, spiPackages);
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    public static <T extends Enum<T>> T valueOf(String name, T defaultValue) {
        try {
            return (T)Enum.valueOf(defaultValue.getClass(), name);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    private void readFeatureManifests() {
        for (final BundleRepositoryRegistry.BundleRepositoryHolder holder : BundleRepositoryRegistry.holders()) {
            File libFeatureDir = new File(holder.getInstallDir(), "lib/features/");
            if (!libFeatureDir.isDirectory()) continue;
            libFeatureDir.listFiles(new FileFilter(){
                static final long serialVersionUID = 8518982116570981387L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean accept(File file) {
                    if (file == null) {
                        return false;
                    }
                    if (!file.isFile()) {
                        return false;
                    }
                    String name = file.getName();
                    int pos = name.lastIndexOf(46);
                    if (pos < 0) {
                        return false;
                    }
                    if (!name.regionMatches(true, pos, ".mf", 0, 3)) {
                        return false;
                    }
                    BadFeature bad = (BadFeature)FeatureRepository.this.knownBadFeatureFiles.get(file);
                    if (FeatureRepository.this.isFeatureStillBad(file, bad)) {
                        return false;
                    }
                    SubsystemFeatureDefinitionImpl def = (SubsystemFeatureDefinitionImpl)FeatureRepository.this.knownGoodFeatureFiles.get(file);
                    if (FeatureRepository.this.isCachedEntryValid(file, def)) {
                        return false;
                    }
                    FeatureRepository.this.isDirty = true;
                    try {
                        FeatureDefinitionUtils.ProvisioningDetails details = new FeatureDefinitionUtils.ProvisioningDetails(file, null);
                        FeatureDefinitionUtils.ImmutableAttributes attr = FeatureDefinitionUtils.loadAttributes(holder.getFeatureType(), file, details);
                        if (!attr.isSupportedFeatureVersion()) {
                            FeatureRepository.debug("Unsupported feature version [ " + file.getAbsolutePath() + " ]");
                            FeatureRepository.this.knownBadFeatureFiles.put(file, new BadFeature(file.lastModified(), file.length()));
                            return false;
                        }
                        def = new SubsystemFeatureDefinitionImpl(attr, details);
                        FeatureRepository.this.updateMaps(def);
                    }
                    catch (IOException details) {
                        void e;
                        FFDCFilter.processException((Throwable)details, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository$1", (String)"893", (Object)this, (Object[])new Object[]{file});
                        FeatureRepository.debug("Exception reading feature manifest [ " + file.getAbsolutePath() + " ]", e.toString());
                        FeatureRepository.this.knownBadFeatureFiles.put(file, new BadFeature(file.lastModified(), file.length()));
                    }
                    return false;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository$1", 1.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
                }
            });
        }
    }

    boolean isFeatureStillBad(File f, BadFeature bf) {
        return bf != null && f.lastModified() == bf.lastModified && f.length() == bf.length;
    }

    long reduceTimestampPrecision(long value) {
        return value / 1000L * 1000L;
    }

    boolean isCachedEntryValid(File f, SubsystemFeatureDefinitionImpl def) {
        if (def != null) {
            String platform;
            FeatureDefinitionUtils.ImmutableAttributes cachedAttr = def.getImmutableAttributes();
            if (this.reduceTimestampPrecision(cachedAttr.lastModified) == this.reduceTimestampPrecision(f.lastModified()) && cachedAttr.length == f.length()) {
                return true;
            }
            this.installedFeatures.remove(cachedAttr.symbolicName);
            this.publicFeatureNameToSymbolicName.remove(FeatureRepository.lowerFeature(cachedAttr.featureName));
            if (cachedAttr.isAutoFeature) {
                this.autoFeatures.remove(def);
            }
            if ((platform = FeatureRepository.getCompatibilityPlatform(def, cachedAttr)) != null) {
                this.removeCompatibilityFeature(platform);
            }
        }
        return false;
    }

    private void updateMaps(SubsystemFeatureDefinitionImpl def) {
        if (def == null) {
            return;
        }
        FeatureDefinitionUtils.ImmutableAttributes attr = def.getImmutableAttributes();
        SubsystemFeatureDefinitionImpl oldDef = this.installedFeatures.put(attr.symbolicName, def);
        if (oldDef != null && !oldDef.equals(def)) {
            this.installedFeatures.put(attr.symbolicName, oldDef);
            FeatureManifestException fme = new FeatureManifestException("Duplicate symbolic name: " + attr.symbolicName + ", " + def.getFeatureDefinitionFile().getAbsolutePath() + " will be ignored. The file " + oldDef.getFeatureDefinitionFile().getAbsolutePath() + " will be used instead.", (String)null);
            FFDCFilter.processException((Throwable)fme, (String)this.getClass().getName(), (String)"updateMaps", (Object)this, (Object[])new Object[]{oldDef, def});
            File file = attr.featureFile;
            this.knownBadFeatureFiles.put(file, new BadFeature(file.lastModified(), file.length()));
            return;
        }
        this.knownGoodFeatureFiles.put(attr.featureFile, def);
        if (!attr.featureName.equals(attr.symbolicName)) {
            this.publicFeatureNameToSymbolicName.put(FeatureRepository.lowerFeature(attr.featureName), attr.symbolicName);
        }
        if (def.getVisibility() == Visibility.PUBLIC) {
            this.publicFeatureNameToSymbolicName.put(FeatureRepository.lowerFeature(attr.symbolicName), attr.symbolicName);
        } else if (def.getVisibility() == Visibility.PRIVATE && attr.platforms != null && !attr.platforms.isEmpty()) {
            for (String plat : def.getPlatformNames()) {
                this.putCompatibilityFeature(plat, def);
            }
        }
        for (String s : attr.alternateNames) {
            this.alternateFeatureNameToPublicName.put(s, attr.featureName);
        }
        if (def.isCompatibility()) {
            this.compatibilityFeatures.put(def.getPlatformName().toLowerCase(), def);
        }
        if (attr.isAutoFeature) {
            this.autoFeatures.add(def);
        }
    }

    private void cacheWarning(IOException ioe) {
        if (this.cacheOk) {
            this.cacheOk = false;
            Tr.warning((TraceComponent)tc, (String)"UPDATE_BUNDLE_CACHE_WARNING", (Object[])new Object[]{this.cacheResource.toExternalURI(), ioe.toString()});
        }
    }

    public void setPlatforms(Set<String> platforms) {
        this.platforms = platforms;
    }

    public Set<String> getPlatforms() {
        return this.platforms;
    }

    public void setPlatformEnvVar(String platformEnvVar) {
        this.platformEnvVar = FeatureRepository.consumeEmpty(platformEnvVar);
    }

    public String getPlatformEnvVar() {
        return this.platformEnvVar;
    }

    @Deprecated
    public void setInstalledFeatures(Set<String> newResolvedFeatures, Set<String> newConfiguredFeatures, boolean configurationError) {
        this.setResolvedFeatures(newResolvedFeatures, newConfiguredFeatures, configurationError, this.platforms, this.platformEnvVar);
    }

    @Deprecated
    public Set<String> getInstalledFeatures() {
        return this.getResolvedFeatures();
    }

    public void setResolvedFeatures(Set<String> newResolvedFeatures, Set<String> newConfiguredFeatures, boolean configurationError, Set<String> newConfiguredPlatforms, String platformEnv) {
        Set<String> current = this.resolvedFeatures;
        if (!current.equals(newResolvedFeatures)) {
            this.isDirty = true;
        }
        this.resolvedFeatures = newResolvedFeatures.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(newResolvedFeatures));
        current = this.configuredFeatures;
        if (!current.equals(newConfiguredFeatures)) {
            this.isDirty = true;
        }
        this.configuredFeatures = newConfiguredFeatures.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(newConfiguredFeatures));
        current = this.platforms;
        if (!current.equals(newConfiguredPlatforms)) {
            this.isDirty = true;
        }
        this.platforms = newConfiguredPlatforms.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(newConfiguredPlatforms));
        this.platformEnvVar = FeatureRepository.consumeEmpty(platformEnv);
        this.configurationError = configurationError;
    }

    public Set<String> getResolvedFeatures() {
        return this.resolvedFeatures;
    }

    public Set<String> getConfiguredFeatures() {
        return this.configuredFeatures;
    }

    public boolean hasConfigurationError() {
        return this.configurationError;
    }

    @Deprecated
    public void copyInstalledFeaturesTo(Set<String> features) {
        this.copyResolvedFeaturesTo(features);
    }

    public void copyResolvedFeaturesTo(Set<String> features) {
        features.addAll(this.resolvedFeatures);
    }

    public boolean emptyFeatures() {
        return this.resolvedFeatures.isEmpty();
    }

    public boolean featureSetEquals(Set<String> newFeatureSet) {
        if (newFeatureSet == null) {
            return false;
        }
        return !this.isDirty && newFeatureSet.equals(this.resolvedFeatures);
    }

    @Override
    public Collection<ProvisioningFeatureDefinition> getAutoFeatures() {
        if (this.autoFeatures == null) {
            throw new IllegalStateException("Method called outside of provisioining operation");
        }
        return this.asProvisioningFeatureDefinitionCollection(Collections.unmodifiableCollection(this.autoFeatures));
    }

    public static String getCompatibilityPlatform(SubsystemFeatureDefinitionImpl def, FeatureDefinitionUtils.ImmutableAttributes attr) {
        if (def.getVisibility() != Visibility.PRIVATE) {
            return null;
        }
        if (attr.platforms == null || attr.platforms.isEmpty()) {
            return null;
        }
        return def.getPlatformName();
    }

    public ProvisioningFeatureDefinition getCompatibilityFeature(String platformName) {
        return this.compatibilityFeatures.get(FeatureRepository.lowerFeature(platformName));
    }

    private void putCompatibilityFeature(String platformName, SubsystemFeatureDefinitionImpl featureDef) {
        this.compatibilityFeatures.put(FeatureRepository.lowerFeature(platformName), featureDef);
    }

    private void removeCompatibilityFeature(String platformName) {
        this.compatibilityFeatures.remove(FeatureRepository.lowerFeature(platformName));
    }

    private Collection<ProvisioningFeatureDefinition> asProvisioningFeatureDefinitionCollection(Collection<? extends ProvisioningFeatureDefinition> collection) {
        return collection;
    }

    @Trivial
    private static String toFeatureNameList(Collection<String> collection) {
        StringBuilder builder = new StringBuilder();
        for (String entry : collection) {
            builder.append(entry);
            builder.append(',');
        }
        if (builder.length() > 1) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public List<ProvisioningFeatureDefinition> select(FeatureResolver.Selector<ProvisioningFeatureDefinition> selector) {
        if (selector == null) {
            return new ArrayList<ProvisioningFeatureDefinition>(this.installedFeatures.values());
        }
        ArrayList<ProvisioningFeatureDefinition> selected = new ArrayList<ProvisioningFeatureDefinition>(this.installedFeatures.size());
        this.installedFeatures.values().forEach(def -> {
            if (selector.test((ProvisioningFeatureDefinition)def)) {
                selected.add((ProvisioningFeatureDefinition)def);
            }
        });
        return selected;
    }

    @Override
    public List<ProvisioningFeatureDefinition> getFeatures() {
        return new ArrayList<ProvisioningFeatureDefinition>(this.installedFeatures.values());
    }

    @Override
    public ProvisioningFeatureDefinition getFeature(String featureName) {
        SubsystemFeatureDefinitionImpl result = this.installedFeatures.get(featureName);
        if (result == null) {
            String name = this.publicFeatureNameToSymbolicName.get(FeatureRepository.lowerFeature(featureName));
            result = this.installedFeatures.get(name);
        }
        return result;
    }

    public Map<String, SubsystemFeatureDefinitionImpl> getAllFeatures() {
        return this.installedFeatures;
    }

    @Override
    public List<String> getConfiguredTolerates(String baseSymbolicName) {
        if (this.bundleContext == null) {
            return Collections.emptyList();
        }
        String tolerates = this.bundleContext.getProperty(TOLERATE_PREFIX + baseSymbolicName);
        if (tolerates == null) {
            return Collections.emptyList();
        }
        String[] parts = tolerates.split(",");
        ArrayList<String> result = new ArrayList<String>();
        for (String p : parts) {
            if (EMPTY.equals(p.trim())) continue;
            result.add(p.trim());
        }
        return result;
    }

    @Trivial
    public static String lowerFeature(String inFeature) {
        if (inFeature == null || inFeature.isEmpty()) {
            return inFeature;
        }
        int colonIndex = inFeature.indexOf(":");
        if (colonIndex > -1 && inFeature.length() > colonIndex) {
            return inFeature.substring(0, colonIndex).trim() + ':' + inFeature.substring(colonIndex + 1).trim().toLowerCase(Locale.ENGLISH);
        }
        return inFeature.toLowerCase(Locale.ENGLISH).trim();
    }

    public void updateServices() {
        if (this.bundleContext == null) {
            return;
        }
        HashSet<String> resolvedSymbolicNames = new HashSet<String>();
        for (String featureName : this.resolvedFeatures) {
            String symbolicName = this.publicFeatureNameToSymbolicName.get(FeatureRepository.lowerFeature(featureName));
            if (symbolicName == null) continue;
            resolvedSymbolicNames.add(symbolicName);
        }
        HashSet removedFactories = new HashSet(this.featureServiceFactories.keySet());
        removedFactories.removeAll(resolvedSymbolicNames);
        for (String currentFactorySymbolicName : removedFactories) {
            LibertyFeatureServiceFactory factory = (LibertyFeatureServiceFactory)this.featureServiceFactories.remove(currentFactorySymbolicName);
            if (factory == null) continue;
            factory.unregisterService();
        }
        for (String currentFactorySymbolicName : resolvedSymbolicNames) {
            SubsystemFeatureDefinitionImpl featureDef = this.installedFeatures.get(currentFactorySymbolicName);
            if (featureDef == null) continue;
            LibertyFeatureServiceFactory factory = new LibertyFeatureServiceFactory();
            LibertyFeatureServiceFactory previous = this.featureServiceFactories.putIfAbsent(currentFactorySymbolicName, factory);
            factory = previous != null ? previous : factory;
            factory.update(featureDef, this.bundleContext);
        }
    }

    @Trivial
    private static String consumeEmpty(String s) {
        return s != null && s.isEmpty() ? null : s;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @Deprecated
    public void removeInstalledFeature(String feature) {
        this.removeResolvedFeature(feature);
    }

    public void removeResolvedFeature(String feature) {
        this.configurationError = true;
        HashSet<String> newResolvedFeatures = new HashSet<String>(this.resolvedFeatures);
        if (newResolvedFeatures.remove(feature)) {
            this.resolvedFeatures = newResolvedFeatures.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(newResolvedFeatures);
        }
    }

    public boolean areConfiguredFeaturesGood(Set<String> newConfiguredFeatures, Set<String> newConfiguredPlatforms, String newPlatformEnvironmentVar) {
        if (this.isDirty() || this.hasConfigurationError()) {
            return false;
        }
        if (!this.getPlatforms().equals(newConfiguredPlatforms)) {
            return false;
        }
        if (!FeatureRepository.equals(this.getPlatformEnvVar(), newPlatformEnvironmentVar)) {
            return false;
        }
        if (!this.getConfiguredFeatures().equals(newConfiguredFeatures)) {
            return false;
        }
        for (String resolvedFeature : this.getResolvedFeatures()) {
            if (this.getFeature(resolvedFeature) != null) continue;
            return false;
        }
        return true;
    }

    @Trivial
    private static boolean equals(String s0, String s1) {
        if (s0 == null) {
            return s1 == null;
        }
        if (s1 == null) {
            return false;
        }
        return s0.equals(s1);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class BadFeature {
        final long lastModified;
        final long length;
        static final long serialVersionUID = -4822730322691946046L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        BadFeature(long lastModified, long length) {
            this.lastModified = lastModified;
            this.length = length;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository$BadFeature", BadFeature.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class LibertyFeatureServiceFactory
    implements ServiceFactory<LibertyFeature> {
        private final Hashtable<String, Object> serviceProps = new Hashtable();
        private ServiceRegistration<LibertyFeature> registration;
        private volatile SubsystemFeatureDefinitionImpl _featureDef;
        static final long serialVersionUID = -2842376468316705229L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private LibertyFeatureServiceFactory() {
        }

        /*
         * WARNING - void declaration
         */
        public LibertyFeature getService(Bundle bundle, ServiceRegistration<LibertyFeature> useRegistration) {
            SubsystemFeatureDefinitionImpl current = this._featureDef;
            FeatureDefinitionUtils.ProvisioningDetails details = current.getProvisioningDetails();
            if (details == null) {
                try {
                    details = new FeatureDefinitionUtils.ProvisioningDetails(current.getImmutableAttributes().featureFile, null);
                }
                catch (IOException iOException) {
                    void e;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository$LibertyFeatureServiceFactory", (String)"1439", (Object)this, (Object[])new Object[]{bundle, useRegistration});
                    FeatureRepository.debug("An exception occurred while reading the feature manifest", e.toString());
                }
            }
            current.setProvisioningDetails(details);
            return current;
        }

        public void ungetService(Bundle bundle, ServiceRegistration<LibertyFeature> useRegistration, LibertyFeature service) {
            this._featureDef.setProvisioningDetails(null);
        }

        void registerService(BundleContext bundleContext) {
            this.registration = bundleContext.registerService(LibertyFeature.class, (ServiceFactory)this, this.serviceProps);
        }

        void unregisterService() {
            if (this.registration != null) {
                this.registration.unregister();
            }
        }

        void update(SubsystemFeatureDefinitionImpl featureDef, BundleContext bundleContext) {
            if (featureDef == this._featureDef) {
                return;
            }
            if (this.registration != null) {
                this.registration.unregister();
            }
            this._featureDef = featureDef;
            this.getServiceProps();
            this.registerService(bundleContext);
        }

        private void getServiceProps() {
            this.serviceProps.clear();
            this.serviceProps.put(FEATURE_SERVICE_NAME, this._featureDef.getFeatureName());
            this.serviceProps.put(FEATURE_SERVICE_SYMBOLIC_NAME, this._featureDef.getSymbolicName());
            this.serviceProps.put(FEATURE_SERVICE_VERSION, this._featureDef.getVersion());
            String category = this._featureDef.getHeader(FeatureRepository.FEATURE_SUBSYSTEM_CATEGORY);
            if (category != null) {
                this.serviceProps.put(FEATURE_SERVICE_CATEGORY, category.split("\\s*,\\s*"));
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository$LibertyFeatureServiceFactory", LibertyFeatureServiceFactory.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        }
    }
}

