/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transaction.services;

import com.ibm.tx.jta.TransactionManagerFactory;
import com.ibm.tx.jta.embeddable.UserTransactionDecorator;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.naming.JavaColonNamingHelper;
import com.ibm.ws.container.service.naming.NamingConstants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereUserTransaction;
import com.ibm.ws.tx.jta.embeddable.EmbeddableTransactionSynchronizationRegistryFactory;
import com.ibm.ws.uow.embeddable.UOWManagerFactory;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.uow.UOWManager;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.naming.InvalidNameException;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TransactionJavaColonHelper
implements JavaColonNamingHelper {
    private ServiceReference<EmbeddableWebSphereUserTransaction> userTranSvcRef;
    private final AtomicServiceReference<UserTransactionDecorator> userTranDecoratorSvcRef = new AtomicServiceReference("userTransactionDecorator");
    static final long serialVersionUID = -4873510499851552654L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void activate(ComponentContext cContext) {
        this.userTranDecoratorSvcRef.activate(cContext);
    }

    protected void deactivate(int reason, ComponentContext cContext) {
        this.userTranDecoratorSvcRef.deactivate(cContext);
    }

    protected void setUserTransaction(ServiceReference<EmbeddableWebSphereUserTransaction> utSR) {
        this.userTranSvcRef = utSR;
    }

    protected void unsetUserTransaction(ServiceReference<EmbeddableWebSphereUserTransaction> utSR) {
        if (utSR == this.userTranSvcRef) {
            this.userTranSvcRef = null;
        }
    }

    protected void setUserTransactionDecorator(ServiceReference<UserTransactionDecorator> utdsr) {
        this.userTranDecoratorSvcRef.setReference(utdsr);
    }

    protected UserTransactionDecorator getUserTransactionDecorator() {
        return (UserTransactionDecorator)this.userTranDecoratorSvcRef.getService();
    }

    protected void unsetUserTransactionDecorator(ServiceReference<UserTransactionDecorator> utdsr) {
        this.userTranDecoratorSvcRef.unsetReference(utdsr);
    }

    public Object getObjectInstance(NamingConstants.JavaColonNamespace namespace, String name) throws NamingException {
        switch (namespace) {
            case COMP: {
                switch (name) {
                    case "TransactionManager": {
                        return TransactionManagerFactory.getTransactionManager();
                    }
                    case "TransactionSynchronizationRegistry": {
                        return EmbeddableTransactionSynchronizationRegistryFactory.getTransactionSynchronizationRegistry();
                    }
                    case "UserTransaction": {
                        return this.userTranSvcRef == null ? null : this.getUserTransaction(false, null);
                    }
                }
                return null;
            }
            case COMP_WS: {
                switch (name) {
                    case "UOWManager": {
                        return UOWManagerFactory.getUOWManager();
                    }
                }
                return null;
            }
        }
        return null;
    }

    public boolean hasObjectWithPrefix(NamingConstants.JavaColonNamespace namespace, String name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException();
        }
        boolean result = false;
        if ((namespace == NamingConstants.JavaColonNamespace.COMP || namespace == NamingConstants.JavaColonNamespace.COMP_WS) && name.isEmpty()) {
            result = true;
        }
        return result;
    }

    public Collection<? extends NameClassPair> listInstances(NamingConstants.JavaColonNamespace namespace, String nameInContext) {
        if (!"".equals(nameInContext)) {
            return Collections.emptyList();
        }
        switch (namespace) {
            case COMP: {
                ArrayList<NameClassPair> retVal = new ArrayList<NameClassPair>();
                if (this.userTranSvcRef != null) {
                    NameClassPair pair = new NameClassPair("UserTransaction", UserTransaction.class.getName());
                    retVal.add(pair);
                }
                retVal.add(new NameClassPair("TransactionSynchronizationRegistry", TransactionSynchronizationRegistry.class.getName()));
                retVal.add(new NameClassPair("TransactionManager", TransactionManager.class.getName()));
                return retVal;
            }
            case COMP_WS: {
                return Collections.singleton(new NameClassPair("UOWManager", UOWManager.class.getName()));
            }
        }
        return Collections.emptyList();
    }

    protected UserTransaction getUserTransaction(boolean injection, Object injectionContext) throws NamingException {
        UserTransaction ut = AccessController.doPrivileged(() -> (UserTransaction)this.userTranSvcRef.getBundle().getBundleContext().getService(this.userTranSvcRef));
        UserTransactionDecorator utd = this.getUserTransactionDecorator();
        if (utd == null) {
            return ut;
        }
        return utd.decorateUserTransaction(ut, injection, injectionContext);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.transaction.services.TransactionJavaColonHelper", TransactionJavaColonHelper.class, (String)"transaction", (String)"com.ibm.ws.transaction.services.TransactionMessages");
    }
}

