/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.api.jms.JmsJMSConsumer;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMsgConsumerImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.Serializable;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageFormatException;
import javax.jms.MessageFormatRuntimeException;
import javax.jms.MessageListener;

public class JmsJMSConsumerImpl
implements JmsJMSConsumer {
    private static TraceComponent tc = SibTr.register(JmsJMSConsumerImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private JmsMsgConsumerImpl messageConsumer = null;

    public JmsJMSConsumerImpl(MessageConsumer messageConsumer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsJMSConsumerImpl", (Object)messageConsumer);
        }
        this.messageConsumer = (JmsMsgConsumerImpl)messageConsumer;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsJMSConsumerImpl");
        }
    }

    public void close() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close");
        }
        try {
            this.messageConsumer.close();
        }
        catch (JMSException jmse) {
            JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"close");
            }
        }
    }

    public MessageListener getMessageListener() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMessageListener");
        }
        MessageListener messageListener = null;
        try {
            messageListener = this.messageConsumer.getMessageListener();
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMessageListener", (Object)messageListener);
            }
        }
        return messageListener;
    }

    public String getMessageSelector() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMessageSelector");
        }
        String messageSelector = null;
        try {
            messageSelector = this.messageConsumer.getMessageSelector();
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMessageSelector", (Object)messageSelector);
            }
        }
        return messageSelector;
    }

    public Message receive() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"receive");
        }
        try {
            Message message = this.receive(0L);
            return message;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"receive");
            }
        }
    }

    public Message receive(long timeout) throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"receive", (Object)new Object[]{timeout});
        }
        Message message = null;
        try {
            message = this.messageConsumer.receive(timeout);
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"receive", (Object)new Object[]{message});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"receive", (Object)new Object[]{message});
        }
        return message;
    }

    public <T> T receiveBody(Class<T> paramClass) throws MessageFormatRuntimeException, JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"receiveBody", (Object)new Object[]{paramClass});
        }
        try {
            T t = this.receiveBody(paramClass, 0L);
            return t;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"receiveBody");
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T receiveBody(Class<T> paramClass, long timeout) throws MessageFormatRuntimeException, JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"receiveBody", (Object)new Object[]{paramClass, timeout});
        }
        Object returnValue = null;
        try {
            Message msg = null;
            if (!(String.class.isAssignableFrom(paramClass) || Serializable.class.isAssignableFrom(paramClass) || Map.class.isAssignableFrom(paramClass) || byte[].class.isAssignableFrom(paramClass))) {
                throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_CLASS_TYPE_CWSIA0118", new Object[]{paramClass}, tc);
            }
            msg = this.receive(timeout);
            if (msg != null) {
                returnValue = msg.getBody(paramClass);
                if (returnValue == null) {
                    throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "NO_MSG_BODY_CWSIA0119", null, tc);
                }
                if (!paramClass.isAssignableFrom(returnValue.getClass())) {
                    throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_CLASS_TYPE_CWSIA0118", new Object[]{paramClass}, tc);
                }
            }
        }
        catch (MessageFormatException mfe) {
            try {
                throw (MessageFormatRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)mfe), MessageFormatRuntimeException.class);
                catch (JMSException jmse) {
                    throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"receiveBody", (Object)new Object[]{returnValue});
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return (T)returnValue;
        if (!tc.isEntryEnabled()) return (T)returnValue;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"receiveBody", (Object)new Object[]{returnValue});
        return (T)returnValue;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T receiveBodyNoWait(Class<T> paramClass) throws MessageFormatRuntimeException, JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"receiveBodyNoWait", (Object)new Object[]{paramClass});
        }
        Object returnValue = null;
        try {
            Message msg = null;
            if (!(String.class.isAssignableFrom(paramClass) || Serializable.class.isAssignableFrom(paramClass) || Map.class.isAssignableFrom(paramClass) || byte[].class.isAssignableFrom(paramClass))) {
                throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_CLASS_TYPE_CWSIA0118", new Object[]{paramClass}, tc);
            }
            msg = this.receiveNoWait();
            if (msg != null) {
                returnValue = msg.getBody(paramClass);
                if (returnValue == null) {
                    throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "NO_MSG_BODY_CWSIA0119", null, tc);
                }
                if (!paramClass.isAssignableFrom(returnValue.getClass())) {
                    throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_CLASS_TYPE_CWSIA0118", new Object[]{paramClass}, tc);
                }
            }
        }
        catch (MessageFormatException mfe) {
            try {
                throw (MessageFormatRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)mfe), MessageFormatRuntimeException.class);
                catch (JMSException jmse) {
                    throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"receiveBodyNoWait", (Object)new Object[]{returnValue});
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return (T)returnValue;
        if (!tc.isEntryEnabled()) return (T)returnValue;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"receiveBodyNoWait", (Object)new Object[]{returnValue});
        return (T)returnValue;
    }

    public Message receiveNoWait() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"receiveNoWait");
        }
        Message message = null;
        try {
            message = this.messageConsumer.receiveNoWait();
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"receiveNoWait", (Object)new Object[]{message});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"receiveNoWait", (Object)new Object[]{message});
        }
        return message;
    }

    public void setMessageListener(MessageListener listener) throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setMessageListener", (Object)new Object[]{listener});
        }
        try {
            this.messageConsumer.setMessageListener(listener);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setMessageListener");
            }
        }
    }
}

