/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.impl.interfaces.StoppableThread;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Iterator;

public final class StoppableThreadCache {
    private static final TraceComponent tc = SibTr.register(StoppableThreadCache.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private ArrayList _threadCache;

    public StoppableThreadCache() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"StoppableThreadCache");
        }
        this._threadCache = new ArrayList();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"StoppableThreadCache", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerThread(StoppableThread thread) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerThread", (Object)thread);
        }
        StoppableThreadCache stoppableThreadCache = this;
        synchronized (stoppableThreadCache) {
            this._threadCache.add(thread);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerThread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterThread(StoppableThread thread) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterThread", (Object)thread);
        }
        StoppableThreadCache stoppableThreadCache = this;
        synchronized (stoppableThreadCache) {
            this._threadCache.remove(thread);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterThread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllThreads() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopAllThreads");
        }
        StoppableThreadCache stoppableThreadCache = this;
        synchronized (stoppableThreadCache) {
            Iterator iterator = ((ArrayList)this._threadCache.clone()).iterator();
            while (iterator.hasNext()) {
                StoppableThread thread = (StoppableThread)iterator.next();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Attempting to stop thread " + thread));
                }
                thread.stopThread(this);
                iterator.remove();
                this._threadCache.remove(thread);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopAllThreads");
        }
    }

    public ArrayList getThreads() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getThreads");
            SibTr.exit((TraceComponent)tc, (String)"getThreads", (Object)this._threadCache);
        }
        return this._threadCache;
    }
}

