/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsApiMessage;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.processor.exceptions.SIMPErrorException;
import com.ibm.ws.sib.processor.exceptions.SIMPIncorrectCallException;
import com.ibm.ws.sib.processor.exceptions.SIMPNoLocalisationsException;
import com.ibm.ws.sib.processor.exceptions.SIMPNotAuthorizedException;
import com.ibm.ws.sib.processor.exceptions.SIMPNotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.processor.exceptions.SIMPSessionUnavailableException;
import com.ibm.ws.sib.processor.impl.ConnectionImpl;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.SecurityContext;
import com.ibm.ws.sib.processor.impl.corespitrace.CoreSPIProducerSession;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.MPDestinationSession;
import com.ibm.ws.sib.processor.impl.interfaces.MessageProducer;
import com.ibm.ws.sib.processor.impl.interfaces.ProducerInputHandler;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.utils.DestinationSessionUtils;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.security.auth.OperationType;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;

public final class ProducerSessionImpl
implements ProducerSession,
MessageProducer,
MPDestinationSession {
    private static final TraceNLS nls_mt = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSJUMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    private static final TraceComponent tc = SibTr.register(ProducerSessionImpl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private int _seed = 0;
    private MessageProcessor _messageProcessor;
    private boolean _closed;
    private ProducerInputHandler _inputHandler;
    private ConnectionImpl _conn;
    private DestinationHandler _destination;
    private JsDestinationAddress _address;
    private JsDestinationAddress _routingDestinationAddr;
    private boolean _isRoutingDestinationAddrSet = false;
    private TransactionCommon _autoCommitTransaction;
    private boolean _checkDiscriminatorAccessAtSend = true;
    private String _discriminatorAtCreate = null;
    private SecurityContext _securityContext = null;
    private boolean _keepSecurityUserid = false;
    private SIBUuid12 uuid;
    private boolean _fixedMessagePoint = false;
    private boolean _preferLocal = true;
    private boolean _clearPubSubFingerprints = true;

    ProducerSessionImpl(SIDestinationAddress inAddress, DestinationHandler dest, ConnectionImpl conn, SecurityContext secContext, boolean keepSecurityUSerid, boolean fixedMessagePoint, boolean preferLocal, boolean clearPubSubFingerprints) throws SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ProducerSessionImpl", (Object)new Object[]{inAddress, dest, conn, secContext, keepSecurityUSerid, fixedMessagePoint, preferLocal});
        }
        this._destination = dest;
        this._conn = conn;
        this._securityContext = secContext;
        this._fixedMessagePoint = fixedMessagePoint;
        this._preferLocal = preferLocal;
        this._keepSecurityUserid = keepSecurityUSerid;
        this._messageProcessor = conn.getMessageProcessor();
        this._address = (JsDestinationAddress)inAddress;
        this.uuid = new SIBUuid12();
        ProtocolType inputProtocol = ProtocolType.UNICASTINPUT;
        if (dest.isPubSub()) {
            inputProtocol = ProtocolType.PUBSUBINPUT;
        }
        this._clearPubSubFingerprints = clearPubSubFingerprints;
        this._inputHandler = (ProducerInputHandler)this._destination.getInputHandler(inputProtocol, this._messageProcessor.getMessagingEngineUuid(), null);
        this._inputHandler.attachProducer(this);
        this._closed = false;
        this._autoCommitTransaction = this._destination.getTxManager().createAutoCommitTransaction();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ProducerSessionImpl", (Object)new Object[]{this});
        }
    }

    static final void setRFH2Allowed(JsMessage msg, DestinationHandler destination) {
        String isAllowed;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setRFH2Allowed", (Object)new Object[]{msg, destination});
        }
        Object rfh2Allowed = destination.getContextValue("_MQRFH2Allowed");
        boolean allowed = false;
        if (rfh2Allowed instanceof Boolean) {
            Boolean isAllowed2 = (Boolean)rfh2Allowed;
            allowed = isAllowed2;
        } else if (rfh2Allowed instanceof String && (isAllowed = (String)rfh2Allowed).compareToIgnoreCase("YES") == 0) {
            allowed = true;
        }
        if (allowed) {
            msg.setMQRFH2Allowed(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setRFH2Allowed", (Object)allowed);
        }
    }

    synchronized void updateInputHandler(ProducerInputHandler newInputHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateInputHandler", (Object)newInputHandler);
        }
        this._inputHandler = newInputHandler;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateInputHandler");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(SIBusMessage sibMsg, SITransaction tranImpl) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIProducerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIProducerSession.tc, (String)"send", (Object)new Object[]{this, sibMsg, tranImpl});
        }
        if (tranImpl != null && !((TransactionCommon)tranImpl).isAlive()) {
            SIMPIncorrectCallException e = new SIMPIncorrectCallException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_16", new Object[]{this._destination}, null));
            e.setExceptionReason(16);
            e.setExceptionInserts(new String[]{this._destination.getName()});
            if (TraceComponent.isAnyTracingEnabled() && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
            if (TraceComponent.isAnyTracingEnabled() && CoreSPIProducerSession.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIProducerSession.tc, (String)"send", (Object)e);
            }
            throw e;
        }
        ProducerSessionImpl producerSessionImpl = this;
        synchronized (producerSessionImpl) {
            this.checkNotClosed();
            if (!this._destination.isSendAllowed()) {
                if (TraceComponent.isAnyTracingEnabled() && CoreSPIProducerSession.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPIProducerSession.tc, (String)"send", (Object)"Destination is send disabled");
                }
                SIMPNotPossibleInCurrentConfigurationException e = new SIMPNotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_17", new Object[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName()}, null));
                e.setExceptionReason(17);
                e.setExceptionInserts(new String[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName()});
                throw e;
            }
            JsMessage msg = null;
            try {
                msg = ((JsMessage)sibMsg).getSent(this._conn.getMessageCopiedWhenSent());
            }
            catch (MessageCopyFailedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ProducerSessionImpl.send", (String)"1:379:1.217", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl", "1:386:1.217", e});
                if (TraceComponent.isAnyTracingEnabled() && CoreSPIProducerSession.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPIProducerSession.tc, (String)"send", (Object)"Could not make a safe copy of message");
                }
                SIMPErrorException ex = new SIMPErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl", "1:397:1.217", e}, null), (Throwable)e);
                ex.setExceptionReason(901);
                ex.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl", "1:405:1.217", SIMPUtils.getStackTrace(e)});
                throw ex;
            }
            if (this._clearPubSubFingerprints) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"clearFingerprints");
                }
                msg.clearFingerprints();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("verboseMsg IN : " + msg.toVerboseString()));
            }
            if (this._destination.isAlias() || this._destination.isForeign() || this._destination.isForeignBus()) {
                ProducerSessionImpl.setRFH2Allowed(msg, this._destination);
            }
            if (msg.getTimestamp() == -1L) {
                msg.setTimestamp(System.currentTimeMillis());
            }
            if (this._conn.isBusSecure()) {
                if (this._checkDiscriminatorAccessAtSend) {
                    this._securityContext.setDiscriminator(msg.getDiscriminator());
                    if (!this._destination.checkDiscriminatorAccess(this._securityContext, OperationType.SEND)) {
                        if (TraceComponent.isAnyTracingEnabled() && CoreSPIProducerSession.tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)CoreSPIProducerSession.tc, (String)"send", (Object)"not authorized to produce to this destination's discriminator");
                        }
                        SibTr.audit((TraceComponent)tc, (String)nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_20", new Object[]{this._destination.getName(), msg.getDiscriminator(), this._conn.getResolvedUserid()}, null));
                        SIMPNotAuthorizedException e = new SIMPNotAuthorizedException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_20", new Object[]{this._destination.getName(), msg.getDiscriminator(), this._conn.getResolvedUserid()}, null));
                        e.setExceptionReason(20);
                        e.setExceptionInserts(new String[]{this._destination.getName(), msg.getDiscriminator(), this._conn.getResolvedUserid()});
                        throw e;
                    }
                } else {
                    msg.setDiscriminator(this._discriminatorAtCreate);
                }
            }
            if (this._securityContext != null && this._securityContext.isAlternateUserBased()) {
                if (!this._keepSecurityUserid) {
                    this._messageProcessor.getAccessChecker().setSecurityIDInMessage(this._securityContext.getAlternateUser(), msg);
                }
            } else if (!this._keepSecurityUserid) {
                this._messageProcessor.getAccessChecker().setSecurityIDInMessage(this._conn.getSecuritySubject(), msg);
            }
            MessageItem item = null;
            item = new MessageItem(msg, 0L);
            item.setPreferLocal(this._preferLocal);
            if (this._destination.isPubSub()) {
                item.setProducerConnectionUuid(this._conn.getUuid());
            }
            item.setProducerSeed(++this._seed);
            if (item.getPriority() == -1) {
                item.setPriority(this._destination.getDefaultPriority());
            }
            if (!this._destination.isOverrideOfQOSByProducerAllowed()) {
                item.setReliability(this._destination.getDefaultReliability());
            }
            item.setRequiresNewId(true);
            TransactionCommon transaction = null;
            transaction = tranImpl != null ? (TransactionCommon)tranImpl : this._autoCommitTransaction;
            boolean sucessful = false;
            Object rmCallBackObject = null;
            try {
                if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
                    this.traceSend(item, tranImpl);
                }
                boolean msgFRP = false;
                if (!msg.isForwardRoutingPathEmpty()) {
                    msgFRP = true;
                }
                this._inputHandler.handleProducerMessage(item, transaction, this._address, this, msgFRP);
                sucessful = true;
            }
            catch (SIMPNoLocalisationsException e) {
                if (TraceComponent.isAnyTracingEnabled() && CoreSPIProducerSession.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPIProducerSession.tc, (String)"send", (Object)"SINotPossibleInCurrentConfigurationException");
                }
                SIMPNotPossibleInCurrentConfigurationException ee = new SIMPNotPossibleInCurrentConfigurationException((Throwable)e);
                ee.setExceptionReason(26);
                ee.setExceptionInserts(new String[]{this._destination.getName()});
                throw ee;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIProducerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIProducerSession.tc, (String)"send");
        }
    }

    public void close() {
        boolean closedNow;
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIProducerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIProducerSession.tc, (String)"close", (Object)this);
        }
        if (closedNow = this._close()) {
            this._conn.removeProducerSession(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIProducerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIProducerSession.tc, (String)"close", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean _close() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_close");
        }
        boolean closedNow = false;
        ProducerSessionImpl producerSessionImpl = this;
        synchronized (producerSessionImpl) {
            if (!this._closed) {
                this._closed = true;
                closedNow = true;
            }
        }
        if (closedNow) {
            this._inputHandler.detachProducer(this);
            this._inputHandler = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_close", (Object)new Boolean(closedNow));
        }
        return closedNow;
    }

    public SICoreConnection getConnection() throws SISessionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIProducerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIProducerSession.tc, (String)"getConnection", (Object)this);
            SibTr.exit((TraceComponent)CoreSPIProducerSession.tc, (String)"getConnection", (Object)this._conn);
        }
        this.checkNotClosed();
        return this._conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _closeProducerDestinationDeleted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_closeProducerDestinationDeleted");
        }
        boolean closedNow = false;
        ProducerSessionImpl producerSessionImpl = this;
        synchronized (producerSessionImpl) {
            if (!this._closed) {
                this._closed = true;
                this._inputHandler = null;
                closedNow = true;
            }
        }
        if (closedNow) {
            this._conn.removeProducerSession(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_closeProducerDestinationDeleted");
        }
    }

    public SIDestinationAddress getDestinationAddress() {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIProducerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIProducerSession.tc, (String)"getDestinationAddress", (Object)this);
        }
        if (this._address == null) {
            JsDestinationAddress destAddr = DestinationSessionUtils.createJsDestinationAddress(this._destination);
            if (TraceComponent.isAnyTracingEnabled() && CoreSPIProducerSession.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIProducerSession.tc, (String)"getDestinationAddress", (Object)destAddr);
            }
            return destAddr;
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPIProducerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIProducerSession.tc, (String)"getDestinationAddress", (Object)this._address);
        }
        return this._address;
    }

    void disableDiscriminatorAccessCheckAtSend(String discriminatorAtCreate) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"disableDiscriminatorAccessCheckAtSend");
        }
        this._checkDiscriminatorAccessAtSend = false;
        this._discriminatorAtCreate = discriminatorAtCreate;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"disableDiscriminatorAccessCheckAtSend");
        }
    }

    private void traceSend(MessageItem item, SITransaction siTran) {
        if (item.getMessage().isApiMessage()) {
            String apiMsgId = null;
            String correlationId = null;
            if (item.getMessage() instanceof JsApiMessage) {
                apiMsgId = ((JsApiMessage)item.getMessage()).getApiMessageId();
                correlationId = ((JsApiMessage)item.getMessage()).getCorrelationId();
            } else {
                if (item.getMessage().getApiMessageIdAsBytes() != null) {
                    apiMsgId = new String(item.getMessage().getApiMessageIdAsBytes());
                }
                if (item.getMessage().getCorrelationIdAsBytes() != null) {
                    correlationId = new String(item.getMessage().getCorrelationIdAsBytes());
                }
            }
            if (siTran != null) {
                String msg = "PRODUCER_SEND_CWSJU0001";
                if (this._destination.isForeignBus()) {
                    msg = "PRODUCER_SEND_BUS_CWSJU0017";
                } else if (this._destination.isMQLink()) {
                    msg = "PRODUCER_SEND_MQLINK_CWSJU0019";
                } else if (this._destination.isLink()) {
                    msg = "PRODUCER_SEND_LINK_CWSJU0018";
                }
                if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage(msg, new Object[]{this._conn.getUuid(), apiMsgId, correlationId, this._destination.getName(), ((TransactionCommon)siTran).getPersistentTranId()}, null));
                }
            } else {
                String msg = "PRODUCER_SEND_NO_TRAN_CWSJU0002";
                if (this._destination.isForeignBus()) {
                    msg = "PRODUCER_SEND_NO_TRAN_BUS_CWSJU0061";
                } else if (this._destination.isMQLink()) {
                    msg = "PRODUCER_SEND_NO_TRAN_MQLINK_CWSJU0063";
                } else if (this._destination.isLink()) {
                    msg = "PRODUCER_SEND_NO_TRAN_LINK_CWSJU0062";
                }
                if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage(msg, new Object[]{this._conn.getUuid(), apiMsgId, correlationId, this._destination.getName()}, null));
                }
            }
        }
    }

    private void checkNotClosed() throws SISessionUnavailableException {
        if (this._closed) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkNotClosed", (Object)"ProducerSession closed");
            }
            SIMPSessionUnavailableException e = new SIMPSessionUnavailableException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_21", new Object[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName()}, null));
            e.setExceptionReason(21);
            e.setExceptionInserts(new String[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName()});
            throw e;
        }
    }

    @Override
    public SIBUuid12 getUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUuid");
            SibTr.exit((TraceComponent)tc, (String)"getUuid", (Object)this.uuid);
        }
        return this.uuid;
    }

    @Override
    public boolean fixedMessagePoint() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"fixedMessagePoint");
            SibTr.exit((TraceComponent)tc, (String)"fixedMessagePoint", (Object)this._fixedMessagePoint);
        }
        return this._fixedMessagePoint;
    }

    @Override
    public JsDestinationAddress getRoutingDestination() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRoutingDestination");
            SibTr.exit((TraceComponent)tc, (String)"getRoutingDestination", (Object)this._routingDestinationAddr);
        }
        return this._routingDestinationAddr;
    }

    @Override
    public boolean isRoutingDestinationSet() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isRoutingDestinationSet");
            SibTr.exit((TraceComponent)tc, (String)"isRoutingDestinationSet", (Object)this._isRoutingDestinationAddrSet);
        }
        return this._isRoutingDestinationAddrSet;
    }

    @Override
    public void setRoutingAddress(JsDestinationAddress routingAddr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setRoutingAddress", (Object)routingAddr);
            SibTr.exit((TraceComponent)tc, (String)"setRoutingAddress");
        }
        this._routingDestinationAddr = routingAddr;
        this._isRoutingDestinationAddrSet = true;
    }
}

