/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.impl.interfaces.RemoteDispatchableKey;
import com.ibm.ws.sib.processor.impl.store.items.AOValue;
import com.ibm.ws.sib.processor.utils.am.AbstractBatchedTimeoutEntry;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;

public class AIRequestedTick
extends AbstractBatchedTimeoutEntry {
    private static final TraceComponent tc = SibTr.register(AIRequestedTick.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private long tick;
    private SelectionCriteria[] criterias;
    private RemoteDispatchableKey ck;
    private long originalTimeout;
    private long timeout;
    private boolean slowed;
    private long ackingDMEVersion;
    private long issueTime;
    private AOValue restoringAOValue;

    public AIRequestedTick(long tick, SelectionCriteria[] criterias, RemoteDispatchableKey ck, long timeout, boolean slowed, long issueTime) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AIRequestedTick", (Object)new Object[]{tick, criterias, ck, timeout, slowed, issueTime});
        }
        this.tick = tick;
        this.criterias = criterias;
        this.ck = ck;
        this.originalTimeout = timeout;
        this.timeout = timeout;
        this.slowed = slowed;
        this.ackingDMEVersion = -1L;
        this.issueTime = issueTime;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AIRequestedTick", (Object)this);
        }
    }

    public AIRequestedTick(long tick, AOValue value, long timeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AIRequestedTick", (Object)new Object[]{tick, value, timeout});
        }
        this.tick = tick;
        this.originalTimeout = timeout;
        this.timeout = timeout;
        this.slowed = false;
        this.ackingDMEVersion = -1L;
        this.issueTime = System.currentTimeMillis();
        this.restoringAOValue = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AIRequestedTick", (Object)this);
        }
    }

    public long getTick() {
        return this.tick;
    }

    public SelectionCriteria[] getCriterias() {
        return this.criterias;
    }

    public RemoteDispatchableKey getRemoteDispatchableKey() {
        return this.ck;
    }

    public long getOriginalTimeout() {
        return this.originalTimeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void resetTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isSlowed() {
        return this.slowed;
    }

    public void setSlowed(boolean slowed) {
        this.slowed = slowed;
    }

    public long getAckingDMEVersion() {
        return this.ackingDMEVersion;
    }

    public void setAckingDMEVersion(long v) {
        this.ackingDMEVersion = v;
    }

    public long getIssueTime() {
        return this.issueTime;
    }

    public AOValue getRestoringAOValue() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRestoringAOValue");
            SibTr.exit((TraceComponent)tc, (String)"getRestoringAOValue", (Object)this.restoringAOValue);
        }
        return this.restoringAOValue;
    }

    public String toString() {
        return "[Tick : " + this.tick + ", Timeout : " + this.timeout + ", OriginalTimeout : " + this.originalTimeout + "]";
    }
}

