/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.equinox.metatype.impl.AttributeDefinitionImpl;
import org.eclipse.equinox.metatype.impl.LogTracker;
import org.eclipse.equinox.metatype.impl.MetaTypeMsg;
import org.eclipse.osgi.util.NLS;

public class ValueTokenizer {
    private static final char DELIMITER = ',';
    private static final char ESCAPE = '\\';
    private final LogTracker logger;
    private final List<String> values = new ArrayList<String>();

    public ValueTokenizer(String values_str, LogTracker logger) {
        this.logger = logger;
        if (values_str == null) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < values_str.length()) {
            char c1 = values_str.charAt(i);
            block0 : switch (c1) {
                case ',': {
                    this.values.add(buffer.toString());
                    buffer.delete(0, buffer.length());
                    break;
                }
                case '\\': {
                    if (i + 1 >= values_str.length()) break;
                    buffer.append(values_str.charAt(++i));
                    break;
                }
                default: {
                    if (Character.isWhitespace(c1)) {
                        if (buffer.length() == 0) break;
                        int j = i + 1;
                        while (j < values_str.length()) {
                            char c2 = values_str.charAt(j);
                            if (!(Character.isWhitespace(c2) || c2 == '\\' && j + 1 >= values_str.length())) {
                                if (c2 != ',') {
                                    buffer.append(values_str.substring(i, j));
                                }
                                i = j - 1;
                                break block0;
                            }
                            ++j;
                        }
                        break;
                    }
                    buffer.append(c1);
                }
            }
            ++i;
        }
        this.values.add(buffer.toString());
    }

    public Collection<String> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public String[] getValuesAsArray() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.toArray(new String[this.values.size()]);
    }

    public String getValuesAsString() {
        if (this.values.isEmpty()) {
            return null;
        }
        if (this.values.size() == 1) {
            return this.values.get(0);
        }
        StringBuilder buffer = new StringBuilder(this.values.get(0));
        int i = 1;
        while (i < this.values.size()) {
            buffer.append(',');
            buffer.append(this.values.get(i));
            ++i;
        }
        return buffer.toString();
    }

    private boolean validateString(AttributeDefinitionImpl ad, String value) {
        block5: {
            Integer max;
            block4: {
                Integer min = ad.getMinValue() == null ? null : Integer.valueOf((String)ad.getMinValue());
                Integer n = max = ad.getMaxValue() == null ? null : Integer.valueOf((String)ad.getMaxValue());
                if (min == null || value.length() >= min) break block4;
                return true;
            }
            try {
                if (max != null && value.length() > max) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                if ((ad.getMinValue() == null || value.compareTo((String)ad.getMinValue()) >= 0) && (ad.getMaxValue() == null || value.compareTo((String)ad.getMaxValue()) <= 0)) break block5;
                return true;
            }
        }
        return false;
    }

    public String validate(AttributeDefinitionImpl ad) {
        if (this.values.isEmpty()) {
            return MetaTypeMsg.NULL_IS_INVALID;
        }
        String s2 = null;
        try {
            int cardinality = Math.abs(ad.getCardinality());
            if (cardinality == 0) {
                if (this.values.size() != 1) {
                    return NLS.bind((String)MetaTypeMsg.CARDINALITY_VIOLATION, (Object[])new Serializable[]{this.getValuesAsString(), Integer.valueOf(this.values.size()), Integer.valueOf(1), Integer.valueOf(1)});
                }
            } else if (this.values.size() > cardinality) {
                return NLS.bind((String)MetaTypeMsg.CARDINALITY_VIOLATION, (Object[])new Serializable[]{this.getValuesAsString(), Integer.valueOf(this.values.size()), Integer.valueOf(0), Integer.valueOf(cardinality)});
            }
            for (String s2 : this.values) {
                if (ad.containsInvalidValue(s2)) {
                    return NLS.bind((String)MetaTypeMsg.VALUE_OUT_OF_OPTION, (Object)s2);
                }
                boolean rangeError = false;
                switch (ad.getType()) {
                    case 1: 
                    case 12: {
                        rangeError = this.validateString(ad, s2);
                        break;
                    }
                    case 3: {
                        Integer intVal = Integer.valueOf(s2);
                        if (ad.getMinValue() != null && intVal.compareTo((Integer)ad.getMinValue()) < 0) {
                            rangeError = true;
                            break;
                        }
                        if (ad.getMaxValue() == null || intVal.compareTo((Integer)ad.getMaxValue()) <= 0) break;
                        rangeError = true;
                        break;
                    }
                    case 2: {
                        Long longVal = Long.valueOf(s2);
                        if (ad.getMinValue() != null && longVal.compareTo((Long)ad.getMinValue()) < 0) {
                            rangeError = true;
                            break;
                        }
                        if (ad.getMaxValue() == null || longVal.compareTo((Long)ad.getMaxValue()) <= 0) break;
                        rangeError = true;
                        break;
                    }
                    case 7: {
                        Double doubleVal = Double.valueOf(s2);
                        if (ad.getMinValue() != null && doubleVal.compareTo((Double)ad.getMinValue()) < 0) {
                            rangeError = true;
                            break;
                        }
                        if (ad.getMaxValue() == null || doubleVal.compareTo((Double)ad.getMaxValue()) <= 0) break;
                        rangeError = true;
                        break;
                    }
                    case 11: {
                        break;
                    }
                    case 5: {
                        Character charVal = Character.valueOf(s2.charAt(0));
                        if (ad.getMinValue() != null && charVal.compareTo((Character)ad.getMinValue()) < 0) {
                            rangeError = true;
                            break;
                        }
                        if (ad.getMaxValue() == null || charVal.compareTo((Character)ad.getMaxValue()) <= 0) break;
                        rangeError = true;
                        break;
                    }
                    case 8: {
                        Float floatVal = Float.valueOf(s2);
                        if (ad.getMinValue() != null && floatVal.compareTo((Float)ad.getMinValue()) < 0) {
                            rangeError = true;
                            break;
                        }
                        if (ad.getMaxValue() == null || floatVal.compareTo((Float)ad.getMaxValue()) <= 0) break;
                        rangeError = true;
                        break;
                    }
                    case 4: {
                        Short shortVal = Short.valueOf(s2);
                        if (ad.getMinValue() != null && shortVal.compareTo((Short)ad.getMinValue()) < 0) {
                            rangeError = true;
                            break;
                        }
                        if (ad.getMaxValue() == null || shortVal.compareTo((Short)ad.getMaxValue()) <= 0) break;
                        rangeError = true;
                        break;
                    }
                    case 6: {
                        Byte byteVal = Byte.valueOf(s2);
                        if (ad.getMinValue() != null && byteVal.compareTo((Byte)ad.getMinValue()) < 0) {
                            rangeError = true;
                            break;
                        }
                        if (ad.getMaxValue() == null || byteVal.compareTo((Byte)ad.getMaxValue()) <= 0) break;
                        rangeError = true;
                        break;
                    }
                    case 10: {
                        BigDecimal bigDecVal = new BigDecimal(s2);
                        if (ad.getMinValue() != null && bigDecVal.compareTo((BigDecimal)ad.getMinValue()) < 0) {
                            rangeError = true;
                            break;
                        }
                        if (ad.getMaxValue() == null || bigDecVal.compareTo((BigDecimal)ad.getMaxValue()) <= 0) break;
                        rangeError = true;
                        break;
                    }
                    case 9: {
                        BigInteger bigIntVal = new BigInteger(s2);
                        if (ad.getMinValue() != null && bigIntVal.compareTo((BigInteger)ad.getMinValue()) < 0) {
                            rangeError = true;
                            break;
                        }
                        if (ad.getMaxValue() == null || bigIntVal.compareTo((BigInteger)ad.getMaxValue()) <= 0) break;
                        rangeError = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                if (!rangeError) continue;
                return NLS.bind((String)MetaTypeMsg.VALUE_OUT_OF_RANGE, (Object)s2);
            }
            return "";
        }
        catch (NumberFormatException e) {
            return NLS.bind((String)MetaTypeMsg.VALUE_NOT_A_NUMBER, s2);
        }
        catch (Exception e) {
            String message = NLS.bind((String)MetaTypeMsg.EXCEPTION_MESSAGE, (Object)e.getClass().getName(), (Object)e.getMessage());
            this.logger.log(4, message, e);
            return message;
        }
    }
}

