/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.health.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.microprofile.health.HealthCheckResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HealthCheckHttpResponseBuilder {
    private static final TraceComponent tc = Tr.register(HealthCheckHttpResponseBuilder.class, (String)"HEALTH", (String)"com.ibm.ws.microprofile.health.resources.Health");
    protected static final JsonBuilderFactory jsonBuilderFactory = Json.createBuilderFactory(null);
    private static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    private static final String MEDIA_TYPE_APPLICATION_JSON = "application/json; charset=UTF-8";
    private static final String HEALTH_CHECK_PAYLOAD_OUTCOME = "outcome";
    private static final String HEALTH_CHECK_PAYLOAD_CHECKS = "checks";
    private static final String HEALTH_CHECK_PAYLOAD_NAME = "name";
    private static final String HEALTH_CHECK_PAYLOAD_STATE = "state";
    private static final String HEALTH_CHECK_PAYLOAD_DATA = "data";
    protected HealthCheckResponse.State overallState = HealthCheckResponse.State.UP;
    protected final JsonArrayBuilder checks = jsonBuilderFactory.createArrayBuilder();
    private boolean checksExist = false;
    static final long serialVersionUID = -5851996696487086704L;

    public void addResponses(Set<HealthCheckResponse> hcResponseSet) {
        for (HealthCheckResponse hcResponse : hcResponseSet) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("addResponsek(): hcResponse = " + hcResponse), (Object[])new Object[0]);
            }
            this.setChecks(hcResponse);
        }
    }

    public void setHttpResponse(HttpServletResponse httpResponse) {
        httpResponse.setHeader(HTTP_HEADER_CONTENT_TYPE, MEDIA_TYPE_APPLICATION_JSON);
        JsonObjectBuilder payload = jsonBuilderFactory.createObjectBuilder();
        if (!this.checksExist) {
            httpResponse.setStatus(200);
            payload.add(HEALTH_CHECK_PAYLOAD_OUTCOME, HealthCheckResponse.State.UP.name());
        } else {
            payload.add(HEALTH_CHECK_PAYLOAD_OUTCOME, this.overallState.name());
            httpResponse.setStatus(this.overallState == HealthCheckResponse.State.UP ? 200 : 503);
        }
        payload.add(HEALTH_CHECK_PAYLOAD_CHECKS, this.checks);
        this.setJSONPayload(payload.build(), httpResponse);
    }

    public void handleUndeterminedResponse(HttpServletResponse httpResponse) {
        httpResponse.setStatus(500);
    }

    protected void setChecks(HealthCheckResponse response) {
        Optional dataMap;
        JsonObjectBuilder check = jsonBuilderFactory.createObjectBuilder();
        check.add(HEALTH_CHECK_PAYLOAD_NAME, response.getName());
        HealthCheckResponse.State checkState = response.getState();
        check.add(HEALTH_CHECK_PAYLOAD_STATE, checkState == null ? null : checkState.name());
        if (checkState != null) {
            if (checkState.equals((Object)HealthCheckResponse.State.DOWN)) {
                this.overallState = HealthCheckResponse.State.DOWN;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setChecks(): checkState is null", (Object[])new Object[0]);
            }
            this.overallState = HealthCheckResponse.State.DOWN;
        }
        if ((dataMap = response.getData()) != null && dataMap.isPresent()) {
            JsonObjectBuilder data = jsonBuilderFactory.createObjectBuilder();
            for (Map.Entry entry : ((Map)dataMap.get()).entrySet()) {
                Object value = entry.getValue();
                if (value == null) {
                    data.add((String)entry.getKey(), JsonValue.NULL);
                    continue;
                }
                if (value instanceof String) {
                    data.add((String)entry.getKey(), (String)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    data.add((String)entry.getKey(), ((Boolean)value).booleanValue());
                    continue;
                }
                data.add((String)entry.getKey(), ((Long)value).longValue());
            }
            check.add(HEALTH_CHECK_PAYLOAD_DATA, (JsonValue)data.build());
        }
        this.checks.add(check);
        this.checksExist = true;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setChecks(): checks = " + this.checks), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setJSONPayload(JsonObject payload, HttpServletResponse httpResponse) {
        try {
            httpResponse.getOutputStream().write(payload.toString().getBytes());
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.microprofile.health.internal.HealthCheckHttpResponseBuilder", (String)"137", (Object)this, (Object[])new Object[]{payload, httpResponse});
            if (tc.isEventEnabled()) {
                void e;
                Tr.event((TraceComponent)tc, (String)"Unexpected IOException while writing out POJO response", (Object[])new Object[]{e});
            }
            httpResponse.setStatus(500);
        }
    }

    public void setOverallState(HealthCheckResponse.State state) {
        this.overallState = state;
    }
}

