/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.internal.archive.liberty;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.internal.archive.AbstractCDIArchive;
import com.ibm.ws.cdi.internal.archive.liberty.ApplicationImpl;
import com.ibm.ws.cdi.internal.archive.liberty.ContainerInfoTypeUtils;
import com.ibm.ws.cdi.internal.archive.liberty.ResourceImpl;
import com.ibm.ws.cdi.internal.archive.liberty.RuntimeFactory;
import com.ibm.ws.cdi.internal.interfaces.Application;
import com.ibm.ws.cdi.internal.interfaces.ArchiveType;
import com.ibm.ws.cdi.internal.interfaces.CDIArchive;
import com.ibm.ws.cdi.internal.interfaces.CDIUtils;
import com.ibm.ws.cdi.internal.interfaces.Resource;
import com.ibm.ws.cdi.internal.interfaces.ResourceInjectionBag;
import com.ibm.ws.container.service.annocache.AnnotationsBetaHelper;
import com.ibm.ws.container.service.annocache.CDIContainerAnnotations;
import com.ibm.ws.container.service.annotations.ContainerAnnotations;
import com.ibm.ws.container.service.app.deploy.ClientModuleInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.InjectionClassList;
import com.ibm.ws.container.service.app.deploy.ModuleClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ModuleContainerInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.injectionengine.osgi.util.OSGiJNDIEnvironmentRefBindingHelper;
import com.ibm.ws.javaee.dd.client.ApplicationClient;
import com.ibm.ws.javaee.dd.commonbnd.RefBindingsGroup;
import com.ibm.ws.javaee.dd.managedbean.ManagedBean;
import com.ibm.ws.javaee.dd.managedbean.ManagedBeanBnd;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.resource.ResourceRefConfigFactory;
import com.ibm.ws.resource.ResourceRefConfigList;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.annocache.classsource.ClassSource_Factory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CDIArchiveImpl
extends AbstractCDIArchive
implements CDIArchive {
    private static final String CLASS_NAME;
    private final RuntimeFactory factory;
    private final ApplicationImpl application;
    private final ContainerInfo containerInfo;
    private String path;
    private final ArchiveType type;
    private final ClassLoader classLoader;
    private final Collection<CDIArchive> moduleLibraryArchives;
    private ExtendedModuleInfo extendedModuleInfo;
    private String appCallbackHandlerName;
    private Set<String> classNames;
    private List<String> jeeComponentClassNames;
    private ResourceInjectionBag allBindings;
    static final long serialVersionUID = -6988440722100918472L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public CDIArchiveImpl(ApplicationImpl application, ContainerInfo containerInfo, ArchiveType archiveType, ClassLoader classLoader, RuntimeFactory factory) {
        super(containerInfo.getName(), factory.getServices());
        this.factory = factory;
        this.application = application;
        this.containerInfo = containerInfo;
        this.type = archiveType;
        this.classLoader = classLoader;
        this.moduleLibraryArchives = this.initModuleLibraryArchives();
    }

    public RuntimeFactory getFactory() {
        return this.factory;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Trivial
    private Container getContainer(Entry entry) {
        try {
            return (Container)entry.adapt(Container.class);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.cdi.internal.archive.liberty.CDIArchiveImpl", (String)"132", (Object)this, (Object[])new Object[]{entry});
            return null;
        }
    }

    private Container getContainer(Container container, String path) {
        Entry startEntry = container.getEntry(path);
        if (startEntry == null) {
            return null;
        }
        return this.getContainer(startEntry);
    }

    public ContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public Container getContainer() {
        return this.containerInfo.getContainer();
    }

    @Override
    public String getPath() throws CDIException {
        if (this.path == null) {
            this.path = this.getPath(this.getContainer());
        }
        return this.path;
    }

    /*
     * WARNING - void declaration
     */
    private String getPath(Container useContainer) throws CDIException {
        StringBuilder pathBuilder = new StringBuilder();
        try {
            Entry entry;
            while ((entry = (Entry)useContainer.adapt(Entry.class)) != null) {
                pathBuilder.insert(0, entry.getPath());
                useContainer = entry.getRoot();
            }
        }
        catch (UnableToAdaptException entry) {
            void e;
            FFDCFilter.processException((Throwable)entry, (String)"com.ibm.ws.cdi.internal.archive.liberty.CDIArchiveImpl", (String)"177", (Object)this, (Object[])new Object[]{useContainer});
            throw new CDIException((Throwable)e);
        }
        return pathBuilder.toString();
    }

    @Override
    public Resource getResource(String path) {
        Entry entry = this.getContainer().getEntry(path);
        return entry == null ? null : new ResourceImpl(entry);
    }

    @Override
    public boolean isModule() {
        return this.containerInfo instanceof ModuleContainerInfo;
    }

    @Override
    public ArchiveType getType() {
        return this.type;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Collection<CDIArchive> getModuleLibraryArchives() {
        return this.moduleLibraryArchives;
    }

    private Collection<CDIArchive> initModuleLibraryArchives() {
        HashMap<ContainerInfo, CDIArchive> moduleLibraryArchives = new HashMap<ContainerInfo, CDIArchive>();
        if (this.containerInfo instanceof ModuleClassesContainerInfo) {
            ModuleClassesContainerInfo moduleClassesContainerInfo = (ModuleClassesContainerInfo)this.containerInfo;
            List containerInfos = moduleClassesContainerInfo.getClassesContainerInfo();
            for (ContainerInfo containerInfo : containerInfos) {
                ContainerInfo.Type containerType = containerInfo.getType();
                if (containerType != ContainerInfo.Type.WEB_INF_LIB && containerType != ContainerInfo.Type.MANIFEST_CLASSPATH && containerType != ContainerInfo.Type.JAR_MODULE) continue;
                ArchiveType archiveType = ContainerInfoTypeUtils.getType(containerType);
                CDIArchive childArchive = this.factory.newArchive(this.application, containerInfo, archiveType, this.classLoader);
                moduleLibraryArchives.put(containerInfo, childArchive);
            }
        }
        return moduleLibraryArchives.values();
    }

    /*
     * WARNING - void declaration
     */
    public ExtendedModuleInfo getModuleInfo() throws CDIException {
        if (!this.isModule()) {
            return null;
        }
        if (this.extendedModuleInfo == null) {
            NonPersistentCache moduleCache;
            ModuleContainerInfo moduleContainerInfo = (ModuleContainerInfo)this.containerInfo;
            Container moduleContainer = moduleContainerInfo.getContainer();
            try {
                moduleCache = (NonPersistentCache)moduleContainer.adapt(NonPersistentCache.class);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.cdi.internal.archive.liberty.CDIArchiveImpl", (String)"262", (Object)this, (Object[])new Object[0]);
                throw new CDIException((Throwable)e);
            }
            this.extendedModuleInfo = (ExtendedModuleInfo)moduleCache.getFromCache(ModuleInfo.class);
        }
        return this.extendedModuleInfo;
    }

    private ClientModuleInfo getClientModuleInfo() throws CDIException {
        ExtendedModuleInfo moduleInfo = this.getModuleInfo();
        if (!(moduleInfo instanceof ClientModuleInfo)) {
            return null;
        }
        return (ClientModuleInfo)moduleInfo;
    }

    public ModuleMetaData getModuleMetaData() throws CDIException {
        ExtendedModuleInfo useModuleInfo = this.getModuleInfo();
        return useModuleInfo == null ? null : useModuleInfo.getMetaData();
    }

    @Override
    public MetaData getMetaData() throws CDIException {
        if (this.isModule()) {
            return this.getModuleMetaData();
        }
        if (this.application == null) {
            throw new IllegalArgumentException("getMetaData was invoked on a non-application archive");
        }
        return this.application.getApplicationMetaData();
    }

    @Override
    public J2EEName getJ2EEName() throws CDIException {
        ModuleMetaData moduleMetaData = this.getModuleMetaData();
        return moduleMetaData == null ? null : moduleMetaData.getJ2EEName();
    }

    @Override
    public String getClientModuleMainClass() throws CDIException {
        ClientModuleInfo clientModuleInfo = this.getClientModuleInfo();
        return clientModuleInfo == null ? null : clientModuleInfo.getMainClassName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getClientAppCallbackHandlerName() throws CDIException {
        ClientModuleInfo clientModuleInfo;
        if (this.appCallbackHandlerName == null && (clientModuleInfo = this.getClientModuleInfo()) != null) {
            ApplicationClient appClient;
            try {
                appClient = (ApplicationClient)this.getContainer().adapt(ApplicationClient.class);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.cdi.internal.archive.liberty.CDIArchiveImpl", (String)"319", (Object)this, (Object[])new Object[0]);
                throw new CDIException((Throwable)e);
            }
            if (appClient != null) {
                this.appCallbackHandlerName = appClient.getCallbackHandler();
            }
        }
        return this.appCallbackHandlerName;
    }

    @Override
    public Set<String> getClassNames() {
        if (this.classNames == null) {
            TreeSet<String> storage = new TreeSet<String>();
            Container container = this.containerInfo.getContainer();
            if (this.type == ArchiveType.WEB_MODULE) {
                container = this.getContainer(container, "WEB-INF/classes/");
            }
            if (container != null) {
                this.collectClassNames(container, null, storage);
            }
            this.classNames = storage;
        }
        return this.classNames;
    }

    @Trivial
    private void collectClassNames(Container container, String packageName, Set<String> storage) {
        for (Entry entry : container) {
            String entryName = entry.getName();
            if (!entryName.endsWith(".class")) {
                Container entryContainer = this.getContainer(entry);
                if (entryContainer == null) continue;
                String subPackageName = packageName == null ? entryName : packageName + "." + entryName;
                this.collectClassNames(entryContainer, subPackageName, storage);
                continue;
            }
            int classNameLength = entryName.length() - CDIUtils.CLASS_EXT_LENGTH;
            String className = entryName.substring(0, classNameLength);
            String qualifiedClassName = packageName == null ? className : packageName + "." + className;
            storage.add(qualifiedClassName);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> getInjectionClassList() throws CDIException {
        if (this.jeeComponentClassNames == null) {
            InjectionClassList injectionClassList;
            try {
                injectionClassList = (InjectionClassList)this.getContainer().adapt(InjectionClassList.class);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.cdi.internal.archive.liberty.CDIArchiveImpl", (String)"405", (Object)this, (Object[])new Object[0]);
                throw new CDIException((Throwable)e);
            }
            this.jeeComponentClassNames = injectionClassList.getClassNames();
        }
        return this.jeeComponentClassNames;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ResourceInjectionBag getAllBindings() throws CDIException {
        if (this.allBindings == null) {
            ManagedBeanBnd managedBeanBnd;
            try {
                managedBeanBnd = (ManagedBeanBnd)this.getContainer().adapt(ManagedBeanBnd.class);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.cdi.internal.archive.liberty.CDIArchiveImpl", (String)"428", (Object)this, (Object[])new Object[0]);
                throw new CDIException((Throwable)e);
            }
            if (managedBeanBnd != null) {
                ResourceRefConfigFactory resourceRefConfigFactory = this.factory.getServices().getResourceRefConfigFactory();
                this.allBindings = new ResourceInjectionBag(resourceRefConfigFactory.createResourceRefConfigList());
                List managedBeans = managedBeanBnd.getManagedBeans();
                if (managedBeans != null) {
                    for (ManagedBean managedBean : managedBeans) {
                        OSGiJNDIEnvironmentRefBindingHelper.processBndAndExt(this.allBindings.allBindings, this.allBindings.envEntryValues, (ResourceRefConfigList)this.allBindings.resourceRefConfigList, (RefBindingsGroup)managedBean, null);
                    }
                }
            }
        }
        return this.allBindings;
    }

    @Override
    public Set<String> getAnnotatedClasses(Set<String> annotationClassNames) throws CDIException {
        if (AnnotationsBetaHelper.getLibertyBeta()) {
            return this.getAnnotatedClassesPostBeta(annotationClassNames);
        }
        return this.getAnnotatedClassesPreBeta(annotationClassNames);
    }

    public String getAnnoAppName() throws CDIException {
        String methodName = "getAnnoAppName";
        ExtendedModuleInfo moduleInfo = this.getModuleInfo();
        Object appInfo = moduleInfo != null ? moduleInfo.getApplicationInfo() : (this.application != null ? this.application.getApplicationInfo() : null);
        String annoAppName = appInfo != null ? appInfo.getDeploymentName() : ClassSource_Factory.UNNAMED_APP;
        return annoAppName;
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> getAnnotatedClassesPostBeta(Set<String> annotationClassNames) throws CDIException {
        ClassLoader useClassLoader;
        CDIContainerAnnotations cdiContainerAnnotations;
        String archiveEntryPrefix;
        String methodName = "getAnnotatedClassesPostBeta";
        String appName = this.getAnnoAppName();
        Container archiveContainer = this.getContainer();
        String archivePath = this.getPath(archiveContainer);
        if (archivePath.isEmpty()) {
            archivePath = this.type == ArchiveType.WEB_MODULE || this.type == ArchiveType.WEB_MODULE || this.type == ArchiveType.EJB_MODULE || this.type == ArchiveType.CLIENT_MODULE || this.type == ArchiveType.RAR_MODULE ? appName : null;
        }
        if (this.type == ArchiveType.WEB_MODULE) {
            if (this.getContainer(archiveContainer, "WEB-INF/classes/") == null) {
                return Collections.emptySet();
            }
            archiveEntryPrefix = "WEB-INF/classes/";
        } else {
            archiveEntryPrefix = null;
        }
        try {
            cdiContainerAnnotations = (CDIContainerAnnotations)archiveContainer.adapt(CDIContainerAnnotations.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.cdi.internal.archive.liberty.CDIArchiveImpl", (String)"571", (Object)this, (Object[])new Object[]{annotationClassNames});
            throw new CDIException((Throwable)e);
        }
        cdiContainerAnnotations.setIsLightweight(true);
        if (this.application != null) {
            cdiContainerAnnotations.setUseJandex(this.application.getUseJandex());
            cdiContainerAnnotations.setAppName(appName);
            if (archivePath == null) {
                cdiContainerAnnotations.setIsUnnamedMod(true);
            } else {
                cdiContainerAnnotations.setModName(archivePath);
            }
            if (archiveEntryPrefix != null) {
                cdiContainerAnnotations.setEntryPrefix(archiveEntryPrefix);
            }
        }
        if ((useClassLoader = this.getClassLoader()) == null) {
            String message = "CDI archive [ " + appName + " : " + archivePath + " ]: Null class loader during query for inherited annotations [ " + annotationClassNames + " ]";
            throw new IllegalArgumentException(message);
        }
        cdiContainerAnnotations.setClassLoader(useClassLoader);
        return cdiContainerAnnotations.getClassesWithSpecifiedInheritedAnnotations(annotationClassNames);
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> getAnnotatedClassesPreBeta(Set<String> annotationClassNames) throws CDIException {
        ContainerAnnotations containerAnnotations;
        HashSet<String> annotatedClassNames = new HashSet<String>();
        Container container = this.getContainer();
        if (this.getType() == ArchiveType.WEB_MODULE && (container = this.getContainer(container, "WEB-INF/classes/")) == null) {
            return annotatedClassNames;
        }
        try {
            containerAnnotations = (ContainerAnnotations)container.adapt(ContainerAnnotations.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.cdi.internal.archive.liberty.CDIArchiveImpl", (String)"653", (Object)this, (Object[])new Object[]{annotationClassNames});
            throw new CDIException((Throwable)e);
        }
        boolean useJandex = false;
        if (this.application != null) {
            useJandex = this.application.getUseJandex();
        }
        ArrayList<String> useAnnotationClassNames = new ArrayList<String>(annotationClassNames);
        annotatedClassNames.addAll(containerAnnotations.getClassesWithSpecifiedInheritedAnnotations(useAnnotationClassNames, useJandex));
        return annotatedClassNames;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.cdi.internal.archive.liberty.CDIArchiveImpl", CDIArchiveImpl.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
        CLASS_NAME = CDIArchiveImpl.class.getSimpleName();
    }
}

