/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.security.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.jca.security.internal.Invocation;
import com.ibm.ws.jca.security.internal.J2CSecurityCallbackHandler;
import com.ibm.ws.jca.security.internal.J2CSecurityHelper;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.UnauthenticatedSubjectService;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.credentials.CredentialsService;
import com.ibm.ws.security.intfc.WSSecurityService;
import com.ibm.wsspi.security.registry.RegistryHelper;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Set;
import javax.resource.spi.work.SecurityContext;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.callback.CallerPrincipalCallback;

public class SecWorkContextHandler {
    static final TraceComponent tc = Tr.register(SecWorkContextHandler.class, (String)"WAS.j2c.security", (String)"com.ibm.ws.jca.security.resources.J2CAMessages");
    private static SecWorkContextHandler _instance;

    private SecWorkContextHandler() {
    }

    public static SecWorkContextHandler getInstance() {
        if (_instance == null) {
            _instance = new SecWorkContextHandler();
        }
        return _instance;
    }

    public void associate(CredentialsService credService, WSSecurityService securityService, UnauthenticatedSubjectService unauthSubjService, AuthenticationService authService, WorkContext workCtx, String providerId) throws WorkCompletedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"associate", (Object[])new Object[]{J2CSecurityHelper.objectId(workCtx), providerId});
        }
        if (WSSecurityHelper.isServerSecurityEnabled()) {
            TraceNLS nls = J2CSecurityHelper.getNLS();
            try {
                UserRegistry registry = securityService.getUserRegistry(null);
                String appRealm = registry != null ? registry.getRealm() : null;
                SecurityContext sc = (SecurityContext)workCtx;
                final Subject executionSubject = new Subject();
                J2CSecurityCallbackHandler handler = new J2CSecurityCallbackHandler(executionSubject, appRealm, credService.getUnauthenticatedUserid());
                Subject serverSubject = null;
                sc.setupSecurityContext((CallbackHandler)handler, executionSubject, serverSubject);
                SubjectHelper subjectHelper = new SubjectHelper();
                WSCredential credential = subjectHelper.getWSCredential(executionSubject);
                if (credential != null) {
                    if (handler.getInvocations()[0] == Invocation.CALLERPRINCIPALCALLBACK || handler.getInvocations()[1] == Invocation.GROUPPRINCIPALCALLBACK || handler.getInvocations()[2] == Invocation.PASSWORDVALIDATIONCALLBACK) {
                        String message = nls.getString("AUTHENTICATED_SUBJECT_AND_CALLBACK_NOT_SUPPORTED_J2CA0677", "J2CA0677E: An authenticated JAAS Subject and one or more JASPIC callbacks were passed to the application server by the resource adapter.");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"associate");
                        }
                        throw new WSSecurityException(message);
                    }
                    if (appRealm.equals(credential.getRealmName()) || RegistryHelper.isRealmInboundTrusted((String)credential.getRealmName(), (String)appRealm)) {
                        J2CSecurityHelper.setRunAsSubject(executionSubject);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"associate");
                        }
                        return;
                    }
                    String message = nls.getFormattedMessage("REALM_IS_NOT_TRUSTED_J2CA0685", new Object[]{null}, "REALM_IS_NOT_TRUSTED_J2CA0685");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"associate");
                    }
                    throw new WSSecurityException(message);
                }
                Hashtable<String, Object> cred = J2CSecurityHelper.getCustomCredentials(executionSubject, handler.getCacheKey());
                Set<Principal> principals = executionSubject.getPrincipals();
                if (handler.getInvocations()[0] == Invocation.CALLERPRINCIPALCALLBACK) {
                    if (cred == null || !cred.containsKey("com.ibm.wsspi.security.cred.securityName")) {
                        String message = nls.getString("CUSTOM_CREDENTIALS_MISSING_J2CA0668", "J2CA0668E: The WorkManager was unable to populate the execution subject with the caller principal or credentials necessary to establish the security context for this Work instance.");
                        throw new WSSecurityException(message);
                    }
                } else {
                    CallerPrincipalCallback cpCallback;
                    if ((handler.getInvocations()[1] == Invocation.GROUPPRINCIPALCALLBACK || handler.getInvocations()[2] == Invocation.PASSWORDVALIDATIONCALLBACK) && principals.size() != 1) {
                        String message = nls.getString("CALLERPRINCIPAL_NOT_PROVIDED_J2CA0669", "J2CA0669E: The resource adapter did not provide a CallerPrincipalCallback, an execution subject containing a single principal, or an empty execution subject.");
                        throw new WSSecurityException(message);
                    }
                    if (principals.isEmpty()) {
                        cpCallback = new CallerPrincipalCallback(executionSubject, (String)null);
                        handler.handle(new Callback[]{cpCallback});
                    } else if (principals.size() == 1) {
                        cpCallback = new CallerPrincipalCallback(executionSubject, principals.iterator().next());
                        executionSubject.getPrincipals().clear();
                        handler.handle(new Callback[]{cpCallback});
                    } else {
                        String message = nls.getString("CALLERPRINCIPAL_NOT_PROVIDED_J2CA0669", "J2CA0669E: The resource adapter did not provide a CallerPrincipalCallback, an execution subject containing a single principal, or an empty execution subject.");
                        throw new WSSecurityException(message);
                    }
                    cred = J2CSecurityHelper.getCustomCredentials(executionSubject, handler.getCacheKey());
                }
                String userName = (String)cred.get("com.ibm.wsspi.security.cred.securityName");
                Subject runAsSubject = null;
                if (userName.equals(credService.getUnauthenticatedUserid())) {
                    runAsSubject = unauthSubjService.getUnauthenticatedSubject();
                } else {
                    final AuthenticationService authServ = authService;
                    PrivilegedExceptionAction<Subject> loginAction = new PrivilegedExceptionAction<Subject>(){

                        @Override
                        public Subject run() throws Exception {
                            return authServ.authenticate("system.DEFAULT", executionSubject);
                        }
                    };
                    runAsSubject = AccessController.doPrivileged(loginAction);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The RunAs subject is created after a successful login.", (Object[])new Object[0]);
                }
                J2CSecurityHelper.setRunAsSubject(runAsSubject);
            }
            catch (RuntimeException e) {
                Tr.error((TraceComponent)tc, (String)"SECURITY_CONTEXT_NOT_ASSOCIATED_J2CA0671", (Object[])new Object[]{e});
                String message = nls.getString("SECURITY_CONTEXT_NOT_ASSOCIATED_J2CA0671", "J2CA0671E: The WorkManager was unable to associate the inflown SecurityContext to the Work instance.");
                WorkCompletedException workCompEx = new WorkCompletedException(message, "-1");
                workCompEx.initCause((Throwable)e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"associate");
                }
                throw workCompEx;
            }
            catch (Exception e) {
                Tr.error((TraceComponent)tc, (String)"SECURITY_CONTEXT_NOT_ASSOCIATED_J2CA0671", (Object[])new Object[]{e});
                String message = nls.getString("SECURITY_CONTEXT_NOT_ASSOCIATED_J2CA0671", "J2CA0671E: The WorkManager was unable to associate the inflown SecurityContext to the Work instance.");
                WorkCompletedException workCompEx = new WorkCompletedException(message, "-1");
                workCompEx.initCause((Throwable)e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"associate");
                }
                throw workCompEx;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"associate");
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"associate", (Object)"Application security is not enabled for the application server.");
        }
    }

    public void dissociate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"dissociate", (Object[])new Object[0]);
        }
        if (WSSecurityHelper.isServerSecurityEnabled()) {
            J2CSecurityHelper.removeRunAsSubject();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"dissociate");
        }
    }
}

