/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
final class Rfc3986UriValidator {
    private static final String SCHEME = "(?i)(http|https):";
    private static final String USERINFO = "([^@\\[/?#]*)";
    private static final String HOST = "([^/?#]*)";
    private static final String PATH = "([^?#]*)";
    private static final String QUERY = "([^#]*)";
    private static final String LAST = "#(.*)";
    private static final Pattern HTTP_URL;
    static final long serialVersionUID = 6145519195617874202L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private Rfc3986UriValidator() {
    }

    public static boolean validate(URI uri) {
        if (HttpUtils.isHttpScheme(uri.getScheme())) {
            String uriHost = uri.getHost();
            if (uriHost != null) {
                return !StringUtils.isEmpty((String)uriHost);
            }
            Matcher matcher = HTTP_URL.matcher(uri.toString());
            if (matcher.matches()) {
                String host = matcher.group(5);
                return !StringUtils.isEmpty((String)host);
            }
            return false;
        }
        return true;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.impl.Rfc3986UriValidator", Rfc3986UriValidator.class, null, null);
        HTTP_URL = Pattern.compile("^(?i)(http|https):(//(([^@\\[/?#]*)@)?([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
    }
}

