/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchIllegalJobStatusTransitionException;
import com.ibm.jbatch.container.exception.PersistenceException;
import com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution;
import com.ibm.jbatch.container.execution.impl.RuntimeStepExecution;
import com.ibm.jbatch.container.persistence.jpa.JobExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntity;
import com.ibm.jbatch.container.persistence.jpa.RemotableSplitFlowEntity;
import com.ibm.jbatch.container.persistence.jpa.RemotableSplitFlowKey;
import com.ibm.jbatch.container.persistence.jpa.StepThreadExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.TopLevelStepExecutionEntity;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.ws.InstanceState;
import com.ibm.jbatch.container.ws.JobInstanceNotQueuedException;
import com.ibm.jbatch.container.ws.WSStepThreadExecutionAggregate;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public abstract class AbstractPersistenceManager
implements IPersistenceManagerService {
    private static final Logger logger = Logger.getLogger(AbstractPersistenceManager.class.getName(), "com.ibm.jbatch.container.internal.resources.JBatchMessages");
    public static List<BatchStatus> RUNNING_STATUSES = Collections.unmodifiableList(Arrays.asList(BatchStatus.STARTED, BatchStatus.STARTING, BatchStatus.STOPPING));
    public static List<BatchStatus> FINAL_STATUSES = Arrays.asList(BatchStatus.STOPPED, BatchStatus.ABANDONED, BatchStatus.FAILED, BatchStatus.COMPLETED);
    private static Set<BatchStatus> FINAL_STATUS_SET = Collections.unmodifiableSet(new HashSet<BatchStatus>(FINAL_STATUSES));
    public static List<InstanceState> FINAL_INSTANCE_STATES = Arrays.asList(InstanceState.STOPPED, InstanceState.FAILED, InstanceState.COMPLETED);
    private static Set<InstanceState> FINAL_INSTANCE_STATE_SET = Collections.unmodifiableSet(new HashSet<InstanceState>(FINAL_INSTANCE_STATES));
    static final long serialVersionUID = 7957159146576713430L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AbstractPersistenceManager() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isFinalBatchStatus(BatchStatus batchStatus) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "isFinalBatchStatus", new Object[]{batchStatus});
        }
        boolean bl = FINAL_STATUS_SET.contains(batchStatus);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "isFinalBatchStatus", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isFinalInstanceState(InstanceState instanceState) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "isFinalInstanceState", new Object[]{instanceState});
        }
        boolean bl = FINAL_INSTANCE_STATE_SET.contains((Object)instanceState);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "isFinalInstanceState", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getDisplayId() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "getDisplayId", new Object[0]);
        }
        String string = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "getDisplayId", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getJobInstanceIdFromExecutionId(long jobExecutionId) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "getJobInstanceIdFromExecutionId", new Object[]{jobExecutionId});
        }
        long l = this.getJobInstanceFromExecutionId(jobExecutionId).getInstanceId();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "getJobInstanceIdFromExecutionId", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getJobInstanceAppName(long jobInstanceId) throws NoSuchJobInstanceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "getJobInstanceAppName", new Object[]{jobInstanceId});
        }
        String string = this.getJobInstance(jobInstanceId).getAmcName();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "getJobInstanceAppName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getJobInstanceAppNameFromExecutionId(long jobExecutionId) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "getJobInstanceAppNameFromExecutionId", new Object[]{jobExecutionId});
        }
        String string = this.getJobInstanceFromExecutionId(jobExecutionId).getAmcName();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "getJobInstanceAppNameFromExecutionId", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getJobInstanceSubmitter(long jobInstanceId) throws NoSuchJobInstanceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "getJobInstanceSubmitter", new Object[]{jobInstanceId});
        }
        String string = this.getJobInstance(jobInstanceId).getSubmitter();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "getJobInstanceSubmitter", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isJobInstancePurgeable(long jobInstanceId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "isJobInstancePurgeable", new Object[]{jobInstanceId});
        }
        InstanceState instanceState = this.getJobInstance(jobInstanceId).getInstanceState();
        if (instanceState.equals((Object)InstanceState.SUBMITTED) || instanceState.equals((Object)InstanceState.JMS_QUEUED) || instanceState.equals((Object)InstanceState.JMS_CONSUMED) || instanceState.equals((Object)InstanceState.DISPATCHED)) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "isJobInstancePurgeable", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "isJobInstancePurgeable", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstanceEntity updateJobInstanceStateOnConsumed(long instanceId) throws BatchIllegalJobStatusTransitionException, JobInstanceNotQueuedException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "updateJobInstanceStateOnConsumed", new Object[]{instanceId});
        }
        JobInstanceEntity retVal = this.getJobInstance(instanceId);
        InstanceState currentState = retVal.getInstanceState();
        if (FINAL_INSTANCE_STATE_SET.contains((Object)currentState)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Do nothing, instance = " + instanceId + " is already in final state: " + (Object)((Object)currentState));
            }
        } else if (currentState == InstanceState.JMS_CONSUMED) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Ignore, instance = " + instanceId + " already in JMS_CONSUMED state");
            }
        } else if (currentState == InstanceState.JMS_QUEUED) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Transition instance = " + instanceId + " to JMS_CONSUMED state");
            }
            retVal = this.updateJobInstanceWithInstanceState(instanceId, InstanceState.JMS_CONSUMED, new Date());
        } else {
            String excMsg = "Illegal attempt to transition from instance state = " + (Object)((Object)currentState) + " to JMS_CONSUMED.  Throwing exception.";
            logger.fine(excMsg);
            throw new BatchIllegalJobStatusTransitionException(excMsg);
        }
        JobInstanceEntity jobInstanceEntity = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "updateJobInstanceStateOnConsumed", jobInstanceEntity);
        }
        return jobInstanceEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstanceEntity updateJobInstanceStateOnQueued(long instanceId) throws BatchIllegalJobStatusTransitionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "updateJobInstanceStateOnQueued", new Object[]{instanceId});
        }
        JobInstanceEntity retVal = this.getJobInstance(instanceId);
        InstanceState currentState = retVal.getInstanceState();
        if (FINAL_INSTANCE_STATE_SET.contains((Object)currentState)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Do nothing, instance = " + instanceId + " is already in final state: " + (Object)((Object)currentState));
            }
        } else if (currentState == InstanceState.SUBMITTED) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Transition instance = " + instanceId + " to JMS_QUEUED state");
            }
            retVal = this.updateJobInstanceWithInstanceState(instanceId, InstanceState.JMS_QUEUED, new Date());
        } else {
            String excMsg = "Illegal attempt to transition from instance state = " + (Object)((Object)currentState) + " to JMS_QUEUED.  Throwing exception.";
            logger.fine(excMsg);
            throw new BatchIllegalJobStatusTransitionException(excMsg);
        }
        JobInstanceEntity jobInstanceEntity = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "updateJobInstanceStateOnQueued", jobInstanceEntity);
        }
        return jobInstanceEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecutionEntity getJobExecutionMostRecent(long jobInstanceId) throws IllegalStateException, NoSuchJobInstanceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "getJobExecutionMostRecent", new Object[]{jobInstanceId});
        }
        List<JobExecutionEntity> executions = this.getJobExecutionsFromJobInstanceId(jobInstanceId);
        if (executions == null || executions.size() == 0) {
            throw new IllegalStateException("Did not find any executions associated with instance id: " + jobInstanceId);
        }
        JobExecutionEntity jobExecutionEntity = executions.get(0);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "getJobExecutionMostRecent", jobExecutionEntity);
        }
        return jobExecutionEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getJobExecutionIdMostRecent(long jobInstanceId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "getJobExecutionIdMostRecent", new Object[]{jobInstanceId});
        }
        long l = this.getJobExecutionMostRecent(jobInstanceId).getExecutionId();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "getJobExecutionIdMostRecent", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Properties getJobExecutionParameters(long jobExecutionId) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "getJobExecutionParameters", new Object[]{jobExecutionId});
        }
        Properties properties = this.getJobExecution(jobExecutionId).getJobParameters();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            properties = properties;
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "getJobExecutionParameters", properties);
        }
        return properties;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TopLevelStepExecutionEntity getStepExecutionTopLevel(long stepExecutionId) throws IllegalArgumentException {
        TopLevelStepExecutionEntity topLevelStepExecutionEntity;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "getStepExecutionTopLevel", new Object[]{stepExecutionId});
        }
        StepThreadExecutionEntity stepExec = this.getStepThreadExecution(stepExecutionId);
        if (stepExec == null) {
            throw new IllegalArgumentException("No top-level step thread execution found for key = " + stepExecutionId);
        }
        try {
            TopLevelStepExecutionEntity topLevelStepExec;
            topLevelStepExecutionEntity = topLevelStepExec = (TopLevelStepExecutionEntity)stepExec;
        }
        catch (ClassCastException topLevelStepExec) {
            FFDCFilter.processException((Throwable)topLevelStepExec, (String)"com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", (String)"243", (Object)this, (Object[])new Object[]{stepExecutionId});
            throw new IllegalArgumentException("Found step thread execution found for key = " + stepExecutionId + ", but it was a partition-level step thread, not a top-level execution");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            topLevelStepExecutionEntity = topLevelStepExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "getStepExecutionTopLevel", topLevelStepExecutionEntity);
        }
        return topLevelStepExecutionEntity;
    }

    protected abstract StepThreadExecutionEntity getStepThreadExecution(long var1);

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<WSStepThreadExecutionAggregate> getStepExecutionAggregatesFromJobExecutionId(long jobExecutionId) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "getStepExecutionAggregatesFromJobExecutionId", new Object[]{jobExecutionId});
        }
        ArrayList<WSStepThreadExecutionAggregate> retVal = new ArrayList<WSStepThreadExecutionAggregate>();
        List<StepExecution> topLevelStepExecutions = this.getStepExecutionsTopLevelFromJobExecutionId(jobExecutionId);
        for (StepExecution stepExec : topLevelStepExecutions) {
            retVal.add(this.getStepExecutionAggregate(stepExec.getStepExecutionId()));
        }
        ArrayList<WSStepThreadExecutionAggregate> arrayList = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "getStepExecutionAggregatesFromJobExecutionId", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected byte[] serializeObject(Serializable theObject) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "serializeObject", new Object[]{theObject});
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(baos);
        oout.writeObject(theObject);
        byte[] data = baos.toByteArray();
        baos.close();
        oout.close();
        byte[] byArray = data;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            byArray = byArray;
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "serializeObject", byArray);
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void updateStepExecutionStatusTimeStampsUserDataAndMetrics(StepThreadExecutionEntity stepExec, RuntimeStepExecution runtimeStepExecution) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "updateStepExecutionStatusTimeStampsUserDataAndMetrics", new Object[]{stepExec, runtimeStepExecution});
        }
        stepExec.setBatchStatus(runtimeStepExecution.getBatchStatus());
        stepExec.setExitStatus(runtimeStepExecution.getExitStatus());
        stepExec.setStepName(runtimeStepExecution.getStepName());
        stepExec.setStartTime(runtimeStepExecution.getStartTime());
        stepExec.setEndTime(runtimeStepExecution.getEndTime());
        try {
            stepExec.setPersistentUserDataBytes(this.serializeObject(runtimeStepExecution.getPersistentUserDataObject()));
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", (String)"299", (Object)this, (Object[])new Object[]{stepExec, runtimeStepExecution});
            throw new PersistenceException((Throwable)e);
        }
        this.updateStepExecutionMetrics(stepExec, runtimeStepExecution.getMetrics());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "updateStepExecutionStatusTimeStampsUserDataAndMetrics");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void updateStepExecutionMetrics(StepThreadExecutionEntity stepData, List<Metric> metrics) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "updateStepExecutionMetrics", new Object[]{stepData, metrics});
        }
        for (int i = 0; i < metrics.size(); ++i) {
            if (metrics.get(i).getType().equals((Object)Metric.MetricType.READ_COUNT)) {
                stepData.setReadCount(metrics.get(i).getValue());
                continue;
            }
            if (metrics.get(i).getType().equals((Object)Metric.MetricType.WRITE_COUNT)) {
                stepData.setWriteCount(metrics.get(i).getValue());
                continue;
            }
            if (metrics.get(i).getType().equals((Object)Metric.MetricType.PROCESS_SKIP_COUNT)) {
                stepData.setProcessSkipCount(metrics.get(i).getValue());
                continue;
            }
            if (metrics.get(i).getType().equals((Object)Metric.MetricType.COMMIT_COUNT)) {
                stepData.setCommitCount(metrics.get(i).getValue());
                continue;
            }
            if (metrics.get(i).getType().equals((Object)Metric.MetricType.ROLLBACK_COUNT)) {
                stepData.setRollbackCount(metrics.get(i).getValue());
                continue;
            }
            if (metrics.get(i).getType().equals((Object)Metric.MetricType.READ_SKIP_COUNT)) {
                stepData.setReadSkipCount(metrics.get(i).getValue());
                continue;
            }
            if (metrics.get(i).getType().equals((Object)Metric.MetricType.FILTER_COUNT)) {
                stepData.setFilterCount(metrics.get(i).getValue());
                continue;
            }
            if (!metrics.get(i).getType().equals((Object)Metric.MetricType.WRITE_SKIP_COUNT)) continue;
            stepData.setWriteSkipCount(metrics.get(i).getValue());
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "updateStepExecutionMetrics");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RemotableSplitFlowEntity createSplitFlowExecution(RemotableSplitFlowKey splitFlowKey, Date createTime) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "createSplitFlowExecution", new Object[]{splitFlowKey, createTime});
        }
        RemotableSplitFlowEntity remotableSplitFlowEntity = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            remotableSplitFlowEntity = remotableSplitFlowEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "createSplitFlowExecution", remotableSplitFlowEntity);
        }
        return remotableSplitFlowEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RemotableSplitFlowEntity updateSplitFlowExecution(RuntimeSplitFlowExecution runtimeSplitFlowExecution, BatchStatus newBatchStatus, Date date) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "updateSplitFlowExecution", new Object[]{runtimeSplitFlowExecution, newBatchStatus, date});
        }
        RemotableSplitFlowEntity remotableSplitFlowEntity = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            remotableSplitFlowEntity = remotableSplitFlowEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "updateSplitFlowExecution", remotableSplitFlowEntity);
        }
        return remotableSplitFlowEntity;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RemotableSplitFlowEntity updateSplitFlowExecutionLogDir(RemotableSplitFlowKey key, String logDirPath) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "updateSplitFlowExecutionLogDir", new Object[]{key, logDirPath});
        }
        RemotableSplitFlowEntity remotableSplitFlowEntity = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            remotableSplitFlowEntity = remotableSplitFlowEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "updateSplitFlowExecutionLogDir", remotableSplitFlowEntity);
        }
        return remotableSplitFlowEntity;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void verifyStatusTransitionIsValid(JobExecutionEntity exec, BatchStatus toStatus) throws BatchIllegalJobStatusTransitionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "verifyStatusTransitionIsValid", new Object[]{exec, toStatus});
        }
        switch (exec.getBatchStatus()) {
            case COMPLETED: {
                if (toStatus == BatchStatus.ABANDONED) break;
            }
            case ABANDONED: {
                throw new BatchIllegalJobStatusTransitionException("Job execution: " + exec.getExecutionId() + " cannot be transitioned from Batch Status: " + exec.getBatchStatus().name() + " to " + toStatus.name());
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "verifyStatusTransitionIsValid");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void verifyStatusTransitionIsValid(JobInstanceEntity instance, BatchStatus toStatus) throws BatchIllegalJobStatusTransitionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "verifyStatusTransitionIsValid", new Object[]{instance, toStatus});
        }
        switch (instance.getBatchStatus()) {
            case COMPLETED: {
                if (toStatus == BatchStatus.ABANDONED) break;
            }
            case ABANDONED: {
                throw new BatchIllegalJobStatusTransitionException("Job instance: " + instance.getInstanceId() + " cannot be transitioned from Batch Status: " + instance.getBatchStatus().name() + " to " + toStatus.name());
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "verifyStatusTransitionIsValid");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void verifyThreadStatusTransitionIsValid(StepThreadExecutionEntity stepExec, BatchStatus toStatus) throws BatchIllegalJobStatusTransitionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "verifyThreadStatusTransitionIsValid", new Object[]{stepExec, toStatus});
        }
        switch (stepExec.getBatchStatus()) {
            case COMPLETED: {
                if (toStatus == BatchStatus.ABANDONED) break;
            }
            case ABANDONED: {
                throw new BatchIllegalJobStatusTransitionException("Job Step Thread execution: " + stepExec.getStepExecutionId() + " cannot be transitioned from Batch Status: " + stepExec.getBatchStatus().name() + " to " + toStatus.name());
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "verifyThreadStatusTransitionIsValid");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void verifyStateTransitionIsValid(JobInstanceEntity jobInstance, InstanceState toState) throws BatchIllegalJobStatusTransitionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "verifyStateTransitionIsValid", new Object[]{jobInstance, toState});
        }
        switch (jobInstance.getInstanceState()) {
            case COMPLETED: {
                if (toState == InstanceState.ABANDONED) break;
            }
            case ABANDONED: {
                throw new BatchIllegalJobStatusTransitionException("Job Instance: " + jobInstance.getInstanceId() + " cannot be transitioned from Instance State: " + jobInstance.getInstanceState().name() + " to " + toState.name());
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.AbstractPersistenceManager", "verifyStateTransitionIsValid");
        }
    }
}

