/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.persistence;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.api.chunk.CheckpointAlgorithm;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public final class ItemCheckpointAlgorithm
implements CheckpointAlgorithm {
    private static final String className = ItemCheckpointAlgorithm.class.getName();
    private static Logger logger = Logger.getLogger(ItemCheckpointAlgorithm.class.getPackage().getName());
    long itemsRead;
    protected int itemCount;
    protected int timeLimitSeconds;
    long checkpointBeginTime;
    static final long serialVersionUID = -8074641389093723717L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ItemCheckpointAlgorithm() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.persistence.ItemCheckpointAlgorithm", "<init>", new Object[0]);
        }
        this.itemsRead = 0L;
        this.checkpointBeginTime = 0L;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.persistence.ItemCheckpointAlgorithm", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setItemCount(int itemCount) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.persistence.ItemCheckpointAlgorithm", "setItemCount", new Object[]{itemCount});
        }
        this.itemCount = itemCount;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.persistence.ItemCheckpointAlgorithm", "setItemCount");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setTimeLimitSeconds(int timeLimitSeconds) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.persistence.ItemCheckpointAlgorithm", "setTimeLimitSeconds", new Object[]{timeLimitSeconds});
        }
        this.timeLimitSeconds = timeLimitSeconds;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.persistence.ItemCheckpointAlgorithm", "setTimeLimitSeconds");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void endCheckpoint() throws Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.persistence.ItemCheckpointAlgorithm", "endCheckpoint", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.persistence.ItemCheckpointAlgorithm", "endCheckpoint");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isReadyToCheckpointItem() {
        boolean itemready;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.persistence.ItemCheckpointAlgorithm", "isReadyToCheckpointItem", new Object[0]);
        }
        boolean bl = itemready = this.itemsRead >= (long)this.itemCount;
        if (itemready) {
            logger.fine("ITEMCHKPT: item checkpoint hit");
            if (logger.isLoggable(Level.FINER)) {
                long millis = new Date().getTime() - this.checkpointBeginTime;
                if (millis > 0L) {
                    String rate = Integer.valueOf(Long.valueOf(this.itemsRead * 1000L / millis).intValue()).toString();
                    logger.finer(" - true [itemsReadAndProcessed/second " + rate + "]");
                } else {
                    logger.finer(" - true [itemsReadAndProcessed " + this.itemsRead + "]");
                }
            }
        }
        boolean bl2 = itemready;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl2 = bl2;
            logger.exiting("com.ibm.jbatch.container.persistence.ItemCheckpointAlgorithm", "isReadyToCheckpointItem", bl2);
        }
        return bl2;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isReadyToCheckpointTime() {
        String method = "isReadyToCheckpoint";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, method);
        }
        boolean timeready = false;
        long curts = System.currentTimeMillis();
        long curdiff = curts - this.checkpointBeginTime;
        int diff = (int)curdiff / 1000;
        if (diff >= this.timeLimitSeconds) {
            logger.fine("ITEMTIMECHKPT: time checkpoint hit");
            timeready = true;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Num of itemsReadAndProcessed=" + this.itemsRead + " at a rate=" + this.itemsRead / (long)diff + " itemsReadAndProcessed/sec");
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, method, timeready);
        }
        return timeready;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isReadyToCheckpoint() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.persistence.ItemCheckpointAlgorithm", "isReadyToCheckpoint", new Object[0]);
        }
        ++this.itemsRead;
        if (this.isReadyToCheckpointItem()) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.jbatch.container.persistence.ItemCheckpointAlgorithm", "isReadyToCheckpoint", bl);
            }
            return bl;
        }
        if (this.timeLimitSeconds > 0 && this.isReadyToCheckpointTime()) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.jbatch.container.persistence.ItemCheckpointAlgorithm", "isReadyToCheckpoint", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.persistence.ItemCheckpointAlgorithm", "isReadyToCheckpoint", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void beginCheckpoint() throws Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.persistence.ItemCheckpointAlgorithm", "beginCheckpoint", new Object[0]);
        }
        this.checkpointBeginTime = System.currentTimeMillis();
        this.itemsRead = 0L;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.persistence.ItemCheckpointAlgorithm", "beginCheckpoint");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int checkpointTimeout() throws Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.persistence.ItemCheckpointAlgorithm", "checkpointTimeout", new Object[0]);
        }
        int n = 0;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.jbatch.container.persistence.ItemCheckpointAlgorithm", "checkpointTimeout", n);
        }
        return n;
    }
}

