/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.stat;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.DoubleStatisticImpl;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;
import java.util.ArrayList;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class StatisticAggregateImpl
extends StatisticImpl
implements PmiConstants {
    private static final long serialVersionUID = 8625154880422057621L;
    private ArrayList members = new ArrayList();
    private StatisticImpl aggregateValue = null;
    private int _type = -1;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public StatisticAggregateImpl(PmiDataInfo dataInfo) {
        super(dataInfo.getId());
        this._type = dataInfo.getType();
        switch (this._type) {
            case 2: {
                this.aggregateValue = new CountStatisticImpl(this.id);
                break;
            }
            case 3: {
                this.aggregateValue = new DoubleStatisticImpl(this.id);
                break;
            }
            case 4: {
                this.aggregateValue = new TimeStatisticImpl(this.id);
                break;
            }
            case 5: {
                this.aggregateValue = new BoundedRangeStatisticImpl(this.id);
                break;
            }
            default: {
                this._type = -1;
                System.err.println("[StatisticAggregateImpl] Invalid statistic type");
            }
        }
    }

    @Override
    public WSStatistic copy() {
        return null;
    }

    public synchronized boolean add(StatisticImpl statistic) {
        if (statistic == null) {
            return false;
        }
        if (this.members.contains(statistic)) {
            return false;
        }
        return this.members.add(statistic);
    }

    public synchronized boolean remove(StatisticImpl statistic) {
        if (statistic == null) {
            return false;
        }
        return this.members.remove(statistic);
    }

    public StatisticImpl getStatistic() {
        StatisticImpl aggStat = this._getAggregate();
        aggStat.setLastSampleTime(System.currentTimeMillis());
        return aggStat;
    }

    private StatisticImpl _getAggregate() {
        this.aggregateValue.reset(false);
        for (int i = 0; i < this.members.size(); ++i) {
            Object member = this.members.get(i);
            if (member == null) continue;
            if (member instanceof StatisticAggregateImpl) {
                this.aggregateValue.combine(((StatisticAggregateImpl)member)._getAggregate());
                continue;
            }
            this.aggregateValue.combine((StatisticImpl)member);
        }
        return this.aggregateValue;
    }

    @Override
    public void update(WSStatistic data) {
    }

    @Override
    public WSStatistic delta(WSStatistic data) {
        return null;
    }

    @Override
    public WSStatistic rateOfChange(WSStatistic otherStat) {
        return null;
    }

    @Override
    public void combine(WSStatistic data) {
    }

    @Override
    public void resetOnClient(WSStatistic data) {
    }

    @Override
    public void reset(boolean resetAll) {
    }

    @Override
    public String toXML() {
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.pmi.stat.StatisticAggregateImpl", StatisticAggregateImpl.class, (String)"PMI", (String)"com.ibm.ws.pmi.properties.PMIMessages");
    }
}

