/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Metric;

@Dependent
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MetricName {
    static final long serialVersionUID = -566410329378157302L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    MetricName() {
    }

    public String of(InjectionPoint ip) {
        Annotated annotated = ip.getAnnotated();
        if (annotated instanceof AnnotatedMember) {
            return this.of((AnnotatedMember)annotated);
        }
        if (annotated instanceof AnnotatedParameter) {
            return this.of((AnnotatedParameter)annotated);
        }
        throw new IllegalArgumentException("Unable to retrieve metric name for injection point [" + ip + "], only members and parameters are supported");
    }

    public String of(AnnotatedMember<?> member) {
        if (member.isAnnotationPresent(Metric.class)) {
            Metric metric = (Metric)member.getAnnotation(Metric.class);
            String name = metric.name().isEmpty() ? member.getJavaMember().getName() : this.of(metric.name());
            return metric.absolute() ? name : MetricRegistry.name(member.getJavaMember().getDeclaringClass(), (String[])new String[]{name});
        }
        return MetricRegistry.name(member.getJavaMember().getDeclaringClass(), (String[])new String[]{member.getJavaMember().getName()});
    }

    public String of(String attribute) {
        return attribute;
    }

    private String of(AnnotatedParameter<?> parameter) {
        if (parameter.isAnnotationPresent(Metric.class)) {
            Metric metric = (Metric)parameter.getAnnotation(Metric.class);
            String name = metric.name().isEmpty() ? this.getParameterName(parameter) : this.of(metric.name());
            return metric.absolute() ? name : MetricRegistry.name(parameter.getDeclaringCallable().getJavaMember().getDeclaringClass(), (String[])new String[]{name});
        }
        return MetricRegistry.name(parameter.getDeclaringCallable().getJavaMember().getDeclaringClass(), (String[])new String[]{this.getParameterName(parameter)});
    }

    private String getParameterName(AnnotatedParameter<?> parameter) {
        try {
            Method method = Method.class.getMethod("getParameters", new Class[0]);
            Object[] parameters = (Object[])method.invoke((Object)parameter.getDeclaringCallable().getJavaMember(), new Object[0]);
            Object param = parameters[parameter.getPosition()];
            Class<?> Parameter2 = Class.forName("java.lang.reflect.Parameter");
            if (((Boolean)Parameter2.getMethod("isNamePresent", new Class[0]).invoke(param, new Object[0])).booleanValue()) {
                return (String)Parameter2.getMethod("getName", new Class[0]).invoke(param, new Object[0]);
            }
            throw new UnsupportedOperationException("Unable to retrieve name for parameter [" + parameter + "], activate the -parameters compiler argument or annotate the injected parameter with the @Metric annotation");
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException method) {
            FFDCFilter.processException((Throwable)method, (String)"io.astefanutti.metrics.cdi.MetricName", (String)"106", (Object)this, (Object[])new Object[]{parameter});
            throw new UnsupportedOperationException("Unable to retrieve name for parameter [" + parameter + "], @Metric annotation on injected parameter is required before Java 8");
        }
    }

    public Metadata metadataOf(InjectionPoint ip, Class<?> type) {
        Annotated annotated = ip.getAnnotated();
        String name = this.of(ip);
        return this.metadataOf(annotated, name, type);
    }

    public Metadata metadataOf(AnnotatedMember<?> member) {
        String typeName = member.getBaseType().getTypeName();
        if (typeName.startsWith(Gauge.class.getName())) {
            return this.metadataOf(member, Gauge.class);
        }
        if (typeName.startsWith(Counter.class.getName())) {
            return this.metadataOf(member, Counter.class);
        }
        if (typeName.startsWith(Meter.class.getName())) {
            return this.metadataOf(member, Meter.class);
        }
        if (typeName.startsWith(Histogram.class.getName())) {
            return this.metadataOf(member, Histogram.class);
        }
        if (typeName.startsWith(Timer.class.getName())) {
            return this.metadataOf(member, Timer.class);
        }
        return null;
    }

    private Metadata metadataOf(Annotated annotated, String name, Class<?> type) {
        Metadata metadata = new Metadata(name, MetricType.from(type));
        if (annotated.isAnnotationPresent(Metric.class)) {
            Metric metric = (Metric)annotated.getAnnotation(Metric.class);
            metadata.setDescription(this.metadataValueOf(metric.description()));
            metadata.setDisplayName(this.metadataValueOf(metric.displayName()));
            metadata.setUnit(this.metadataValueOf(metric.unit()));
            for (String tag : metric.tags()) {
                metadata.addTag(tag);
            }
        }
        return metadata;
    }

    private String metadataValueOf(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        return value;
    }

    public Metadata metadataOf(AnnotatedMember<?> member, Class<?> type) {
        String name = this.of(member);
        return this.metadataOf((Annotated)member, name, type);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.astefanutti.metrics.cdi.MetricName", MetricName.class, null, null);
    }
}

