/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.http.netty.compression;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.http.channel.compression.DecompressionHandler;
import com.ibm.wsspi.http.channel.compression.DeflateInputHandler;
import com.ibm.wsspi.http.channel.compression.GzipInputHandler;
import com.ibm.wsspi.http.channel.compression.IdentityInputHandler;
import com.ibm.wsspi.http.channel.values.ContentEncodingValues;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.zip.DataFormatException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class HttpContentDecompressor {
    private static final TraceComponent tc = Tr.register(HttpContentDecompressor.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    static final long serialVersionUID = 5775074807817715068L;

    public WsByteBuffer decompress(WsByteBuffer buffer, HttpChannelConfig config, String contentEncoding) throws DataFormatException {
        Objects.requireNonNull(config, "Http configuration must not be null");
        DecompressionHandler handler = this.chooseHandler(contentEncoding, config);
        return this.decompress(buffer, config, handler);
    }

    private DecompressionHandler chooseHandler(String contentEncoding, HttpChannelConfig config) {
        if (!config.isAutoDecompressionEnabled()) {
            return new IdentityInputHandler();
        }
        ContentEncodingValues encoding = ContentEncodingValues.find(contentEncoding);
        if (ContentEncodingValues.GZIP.equals(encoding) || ContentEncodingValues.XGZIP.equals(encoding)) {
            return new GzipInputHandler();
        }
        if (ContentEncodingValues.DEFLATE.equals(encoding)) {
            return new DeflateInputHandler();
        }
        return new IdentityInputHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WsByteBuffer decompress(WsByteBuffer buffer, HttpChannelConfig config, DecompressionHandler handler) throws DataFormatException {
        if (!handler.isEnabled() || buffer == null || buffer.remaining() == 0) {
            return buffer;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Removing encoding...", (Object[])new Object[0]);
        }
        LinkedList<WsByteBuffer> tempBuffers = new LinkedList<WsByteBuffer>();
        tempBuffers.add(buffer);
        int cyclesAboveDecompressionRatio = 0;
        ArrayList<WsByteBuffer> storage = new ArrayList<WsByteBuffer>();
        try {
            while (!tempBuffers.isEmpty()) {
                WsByteBuffer temp = (WsByteBuffer)tempBuffers.removeFirst();
                while (temp.hasRemaining()) {
                    double ratio;
                    List<WsByteBuffer> decompressionChunks = handler.decompress(temp);
                    if (decompressionChunks.isEmpty()) continue;
                    if (handler.getBytesRead() > 0L && (ratio = (double)handler.getBytesWritten() / (double)handler.getBytesRead()) > (double)config.getDecompressionRatioLimit() && ++cyclesAboveDecompressionRatio > config.getDecompressionTolerance()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Decompression ratio tolerance reached. Cycles: " + cyclesAboveDecompressionRatio), (Object[])new Object[0]);
                        }
                        throw new DataFormatException("Decompression tolerance reached");
                    }
                    storage.addAll(decompressionChunks);
                }
                temp.release();
            }
        }
        finally {
            while (!tempBuffers.isEmpty()) {
                ((WsByteBuffer)tempBuffers.removeFirst()).release();
            }
        }
        if (storage.isEmpty()) {
            return ChannelFrameworkFactory.getBufferManager().allocate(0);
        }
        int totalSize = storage.stream().mapToInt(WsByteBuffer::remaining).sum();
        WsByteBuffer combinedBuffer = ChannelFrameworkFactory.getBufferManager().allocate(totalSize);
        Iterator it = storage.iterator();
        while (it.hasNext()) {
            WsByteBuffer buf = (WsByteBuffer)it.next();
            combinedBuffer.put(buf);
            buf.release();
            it.remove();
        }
        combinedBuffer.flip();
        return combinedBuffer;
    }
}

