/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.addressing.soap;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.EndpointReferenceUtils;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.addressing.Names;
import org.apache.cxf.ws.addressing.ReferenceParametersType;
import org.apache.cxf.ws.addressing.RelatesToType;
import org.apache.cxf.ws.addressing.soap.DecoupledFaultHandler;
import org.apache.cxf.ws.addressing.soap.VersionTransformer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class MAPCodec
extends AbstractSoapInterceptor {
    public static final MAPCodec INSTANCE = new MAPCodec();
    private static final Logger LOG = LogUtils.getL7dLogger(MAPCodec.class);
    private static final String IS_REFERENCE_PARAM_ATTR_NAME = "IsReferenceParameter";
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();
    private static final String DECOUPLED_FAULT_SUPPORT = "org.apache.cxf.ws.addressing.decoupled_fault_support";
    protected final Map<String, Exchange> uncorrelatedExchanges;
    private VersionTransformer transformer;
    private HeaderFactory headerFactory;
    static final long serialVersionUID = -3430486042013267087L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MAPCodec() {
        super("pre-protocol");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "<init>", new Object[0]);
        }
        this.uncorrelatedExchanges = new ConcurrentHashMap<String, Exchange>();
        this.transformer = new VersionTransformer(this);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static synchronized MAPCodec getInstance(Bus bus) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "getInstance", new Object[]{bus});
        }
        MAPCodec mc = (MAPCodec)((Object)bus.getExtension(MAPCodec.class));
        if (mc == null) {
            MAPCodec mAPCodec = MAPCodec.createMAPCodec(bus);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                mAPCodec = mAPCodec;
                LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "getInstance", (Object)mAPCodec);
            }
            return mAPCodec;
        }
        MAPCodec mAPCodec = mc;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            mAPCodec = mAPCodec;
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "getInstance", (Object)mAPCodec);
        }
        return mAPCodec;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static synchronized MAPCodec createMAPCodec(Bus bus) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "createMAPCodec", new Object[]{bus});
        }
        MAPCodec mc = (MAPCodec)((Object)bus.getExtension(MAPCodec.class));
        if (mc == null) {
            bus.setExtension((Object)new MAPCodec(), MAPCodec.class);
            mc = (MAPCodec)((Object)bus.getExtension(MAPCodec.class));
        }
        MAPCodec mAPCodec = mc;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            mAPCodec = mAPCodec;
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "createMAPCodec", (Object)mAPCodec);
        }
        return mAPCodec;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Exchange> getUncorrelatedExchanges() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "getUncorrelatedExchanges", new Object[0]);
        }
        Map<String, Exchange> map = this.uncorrelatedExchanges;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            map = map;
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "getUncorrelatedExchanges", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<QName> getUnderstoodHeaders() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "getUnderstoodHeaders", new Object[0]);
        }
        Set<QName> set = VersionTransformer.HEADERS;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            set = set;
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "getUnderstoodHeaders", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(@Sensitive SoapMessage message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "handleMessage", objectArray);
        }
        this.mediate(message);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "handleMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleFault(SoapMessage message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "handleFault", new Object[]{message});
        }
        if (!message.getExchange().isOneWay()) {
            AddressingProperties maps = ContextUtils.retrieveMAPs((Message)message, (boolean)false, (boolean)true, (boolean)false);
            if (ContextUtils.isRequestor((Message)message) && maps != null) {
                this.uncorrelatedExchanges.remove(maps.getMessageID().getValue());
            } else if (!ContextUtils.isRequestor((Message)message) && maps == null && !message.containsKey((Object)MAPAggregator.class.getName())) {
                for (Interceptor i : message.getInterceptorChain()) {
                    if (!(i instanceof MAPAggregator)) continue;
                    try {
                        MAPAggregator agg = (MAPAggregator)i;
                        agg.handleMessage((Message)message);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.ws.addressing.soap.MAPCodec", (String)"172", (Object)((Object)this), (Object[])new Object[]{message});
                    }
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "handleFault");
                    }
                    return;
                }
            }
        }
        if (MessageUtils.getContextualBoolean((Message)message, (String)DECOUPLED_FAULT_SUPPORT, (boolean)false)) {
            new DecoupledFaultHandler().handleFault(message);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "handleFault");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void mediate(SoapMessage message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "mediate", new Object[]{message});
        }
        if (!MessageUtils.getContextualBoolean((Message)message, (String)MAPAggregator.ADDRESSING_DISABLED, (boolean)false)) {
            if (ContextUtils.isOutbound((Message)message)) {
                this.encode(message, ContextUtils.retrieveMAPs((Message)message, (boolean)false, (boolean)true));
            } else if (null == ContextUtils.retrieveMAPs((Message)message, (boolean)false, (boolean)false, (boolean)false)) {
                String action;
                AddressingProperties maps = this.decode(message);
                ContextUtils.storeMAPs((AddressingProperties)maps, (Message)message, (boolean)false);
                this.markPartialResponse(message, maps);
                this.restoreExchange(message, maps);
                if (maps != null && !MessageUtils.isRequestor((Message)message) && message.getExchange().getBindingOperationInfo() == null && !MessageUtils.isOutbound((Message)message) && maps.getAction() != null && (action = maps.getAction().getValue()) != null) {
                    boolean strict = MessageUtils.getContextualBoolean((Message)message, (String)"ws-addressing.strict.action.checking", (boolean)false);
                    SoapActionInInterceptor.getAndSetOperation((SoapMessage)message, (String)action, (boolean)strict);
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "mediate");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void encode(SoapMessage message, AddressingProperties maps) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "encode", new Object[]{message, maps});
        }
        if (maps != null) {
            this.cacheExchange(message, maps);
            LOG.log(Level.FINE, "Outbound WS-Addressing headers");
            try {
                List header = message.getHeaders();
                this.discardMAPs(header, maps);
                JAXBContext jaxbContext = org.apache.cxf.ws.addressing.VersionTransformer.getExposedJAXBContext((String)maps.getNamespaceURI());
                QName duplicate = maps.getDuplicate();
                this.encodeAsExposed(maps, message, maps.getAction(), Names.WSA_ACTION_QNAME, AttributedURIType.class, jaxbContext);
                if (Names.WSA_ACTION_QNAME.equals(duplicate)) {
                    this.encodeAsExposed(maps, message, maps.getAction(), Names.WSA_ACTION_QNAME, AttributedURIType.class, jaxbContext);
                }
                this.encodeAsExposed(maps, message, maps.getMessageID(), Names.WSA_MESSAGEID_QNAME, AttributedURIType.class, jaxbContext);
                if (Names.WSA_MESSAGEID_QNAME.equals(duplicate)) {
                    this.encodeAsExposed(maps, message, maps.getMessageID(), Names.WSA_MESSAGEID_QNAME, AttributedURIType.class, jaxbContext);
                }
                this.encodeAsExposed(maps, message, maps.getTo(), Names.WSA_TO_QNAME, AttributedURIType.class, jaxbContext);
                if (Names.WSA_TO_QNAME.equals(duplicate)) {
                    this.encodeAsExposed(maps, message, maps.getTo(), Names.WSA_TO_QNAME, AttributedURIType.class, jaxbContext);
                }
                if (this.needsReplyTo(maps, message)) {
                    this.encodeAsExposed(maps, message, maps.getReplyTo(), Names.WSA_REPLYTO_QNAME, EndpointReferenceType.class, jaxbContext);
                    if (Names.WSA_REPLYTO_QNAME.equals(duplicate)) {
                        this.encodeAsExposed(maps, message, maps.getReplyTo(), Names.WSA_REPLYTO_QNAME, EndpointReferenceType.class, jaxbContext);
                    }
                }
                this.encodeAsExposed(maps, message, maps.getRelatesTo(), Names.WSA_RELATESTO_QNAME, RelatesToType.class, jaxbContext);
                if (Names.WSA_RELATESTO_QNAME.equals(duplicate)) {
                    this.encodeAsExposed(maps, message, maps.getRelatesTo(), Names.WSA_RELATESTO_QNAME, RelatesToType.class, jaxbContext);
                }
                this.encodeAsExposed(maps, message, maps.getFrom(), Names.WSA_FROM_QNAME, EndpointReferenceType.class, jaxbContext);
                if (Names.WSA_FROM_QNAME.equals(duplicate)) {
                    this.encodeAsExposed(maps, message, maps.getFrom(), Names.WSA_FROM_QNAME, EndpointReferenceType.class, jaxbContext);
                }
                if (this.needsFaultTo(maps)) {
                    this.encodeAsExposed(maps, message, maps.getFaultTo(), Names.WSA_FAULTTO_QNAME, EndpointReferenceType.class, jaxbContext);
                    if (Names.WSA_FAULTTO_QNAME.equals(duplicate)) {
                        this.encodeAsExposed(maps, message, maps.getFaultTo(), Names.WSA_FAULTTO_QNAME, EndpointReferenceType.class, jaxbContext);
                    }
                }
                this.encodeReferenceParameters(maps, message, jaxbContext);
                maps.setDuplicate(null);
                this.propogateAction(maps.getAction(), message);
                this.applyMAPValidation(message);
            }
            catch (JAXBException header) {
                void je;
                FFDCFilter.processException((Throwable)header, (String)"org.apache.cxf.ws.addressing.soap.MAPCodec", (String)"346", (Object)((Object)this), (Object[])new Object[]{message, maps});
                LOG.log(Level.WARNING, "SOAP_HEADER_ENCODE_FAILURE_MSG", (Throwable)je);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "encode");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean needsReplyTo(AddressingProperties maps, SoapMessage m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "needsReplyTo", new Object[]{maps, m});
        }
        if (!MessageUtils.getContextualBoolean((Message)m, (String)"ws-addressing.write.optional.replyto", (boolean)true)) {
            if (ContextUtils.isNoneAddress((EndpointReferenceType)maps.getReplyTo()) && m.getExchange().isOneWay()) {
                boolean bl = false;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "needsReplyTo", bl);
                }
                return bl;
            }
            if (ContextUtils.isAnonymousAddress((EndpointReferenceType)maps.getReplyTo())) {
                boolean bl = false;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "needsReplyTo", bl);
                }
                return bl;
            }
        }
        boolean bl = maps.getReplyTo() != null && maps.getReplyTo().getAddress() != null && maps.getReplyTo().getAddress().getValue() != null && (!"http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(maps.getNamespaceURI()) || !maps.getReplyTo().getAddress().getValue().equals(ContextUtils.getNoneEndpointReference().getAddress().getValue()));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "needsReplyTo", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean needsFaultTo(AddressingProperties maps) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "needsFaultTo", new Object[]{maps});
        }
        boolean bl = maps.getFaultTo() != null && maps.getFaultTo().getAddress() != null && maps.getFaultTo().getAddress().getValue() != null && !maps.getFaultTo().getAddress().getValue().equals(maps.getReplyTo().getAddress().getValue());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "needsFaultTo", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void encodeReferenceParameters(AddressingProperties maps, SoapMessage msg, JAXBContext ctx) throws JAXBException {
        ReferenceParametersType params;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "encodeReferenceParameters", new Object[]{maps, msg, ctx});
        }
        Element header = null;
        EndpointReferenceType toEpr = maps.getToEndpointReference();
        if (null != toEpr && null != (params = toEpr.getReferenceParameters())) {
            for (Object o : params.getAny()) {
                if (o instanceof Element || o instanceof JAXBElement) {
                    if (header == null) {
                        header = this.getHeaderFactory().getHeader(msg.getVersion());
                    }
                    if (o instanceof Element) {
                        Element e = (Element)o;
                        Node importedNode = header.getOwnerDocument().importNode(e, true);
                        header.appendChild(importedNode);
                    } else {
                        JAXBElement jaxbEl = (JAXBElement)o;
                        ctx.createMarshaller().marshal((Object)jaxbEl, (Node)header);
                    }
                    Element lastAdded = (Element)header.getLastChild();
                    header.removeChild(lastAdded);
                    this.addIsReferenceParameterMarkerAttribute(lastAdded, maps.getNamespaceURI());
                    Header holder = new Header(new QName(lastAdded.getNamespaceURI(), lastAdded.getLocalName()), (Object)lastAdded);
                    msg.getHeaders().add(holder);
                    continue;
                }
                LOG.log(Level.WARNING, "IGNORE_NON_ELEMENT_REF_PARAM_MSG", o);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "encodeReferenceParameters");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addIsReferenceParameterMarkerAttribute(Element lastAdded, String namespaceURI) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "addIsReferenceParameterMarkerAttribute", new Object[]{lastAdded, namespaceURI});
        }
        String pfx = lastAdded.lookupPrefix(namespaceURI);
        if (StringUtils.isEmpty((String)pfx)) {
            if (lastAdded.lookupNamespaceURI("wsa") == null) {
                pfx = "wsa";
                Attr attr = lastAdded.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsa");
                attr.setValue(namespaceURI);
                lastAdded.setAttributeNodeNS(attr);
            } else if (lastAdded.lookupNamespaceURI("wsa").equals(namespaceURI)) {
                pfx = "wsa";
            } else {
                int cnt = 1;
                while (lastAdded.lookupNamespaceURI("wsa" + cnt) != null) {
                    ++cnt;
                }
                pfx = "wsa" + cnt;
                Attr attr = lastAdded.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsa" + cnt);
                attr.setValue(namespaceURI);
                lastAdded.setAttributeNodeNS(attr);
            }
        }
        Attr isRefParamAttr = lastAdded.getOwnerDocument().createAttributeNS(namespaceURI, pfx + ":" + IS_REFERENCE_PARAM_ATTR_NAME);
        isRefParamAttr.setTextContent("1");
        lastAdded.setAttributeNodeNS(isRefParamAttr);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "addIsReferenceParameterMarkerAttribute");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private <T> void encodeAsExposed(AddressingProperties maps, SoapMessage message, T value, QName name, Class<T> clz, JAXBContext context) throws JAXBException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "encodeAsExposed", new Object[]{maps, message, value, name, clz, context});
        }
        if (value != null) {
            LOG.log(Level.FINE, "{0} : {1}", new Object[]{name.getLocalPart(), this.getLogText(value)});
            boolean mu = maps.isRequired() || maps.getMustUnderstand().contains(name);
            this.transformer.encodeAsExposed(message, maps.getNamespaceURI(), value, name.getLocalPart(), clz, context, mu);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "encodeAsExposed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AddressingProperties unmarshalMAPs(SoapMessage message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "unmarshalMAPs", new Object[]{message});
        }
        AddressingProperties maps = null;
        Unmarshaller unmarshaller = null;
        try {
            List header = message.getHeaders();
            if (header != null) {
                LOG.log(Level.FINE, "Inbound WS-Addressing headers");
                HashSet<Element> referenceParameterHeaders = null;
                QName invalidCardinalityQName = null;
                for (Header hdr : header) {
                    if (!(hdr.getObject() instanceof Element)) continue;
                    Element headerElement = (Element)hdr.getObject();
                    String headerURI = headerElement.getNamespaceURI();
                    if (org.apache.cxf.ws.addressing.VersionTransformer.isSupported((String)headerURI)) {
                        String localName;
                        if (unmarshaller == null) {
                            JAXBContext jaxbContext = org.apache.cxf.ws.addressing.VersionTransformer.getExposedJAXBContext((String)headerURI);
                            unmarshaller = jaxbContext.createUnmarshaller();
                            unmarshaller.setEventHandler(null);
                        }
                        if (maps == null) {
                            maps = new AddressingProperties();
                            maps.exposeAs(headerURI);
                        }
                        if ("MessageID".equals(localName = headerElement.getLocalName())) {
                            invalidCardinalityQName = maps.getMessageID() != null ? Names.WSA_MESSAGEID_QNAME : null;
                            maps.setMessageID(this.decodeAsNative(headerURI, AttributedURIType.class, headerElement, unmarshaller));
                            continue;
                        }
                        if ("To".equals(localName)) {
                            invalidCardinalityQName = maps.getTo() != null ? Names.WSA_TO_QNAME : null;
                            AttributedURIType addr = this.decodeAsNative(headerURI, AttributedURIType.class, headerElement, unmarshaller);
                            maps.setTo(EndpointReferenceUtils.getEndpointReference((AttributedURIType)addr));
                            continue;
                        }
                        if ("From".equals(localName)) {
                            invalidCardinalityQName = maps.getFrom() != null ? Names.WSA_FROM_QNAME : null;
                            maps.setFrom(this.decodeAsNative(headerURI, EndpointReferenceType.class, headerElement, unmarshaller));
                            continue;
                        }
                        if ("ReplyTo".equals(localName)) {
                            invalidCardinalityQName = maps.getReplyTo() != null ? Names.WSA_REPLYTO_QNAME : null;
                            maps.setReplyTo(this.decodeAsNative(headerURI, EndpointReferenceType.class, headerElement, unmarshaller));
                            continue;
                        }
                        if ("FaultTo".equals(localName)) {
                            invalidCardinalityQName = maps.getFaultTo() != null ? Names.WSA_FAULTTO_QNAME : null;
                            maps.setFaultTo(this.decodeAsNative(headerURI, EndpointReferenceType.class, headerElement, unmarshaller));
                            continue;
                        }
                        if ("RelatesTo".equals(localName)) {
                            maps.setRelatesTo(this.decodeAsNative(headerURI, RelatesToType.class, headerElement, unmarshaller));
                            continue;
                        }
                        if (!"Action".equals(localName)) continue;
                        invalidCardinalityQName = maps.getAction() != null ? Names.WSA_ACTION_QNAME : null;
                        maps.setAction(this.decodeAsNative(headerURI, AttributedURIType.class, headerElement, unmarshaller));
                        continue;
                    }
                    if (null != headerElement.getAttribute(IS_REFERENCE_PARAM_ATTR_NAME)) {
                        if (null == referenceParameterHeaders) {
                            referenceParameterHeaders = new HashSet<Element>();
                        }
                        referenceParameterHeaders.add(headerElement);
                        continue;
                    }
                    if (!headerURI.contains("/addressing")) continue;
                    LOG.log(Level.WARNING, "UNSUPPORTED_VERSION_MSG", headerURI);
                }
                if (maps != null && !MessageUtils.isRequestor((Message)message) && maps.getReplyTo() == null) {
                    AttributedURIType address = ContextUtils.getAttributedURI((String)"http://www.w3.org/2005/08/addressing/anonymous");
                    EndpointReferenceType replyTo = ContextUtils.WSA_OBJECT_FACTORY.createEndpointReferenceType();
                    replyTo.setAddress(address);
                    maps.setReplyTo(replyTo);
                }
                if (null != referenceParameterHeaders && null != maps) {
                    this.decodeReferenceParameters(referenceParameterHeaders, maps, unmarshaller);
                }
                if (invalidCardinalityQName != null) {
                    this.storeInvalidCardinalityFault(message, invalidCardinalityQName);
                }
            }
        }
        catch (JAXBException header) {
            void je;
            FFDCFilter.processException((Throwable)header, (String)"org.apache.cxf.ws.addressing.soap.MAPCodec", (String)"613", (Object)((Object)this), (Object[])new Object[]{message});
            LOG.log(Level.WARNING, "SOAP_HEADER_DECODE_FAILURE_MSG", (Throwable)je);
        }
        finally {
            JAXBUtils.closeUnmarshaller(unmarshaller);
        }
        AddressingProperties addressingProperties = maps;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            addressingProperties = addressingProperties;
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "unmarshalMAPs", addressingProperties);
        }
        return addressingProperties;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void storeInvalidCardinalityFault(SoapMessage message, QName wsaHeaderName) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "storeInvalidCardinalityFault", new Object[]{message, wsaHeaderName});
        }
        LOG.log(Level.WARNING, "INVALID_CARDINALITY_MESSAGE", wsaHeaderName);
        String reason = BUNDLE.getString("INVALID_ADDRESSING_PROPERTY_MESSAGE");
        ContextUtils.storeMAPFaultName((String)"InvalidCardinality", (Message)message);
        ContextUtils.storeMAPFaultReason((String)reason, (Message)message);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "storeInvalidCardinalityFault");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void decodeReferenceParameters(Set<Element> referenceParameterHeaders, AddressingProperties maps, Unmarshaller unmarshaller) throws JAXBException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "decodeReferenceParameters", new Object[]{referenceParameterHeaders, maps, unmarshaller});
        }
        EndpointReferenceType toEpr = maps.getToEndpointReference();
        if (null != toEpr) {
            for (Element e : referenceParameterHeaders) {
                if (DOMUtils.getChild((Node)e, (int)1) == null) {
                    JAXBElement el = unmarshaller.unmarshal((Node)e, String.class);
                    ContextUtils.applyReferenceParam((EndpointReferenceType)toEpr, (Object)el);
                    continue;
                }
                ContextUtils.applyReferenceParam((EndpointReferenceType)toEpr, (Object)e);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "decodeReferenceParameters");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> T decodeAsNative(String encodedAs, Class<T> clz, Element headerElement, Unmarshaller unmarshaller) throws JAXBException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "decodeAsNative", new Object[]{encodedAs, clz, headerElement, unmarshaller});
        }
        T value = clz.cast(this.transformer.decodeAsNative(encodedAs, clz, headerElement, unmarshaller));
        LOG.log(Level.FINE, "{0} : {1}", new Object[]{headerElement.getLocalName(), this.getLogText(value)});
        T t = value;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            t = t;
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "decodeAsNative", t);
        }
        return t;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private <T> String getLogText(T value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "getLogText", new Object[]{value});
        }
        String text = "unknown";
        if (value == null) {
            text = "null";
        } else if (value instanceof AttributedURIType) {
            text = ((AttributedURIType)value).getValue();
        } else if (value instanceof EndpointReferenceType) {
            text = ((EndpointReferenceType)value).getAddress() != null ? ((EndpointReferenceType)value).getAddress().getValue() : "null";
        } else if (value instanceof RelatesToType) {
            text = ((RelatesToType)value).getValue();
        }
        String string = text;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "getLogText", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private AddressingProperties decode(SoapMessage message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "decode", new Object[]{message});
        }
        AddressingProperties addressingProperties = this.unmarshalMAPs(message);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            addressingProperties = addressingProperties;
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "decode", addressingProperties);
        }
        return addressingProperties;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected <T> void encodeMAP(SoapMessage message, T value, QName qname, Class<T> clz, JAXBContext ctx, boolean mustUnderstand) throws JAXBException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "encodeMAP", new Object[]{message, value, qname, clz, ctx, mustUnderstand});
        }
        JAXBDataBinding jaxbDataBinding = new JAXBDataBinding(ctx);
        SoapHeader h = new SoapHeader(qname, (Object)new JAXBElement(qname, clz, value), (DataBinding)jaxbDataBinding);
        h.setMustUnderstand(mustUnderstand);
        message.getHeaders().add(h);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "encodeMAP");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected <T> T decodeMAP(Class<T> clz, Element headerElement, Unmarshaller unmarshaller) throws JAXBException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "decodeMAP", new Object[]{clz, headerElement, unmarshaller});
        }
        JAXBElement element = unmarshaller.unmarshal((Node)headerElement, clz);
        Object object = element.getValue();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "decodeMAP", object);
        }
        return (T)object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void discardMAPs(List<Header> header, AddressingProperties maps) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "discardMAPs", new Object[]{header, maps});
        }
        Iterator<Header> iter = header.iterator();
        while (iter.hasNext()) {
            Header hdr = iter.next();
            if (!"http://www.w3.org/2005/08/addressing".equals(hdr.getName().getNamespaceURI()) && !"http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(hdr.getName().getNamespaceURI())) continue;
            iter.remove();
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "discardMAPs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void propogateAction(AttributedURIType action, SoapMessage message) {
        List soapActionHeaders;
        Map mimeHeaders;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "propogateAction", new Object[]{action, message});
        }
        if (!(action == null || "".equals(action.getValue()) || (mimeHeaders = CastUtils.cast((Map)((Map)message.get((Object)"org.apache.cxf.mime.headers")))) == null || (soapActionHeaders = (List)mimeHeaders.get("SOAPAction")) == null || soapActionHeaders.isEmpty() || "".equals(soapActionHeaders.get(0)))) {
            LOG.log(Level.FINE, "encoding wsa:Action in SOAPAction header {0}", action.getValue());
            soapActionHeaders.clear();
            soapActionHeaders.add("\"" + action.getValue() + "\"");
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "propogateAction");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void applyMAPValidation(SoapMessage message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "applyMAPValidation", new Object[]{message});
        }
        String faultName = ContextUtils.retrieveMAPFaultName((Message)message);
        if (faultName != null) {
            String reason = ContextUtils.retrieveMAPFaultReason((Message)message);
            throw this.createSOAPFaut(faultName, "http://www.w3.org/2005/08/addressing", reason);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "applyMAPValidation");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private SoapFault createSOAPFaut(String localName, String namespace, String reason) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "createSOAPFaut", new Object[]{localName, namespace, reason});
        }
        SoapFault soapFault = new SoapFault(reason, new QName(namespace, localName));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            soapFault = soapFault;
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "createSOAPFaut", soapFault);
        }
        return soapFault;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void cacheExchange(SoapMessage message, AddressingProperties maps) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "cacheExchange", new Object[]{message, maps});
        }
        if (ContextUtils.isRequestor((Message)message) && !message.getExchange().isOneWay()) {
            this.uncorrelatedExchanges.put(maps.getMessageID().getValue(), message.getExchange());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "cacheExchange");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void restoreExchange(SoapMessage message, AddressingProperties maps) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "restoreExchange", new Object[]{message, maps});
        }
        if (maps != null && maps.getRelatesTo() != null && !"http://www.w3.org/2005/08/addressing/unspecified".equals(maps.getRelatesTo().getValue()) && this.isRelationshipReply(maps.getRelatesTo())) {
            Exchange correlatedExchange = this.uncorrelatedExchanges.remove(maps.getRelatesTo().getValue());
            if (correlatedExchange != null) {
                Exchange exchange = correlatedExchange;
                synchronized (exchange) {
                    message.setExchange(correlatedExchange);
                }
            } else if (ContextUtils.isRequestor((Message)message) && !message.getExchange().isOneWay()) {
                if (ContextUtils.retrieveDeferUncorrelatedMessageAbort((Message)message)) {
                    LOG.fine("deferring uncorrelated message abort");
                    ContextUtils.storeDeferredUncorrelatedMessageAbort((Message)message);
                } else if (!MessageUtils.getContextualBoolean((Message)message, (String)"org.apache.cxf.ws.addressing.MAPAggregator.addressingDisabled", (boolean)false)) {
                    AddressingProperties outp;
                    Message outmsg = message.getExchange().getOutMessage();
                    AddressingProperties addressingProperties = outp = outmsg != null ? ContextUtils.retrieveMAPs((Message)outmsg, (boolean)false, (boolean)true, (boolean)false) : null;
                    if (outp == null || !outp.getMessageID().getValue().equals(maps.getRelatesTo().getValue())) {
                        LOG.log(Level.WARNING, "CORRELATION_FAILURE_MSG");
                        message.getInterceptorChain().abort();
                    }
                }
            }
        } else if (this.isRequestor((Message)message)) {
            Message m;
            if (maps == null) {
                Exchange ex;
                Message m2 = message.getExchange().getOutMessage();
                maps = ContextUtils.retrieveMAPs((Message)m2, (boolean)false, (boolean)true, (boolean)false);
                if (maps != null && (ex = this.uncorrelatedExchanges.get(maps.getMessageID().getValue())) == message.getExchange()) {
                    this.uncorrelatedExchanges.remove(maps.getMessageID().getValue());
                    LOG.log(Level.WARNING, "RESPONSE_NOT_USING_WSADDRESSING");
                }
            } else if (maps.getRelatesTo() == null && maps.getAction() != null && ("http://www.w3.org/2005/08/addressing/fault".equals(maps.getAction().getValue()) || "http://www.w3.org/2005/08/addressing/soap/fault".equals(maps.getAction().getValue()) || "http://docs.oasis-open.org/wsrf/fault".equals(maps.getAction().getValue())) && (maps = ContextUtils.retrieveMAPs((Message)(m = message.getExchange().getOutMessage()), (boolean)false, (boolean)true, (boolean)false)) != null) {
                this.uncorrelatedExchanges.remove(maps.getMessageID().getValue());
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "restoreExchange");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isRelationshipReply(RelatesToType relatesTo) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "isRelationshipReply", new Object[]{relatesTo});
        }
        boolean bl = "http://www.w3.org/2005/08/addressing/reply".equals(relatesTo.getRelationshipType());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "isRelationshipReply", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void markPartialResponse(SoapMessage message, AddressingProperties maps) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "markPartialResponse", new Object[]{message, maps});
        }
        if (ContextUtils.isRequestor((Message)message) && null != maps && (null == maps.getRelatesTo() || null != maps.getRelatesTo() && "http://www.w3.org/2005/08/addressing/unspecified".equals(maps.getRelatesTo().getValue()))) {
            message.put((Object)"org.apache.cxf.partial.response", (Object)Boolean.TRUE);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "markPartialResponse");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected HeaderFactory getHeaderFactory() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "getHeaderFactory", new Object[0]);
        }
        if (this.headerFactory == null) {
            this.headerFactory = new HeaderFactory(){
                static final long serialVersionUID = -4937559801032773464L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Element getHeader(SoapVersion soapversion) {
                    Document doc = DOMUtils.getEmptyDocument();
                    return doc.createElementNS(soapversion.getHeader().getNamespaceURI(), soapversion.getHeader().getLocalPart());
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.apache.cxf.ws.addressing.soap.MAPCodec$1", 1.class, null, null);
                }
            };
        }
        HeaderFactory headerFactory = this.headerFactory;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            headerFactory = headerFactory;
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "getHeaderFactory", headerFactory);
        }
        return headerFactory;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setHeaderFactory(HeaderFactory factory) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.soap.MAPCodec", "setHeaderFactory", new Object[]{factory});
        }
        this.headerFactory = factory;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.soap.MAPCodec", "setHeaderFactory");
        }
    }

    public static interface HeaderFactory {
        public Element getHeader(SoapVersion var1);
    }
}

