/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.client.injection;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxws.client.injection.InjectionHelper;
import com.ibm.ws.jaxws.client.injection.WebServiceRefProcessor;
import com.ibm.ws.jaxws.metadata.WebServiceRefInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.jws.HandlerChain;
import javax.xml.ws.RespectBinding;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.MTOM;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebServiceRefBinding
extends InjectionBinding<WebServiceRef> {
    private static final TraceComponent tc = Tr.register(WebServiceRefBinding.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
    protected WebServiceRefInfo wsrInfo;
    private boolean resourceType = false;
    static final long serialVersionUID = -7529134758038673260L;

    public WebServiceRefBinding(WebServiceRef annotation, ComponentNameSpaceConfiguration nameSpaceConfig) {
        super((Annotation)annotation, nameSpaceConfig);
        this.setJndiName(annotation.name());
    }

    public WebServiceRefBinding(WebServiceRefInfo wsrInfo, ComponentNameSpaceConfiguration nameSpaceConfig) {
        super((Annotation)wsrInfo.getAnnotationValue(), nameSpaceConfig);
        this.setJndiName(wsrInfo.getJndiName());
        this.wsrInfo = wsrInfo;
    }

    protected void mergeWSRInfo(WebServiceRef webServiceRef, Class<?> instanceClass, Member member) {
        if (member == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Merging @WebServiceRef annotation found on the class: " + instanceClass.getName()), (Object[])new Object[0]);
            }
        } else if (member instanceof Method) {
            Method method = (Method)member;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Merging @WebServiceRef or @Resource annotation on the " + method.getName() + " method, in the " + method.getDeclaringClass().getName() + " class."), (Object[])new Object[0]);
            }
        } else {
            Field field = (Field)member;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Merging @WebServiceRef or @Resource annotation on the " + field.getName() + " field, in the " + field.getDeclaringClass().getName() + " class."), (Object[])new Object[0]);
            }
            if (this.isResourceType() && this.wsrInfo.getServiceRefTypeClassName() != null) {
                WebServiceRefProcessor.handleMTOM(webServiceRef, this.wsrInfo, field.getAnnotation(MTOM.class));
                WebServiceRefProcessor.handleRespectBinding(webServiceRef, this.wsrInfo, field.getAnnotation(RespectBinding.class));
                WebServiceRefProcessor.handleAddressing(webServiceRef, this.wsrInfo, field.getAnnotation(Addressing.class));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void merge(WebServiceRef webServiceRef, Class<?> instanceClass, Member member) throws InjectionException {
        block23: {
            Class annoValue;
            block25: {
                block22: {
                    Class annoType;
                    block24: {
                        this.mergeWSRInfo(webServiceRef, instanceClass, member);
                        annoType = webServiceRef.type();
                        if (annoType.getName().equals(Object.class.getName())) break block22;
                        Class existingType = this.loadClass(this.wsrInfo.getServiceRefTypeClassName());
                        if (existingType.getName().equals(Object.class.getName())) break block24;
                        if (existingType.isAssignableFrom(annoType)) {
                            this.wsrInfo.setServiceRefTypeClassName(annoType.getName());
                            break block22;
                        } else if (annoType.isAssignableFrom(existingType)) {
                            this.wsrInfo.setServiceRefTypeClassName(existingType.getName());
                            break block22;
                        } else {
                            Object[] inserts;
                            String msgKey;
                            if (member != null) {
                                msgKey = "error.service.ref.type.mismatch.for.member";
                                inserts = new Object[]{this.wsrInfo.getJndiName(), member.getName(), member.getDeclaringClass().getName(), annoType.getName(), existingType.getName()};
                            } else {
                                msgKey = "error.service.ref.type.mismatch.for.class";
                                inserts = new Object[]{this.wsrInfo.getJndiName(), annoType.getName(), existingType.getName()};
                            }
                            Tr.error((TraceComponent)tc, (String)msgKey, (Object[])inserts);
                            throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])inserts));
                        }
                    }
                    this.wsrInfo.setServiceRefTypeClassName(annoType.getName());
                }
                if ((annoValue = webServiceRef.value()).getName().equals(Service.class.getName())) break block23;
                Class existingValue = this.loadClass(this.wsrInfo.getServiceInterfaceClassName());
                if (existingValue.getName().equals(Service.class.getName())) break block25;
                if (existingValue.isAssignableFrom(annoValue)) {
                    this.wsrInfo.setServiceInterfaceClassName(annoValue.getName());
                    break block23;
                } else if (annoValue.isAssignableFrom(existingValue)) {
                    this.wsrInfo.setServiceInterfaceClassName(existingValue.getName());
                    break block23;
                } else {
                    Object[] inserts;
                    String msgKey;
                    if (member != null) {
                        msgKey = "error.service.interface.mismatch.for.member";
                        inserts = new Object[]{this.wsrInfo.getJndiName(), member.getName(), member.getDeclaringClass().getName(), annoValue.getName(), existingValue.getName()};
                    } else {
                        msgKey = "error.service.interface.mismatch.for.class";
                        inserts = new Object[]{this.wsrInfo.getJndiName(), annoValue.getName(), existingValue.getName()};
                    }
                    Tr.error((TraceComponent)tc, (String)msgKey, (Object[])inserts);
                    throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])inserts));
                }
            }
            this.wsrInfo.setServiceInterfaceClassName(annoValue.getName());
        }
        if (member == null) {
            this.validateAndSetClassLevelWebServiceRef(instanceClass);
        } else {
            this.validateAndSetMemberLevelWebServiceRef(member);
        }
        if (webServiceRef.wsdlLocation() != null && !webServiceRef.wsdlLocation().isEmpty()) {
            this.processExistingWSDL(webServiceRef.wsdlLocation(), member);
        }
        HandlerChain handlerChainInstance = null;
        if (member == null) {
            handlerChainInstance = instanceClass.getAnnotation(HandlerChain.class);
        } else if (member instanceof Field) {
            Field field = (Field)member;
            handlerChainInstance = field.getAnnotation(HandlerChain.class);
        } else if (member instanceof Method) {
            Method method = (Method)member;
            handlerChainInstance = method.getAnnotation(HandlerChain.class);
        }
        if (handlerChainInstance != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("@HandlerChain annotation found with @WebServiceRef annotation, jndiName: " + webServiceRef.name()), (Object[])new Object[0]);
            }
            this.wsrInfo.setHandlerChainDeclaringClassName(instanceClass.getName());
            this.wsrInfo.setHandlerChainAnnotation(handlerChainInstance);
        }
    }

    private void validateAndSetClassLevelWebServiceRef(Class<?> instanceClass) throws InjectionException {
        Class typeClass = this.loadClass(this.wsrInfo.getServiceRefTypeClassName());
        Class valueClass = this.loadClass(this.wsrInfo.getServiceInterfaceClassName());
        if (typeClass.getName().equals(Object.class.getName())) {
            if (!Service.class.isAssignableFrom(valueClass) || valueClass.getName().equals(Service.class.getName())) {
                Tr.error((TraceComponent)tc, (String)"error.service.ref.class.level.merge.service.ref.type.absent", (Object[])new Object[]{instanceClass.getName()});
                throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.class.level.merge.service.ref.type.absent", (Object[])new Object[]{instanceClass.getName()}));
            }
            this.wsrInfo.setServiceInterfaceClassName(valueClass.getName());
            this.wsrInfo.setServiceRefTypeClassName(valueClass.getName());
        } else if (Service.class.isAssignableFrom(typeClass)) {
            if (typeClass.getName().equals(Service.class.getName())) {
                if (!Service.class.isAssignableFrom(valueClass) || valueClass.getName().equals(Service.class.getName())) {
                    Tr.error((TraceComponent)tc, (String)"error.service.ref.class.level.merge.service.interface.wrong.value", (Object[])new Object[]{instanceClass.getName(), valueClass.getName()});
                    throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.class.level.merge.service.interface.wrong.value", (Object[])new Object[]{instanceClass.getName(), valueClass.getName()}));
                }
                this.wsrInfo.setServiceInterfaceClassName(valueClass.getName());
                this.wsrInfo.setServiceRefTypeClassName(valueClass.getName());
            } else {
                if (!valueClass.getName().equals(typeClass.getName()) && !valueClass.getName().equals(Service.class.getName())) {
                    Tr.error((TraceComponent)tc, (String)"error.service.ref.class.level.merge.service.interface.and.service.ref.type.not.same", (Object[])new Object[]{instanceClass.getName()});
                    throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.class.level.merge.service.interface.and.service.ref.type.not.same", (Object[])new Object[]{instanceClass.getName()}));
                }
                this.wsrInfo.setServiceInterfaceClassName(typeClass.getName());
                this.wsrInfo.setServiceRefTypeClassName(typeClass.getName());
            }
        } else {
            if (!Service.class.isAssignableFrom(valueClass) || valueClass.getName().equals(Service.class.getName())) {
                Tr.error((TraceComponent)tc, (String)"error.service.ref.class.level.merge.service.interface.wrong.value", (Object[])new Object[]{instanceClass.getName(), valueClass.getName()});
                throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.class.level.merge.service.interface.wrong.value", (Object[])new Object[]{instanceClass.getName(), valueClass.getName()}));
            }
            this.wsrInfo.setServiceInterfaceClassName(valueClass.getName());
            this.wsrInfo.setServiceRefTypeClassName(typeClass.getName());
        }
    }

    private void validateAndSetMemberLevelWebServiceRef(Member member) throws InjectionException {
        Class<?> effectiveType;
        Class<?> typeClass = this.loadClass(this.wsrInfo.getServiceRefTypeClassName());
        Class valueClass = this.loadClass(this.wsrInfo.getServiceInterfaceClassName());
        Class<?> memberType = InjectionHelper.getTypeFromMember(member);
        if (memberType.getName().equals(Object.class.getName())) {
            effectiveType = typeClass;
            if (tc.isDebugEnabled() && typeClass.getName().equals(Object.class.getName())) {
                Tr.debug((TraceComponent)tc, (String)("The member type and the @WebServiceRef.type on the " + member.getName() + " in " + member.getDeclaringClass().getName() + "are all Object.class, so can not infer one. Will try service type injection if the @WebServiceRef.value is a subclass of Service.class."), (Object[])new Object[0]);
            }
        } else if (memberType.isAssignableFrom(typeClass)) {
            effectiveType = typeClass;
        } else if (typeClass.isAssignableFrom(memberType)) {
            effectiveType = memberType;
        } else {
            Tr.error((TraceComponent)tc, (String)"error.service.ref.member.level.merge.service.ref.type.not.compatible", (Object[])new Object[]{member.getName(), member.getDeclaringClass().getName(), typeClass.getName(), memberType.getName()});
            throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.member.level.merge.service.ref.type.not.compatible", (Object[])new Object[]{member.getName(), member.getDeclaringClass().getName(), typeClass.getName(), memberType.getName()}));
        }
        if (effectiveType.getName().equals(Object.class.getName())) {
            if (!Service.class.isAssignableFrom(valueClass) || valueClass.getName().equals(Service.class.getName())) {
                Tr.error((TraceComponent)tc, (String)"error.service.ref.member.level.merge.service.ref.type.not.inferred", (Object[])new Object[]{member.getName(), member.getDeclaringClass().getName()});
                throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.member.level.merge.service.ref.type.not.inferred", (Object[])new Object[]{member.getName(), member.getDeclaringClass().getName()}));
            }
            this.wsrInfo.setServiceRefTypeClassName(valueClass.getName());
            this.wsrInfo.setServiceInterfaceClassName(valueClass.getName());
        } else if (Service.class.isAssignableFrom(effectiveType)) {
            if (effectiveType.getName().equals(Service.class.getName())) {
                if (!Service.class.isAssignableFrom(valueClass) || valueClass.getName().equals(Service.class.getName())) {
                    Tr.error((TraceComponent)tc, (String)"error.service.ref.member.level.merge.service.interface.wrong.value", (Object[])new Object[]{member.getName(), member.getDeclaringClass(), valueClass.getName()});
                    throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.member.level.merge.service.interface.wrong.value", (Object[])new Object[]{member.getName(), member.getDeclaringClass(), valueClass.getName()}));
                }
                this.wsrInfo.setServiceInterfaceClassName(valueClass.getName());
                this.wsrInfo.setServiceRefTypeClassName(valueClass.getName());
            } else {
                if (!valueClass.getName().equals(effectiveType.getName()) && !valueClass.getName().equals(Service.class.getName())) {
                    Tr.error((TraceComponent)tc, (String)"error.service.ref.member.level.merge.service.interface.and.service.ref.type.not.same", (Object[])new Object[]{member.getName(), member.getDeclaringClass().getName()});
                    throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.member.level.merge.service.interface.and.service.ref.type.not.same", (Object[])new Object[]{member.getName(), member.getDeclaringClass().getName()}));
                }
                this.wsrInfo.setServiceInterfaceClassName(effectiveType.getName());
                this.wsrInfo.setServiceRefTypeClassName(effectiveType.getName());
            }
        } else {
            if (!Service.class.isAssignableFrom(valueClass) || valueClass.getName().equals(Service.class.getName())) {
                Tr.error((TraceComponent)tc, (String)"error.service.ref.member.level.merge.service.interface.wrong.value", (Object[])new Object[]{member.getName(), member.getDeclaringClass(), valueClass.getName()});
                throw new InjectionException(Tr.formatMessage((TraceComponent)tc, (String)"error.service.ref.member.level.merge.service.interface.wrong.value", (Object[])new Object[]{member.getName(), member.getDeclaringClass(), valueClass.getName()}));
            }
            this.wsrInfo.setServiceRefTypeClassName(effectiveType.getName());
            this.wsrInfo.setServiceInterfaceClassName(valueClass.getName());
        }
    }

    private void processExistingWSDL(String wsdlLocation, Member newMember) throws InjectionException {
        if (this.wsrInfo.getWsdlLocation() != null && !"".equals(this.wsrInfo.getWsdlLocation())) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("For the " + this.wsrInfo.getJndiName() + " service reference, the " + this.wsrInfo.getWsdlLocation() + " WSDL file is specified in the deployment descriptor. Annotation metadata referencing a WSDL file for this service reference will be ignored."), (Object[])new Object[0]);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("For the " + this.wsrInfo.getJndiName() + " service reference, setting the wsdlLocation: " + wsdlLocation), (Object[])new Object[0]);
            }
            this.wsrInfo.setWsdlLocation(wsdlLocation);
        }
    }

    public WebServiceRefInfo getWebServiceRefInfo() {
        return this.wsrInfo;
    }

    public void setWebServiceRefInfo(WebServiceRefInfo info) {
        this.wsrInfo = info;
    }

    public boolean isResourceType() {
        return this.resourceType;
    }

    public void setResourceType(boolean resourceType) {
        this.resourceType = resourceType;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(((Object)((Object)this)).getClass().getName() + "@" + Integer.toHexString(System.identityHashCode((Object)this)) + "\n");
        sb.append("resourceType: " + String.valueOf(this.resourceType));
        sb.append("\nsuperclass: {\n" + super.toString() + "\n}");
        sb.append("\nwsrInfo: " + (this.wsrInfo != null ? "{\n" + this.wsrInfo.toString() + "\n}" : "<null>"));
        return sb.toString();
    }
}

