/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.Destroyable;
import com.ibm.ws.jaxws.client.JaxWsHandlerChainInstanceInterceptor;
import com.ibm.ws.jaxws.metadata.HandlerChainInfo;
import com.ibm.ws.jaxws.metadata.HandlerChainsInfo;
import com.ibm.ws.jaxws.metadata.HandlerInfo;
import com.ibm.ws.jaxws.metadata.JaxWsClientMetaData;
import com.ibm.ws.jaxws.metadata.WebServiceRefInfo;
import com.ibm.ws.jaxws.metadata.builder.HandlerChainInfoBuilder;
import com.ibm.ws.jaxws.support.JaxWsInstanceManager;
import com.ibm.ws.jaxws.utils.JaxWsUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import org.apache.cxf.Bus;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaxWsClientHandlerResolver
implements HandlerResolver,
Destroyable {
    private final Map<PortInfo, List<Handler>> handlersMap = new HashMap<PortInfo, List<Handler>>();
    private final WebServiceRefInfo wsrInfo;
    private final ClassLoader classLoader;
    private final HandlerChainInfoBuilder handlerChainBuilder;
    private final JaxWsClientMetaData clientMetaData;
    static final long serialVersionUID = 1271486765273508571L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JaxWsClientHandlerResolver(WebServiceRefInfo wsrInfo, JaxWsClientMetaData clientMetaData) {
        this.wsrInfo = wsrInfo;
        this.clientMetaData = clientMetaData;
        this.classLoader = clientMetaData.getModuleMetaData().getAppContextClassLoader();
        this.handlerChainBuilder = new HandlerChainInfoBuilder(this.classLoader);
    }

    public List<Handler> getHandlerChain(PortInfo paramPortInfo) {
        List<Handler> handlers = this.handlersMap.get(paramPortInfo);
        if (handlers == null) {
            handlers = this.createHandlerFromHandlerInfo(paramPortInfo);
            this.handlersMap.put(paramPortInfo, handlers);
        }
        return handlers;
    }

    protected List<Handler> createHandlerFromHandlerInfo(PortInfo paramPortInfo) {
        ArrayList<Handler> handlers;
        block5: {
            block4: {
                handlers = new ArrayList<Handler>();
                if (!this.wsrInfo.getHandlersFromXML()) break block4;
                for (HandlerChainInfo hcInfo : this.wsrInfo.getHandlerChains()) {
                    if (!JaxWsUtils.matchesQName(hcInfo.getServiceNamePattern(), paramPortInfo.getServiceName()) || !JaxWsUtils.matchesQName(hcInfo.getPortNamePattern(), paramPortInfo.getPortName())) continue;
                    boolean include = false;
                    for (String binding : hcInfo.getProtocolBindings()) {
                        if (!JaxWsUtils.singleProtocolMatches(binding, paramPortInfo.getBindingID())) continue;
                        include = true;
                        break;
                    }
                    if (!include && !hcInfo.getProtocolBindings().isEmpty()) continue;
                    for (HandlerInfo hInfo : hcInfo.getHandlerInfos()) {
                        Handler handler = this.constructInstance(hInfo);
                        if (handler == null) continue;
                        handlers.add(handler);
                    }
                }
                break block5;
            }
            if (this.wsrInfo.getHandlerChainAnnotation() == null) break block5;
            HandlerChainsInfo hChainsInfo = this.handlerChainBuilder.buildHandlerChainsInfoFromAnnotation(this.wsrInfo.getHandlerChainDeclaringClassName(), this.wsrInfo.getHandlerChainAnnotation(), paramPortInfo.getPortName(), paramPortInfo.getServiceName(), paramPortInfo.getBindingID());
            List<HandlerInfo> hInfos = hChainsInfo.getAllHandlerInfos();
            for (HandlerInfo hInfo : hInfos) {
                Handler handler = this.constructInstance(hInfo);
                if (handler == null) continue;
                handlers.add(handler);
            }
        }
        return HandlerChainInfoBuilder.sortHandlers(handlers);
    }

    /*
     * WARNING - void declaration
     */
    private Handler constructInstance(HandlerInfo handlerInfo) {
        try {
            return (Handler)this.clientMetaData.getModuleMetaData().getJaxWsInstanceManager().createInstance(handlerInfo.getHandlerClass(), new JaxWsHandlerChainInstanceInterceptor((Bus)this.clientMetaData.getClientBus(), handlerInfo));
        }
        catch (InstantiationException instantiationException) {
            void e;
            FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.jaxws.client.JaxWsClientHandlerResolver", (String)"138", (Object)this, (Object[])new Object[]{handlerInfo});
            throw new WebServiceException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxws.client.JaxWsClientHandlerResolver", (String)"140", (Object)this, (Object[])new Object[]{handlerInfo});
            throw new WebServiceException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxws.client.JaxWsClientHandlerResolver", (String)"142", (Object)this, (Object[])new Object[]{handlerInfo});
            throw new WebServiceException((Throwable)e);
        }
        catch (JaxWsInstanceManager.InterceptException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxws.client.JaxWsClientHandlerResolver", (String)"144", (Object)this, (Object[])new Object[]{handlerInfo});
            throw new WebServiceException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void destroy() {
        for (List<Handler> handlers : this.handlersMap.values()) {
            for (Handler handler : handlers) {
                try {
                    this.clientMetaData.getModuleMetaData().getJaxWsInstanceManager().destroyInstance(handler);
                }
                catch (JaxWsInstanceManager.InterceptException interceptException) {
                    void e;
                    FFDCFilter.processException((Throwable)interceptException, (String)"com.ibm.ws.jaxws.client.JaxWsClientHandlerResolver", (String)"162", (Object)this, (Object[])new Object[0]);
                    throw new WebServiceException((Throwable)e);
                }
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.client.JaxWsClientHandlerResolver", JaxWsClientHandlerResolver.class, null, null);
    }
}

