/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.internal.InstallLogUtils;
import java.util.HashMap;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class ProgressBar {
    private static ProgressBar progressBar;
    private static boolean activated;
    private HashMap<String, Double> methodMap;
    private static final StringBuilder res;
    private static final int MAX_EQUALS = 20;
    private static final int MAX_LINE_LENGTH;
    private static final String ANSI_GREEN_BLINKING = "\u001b[32;5m";
    private static double counter;

    public static ProgressBar getInstance() {
        if (progressBar == null) {
            progressBar = new ProgressBar();
        }
        activated = true;
        return progressBar;
    }

    private ProgressBar() {
        this.initMap();
        counter = 0.0;
        InstallLogUtils.activateProgressBar();
        AnsiConsole.systemInstall();
        System.out.println();
    }

    public void setMethodMap(HashMap<String, Double> methodMap) {
        this.methodMap = methodMap;
    }

    public double getMethodIncrement(String method) {
        if (this.methodMap.containsKey(method)) {
            return this.methodMap.get(method);
        }
        return 0.0;
    }

    private void initMap() {
        this.methodMap = new HashMap();
        this.methodMap.put("initializeMap", 10.0);
        this.methodMap.put("fetchJsons", 10.0);
        this.methodMap.put("resolvedFeatures", 20.0);
        this.methodMap.put("fetchArtifacts", 20.0);
        this.methodMap.put("installFeatures", 30.0);
        this.methodMap.put("cleanUp", 10.0);
    }

    public void updateMethodMap(String key, double val) {
        this.methodMap.put(key, val);
    }

    public void updateProgress(double increment) {
        counter += increment;
    }

    public void clearProgress() {
        System.out.print(Ansi.ansi().cursorUp(1).eraseLine().reset());
        System.out.flush();
    }

    public void display() {
        String equals = ProgressBar.progress(counter);
        StringBuilder dashes = new StringBuilder();
        for (int i = equals.length() - 1; i < 20; ++i) {
            dashes.append("-");
        }
        String data = String.format("%s<%s%s> %4.2f%%%s", Ansi.ansi().fg(Ansi.Color.RED), Ansi.ansi().a(ANSI_GREEN_BLINKING).a(equals).reset(), Ansi.ansi().fg(Ansi.Color.RED).a(dashes.toString()), (double)Math.round(counter), Ansi.ansi().reset());
        System.out.println(Ansi.ansi().a(data).reset());
    }

    private static String progress(double pct) {
        res.delete(0, res.length());
        int numEquals = 2 * (int)((pct + 9.0) / 10.0);
        for (int i = 0; i < numEquals; ++i) {
            res.append('=');
        }
        return res.toString();
    }

    public void finish() {
        System.out.println(Ansi.ansi().cursorUp(1).eraseLine().reset());
        System.out.print(Ansi.ansi().cursorUp(1).eraseLine().reset());
        System.out.flush();
        InstallLogUtils.deactivateProgressBar();
        AnsiConsole.systemUninstall();
    }

    public void finishWithError() {
        InstallLogUtils.deactivateProgressBar();
        AnsiConsole.systemUninstall();
    }

    public void manuallyUpdate() {
        this.clearProgress();
        this.display();
    }

    public double getCounter() {
        return counter;
    }

    public static boolean isActivated() {
        return activated;
    }

    static {
        activated = false;
        res = new StringBuilder();
        MAX_LINE_LENGTH = "[] 100.00%".length() + 20;
    }
}

