/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.composite;

import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.facelets.MetadataTarget;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.myfaces.util.lang.ClassUtils;

final class CompositeMetadataTargetImpl
extends MetadataTarget {
    private final Map<String, PropertyDescriptor> descriptors;
    private final MetadataTarget delegate;
    private final BeanInfo beanInfo;

    public CompositeMetadataTargetImpl(MetadataTarget delegate, BeanInfo beanInfo) throws IntrospectionException {
        this.delegate = delegate;
        this.beanInfo = beanInfo;
        this.descriptors = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            this.descriptors.put(descriptor.getName(), descriptor);
        }
    }

    public PropertyDescriptor getProperty(String name) {
        PropertyDescriptor pd = this.delegate.getProperty(name);
        if (pd == null) {
            pd = this.descriptors.get(name);
        }
        return pd;
    }

    public Class<?> getPropertyType(String name) {
        PropertyDescriptor pd = this.getProperty(name);
        if (pd != null) {
            Class<Object> type = pd.getValue("type");
            if (type != null) {
                if ((type = ((ValueExpression)type).getValue(FacesContext.getCurrentInstance().getELContext())) instanceof String) {
                    try {
                        type = ClassUtils.javaDefaultTypeToClass((String)((Object)type));
                    }
                    catch (ClassNotFoundException e) {
                        type = Object.class;
                    }
                }
                return type;
            }
            return pd.getPropertyType();
        }
        return null;
    }

    public Method getReadMethod(String name) {
        PropertyDescriptor pd = this.getProperty(name);
        if (pd != null) {
            return pd.getReadMethod();
        }
        return null;
    }

    public Class<?> getTargetClass() {
        return this.delegate.getTargetClass();
    }

    public Method getWriteMethod(String name) {
        PropertyDescriptor pd = this.getProperty(name);
        if (pd != null) {
            return pd.getWriteMethod();
        }
        return null;
    }

    public boolean isTargetInstanceOf(Class type) {
        return this.delegate.isTargetInstanceOf(type);
    }
}

