/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors;

import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.zip.GZIPOutputStream;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.AsyncWriterInterceptor;
import org.jboss.resteasy.spi.AsyncWriterInterceptorContext;
import org.jboss.resteasy.spi.BlockingAsyncOutputStream;
import org.jboss.resteasy.util.CommitHeaderAsyncOutputStream;
import org.jboss.resteasy.util.CommitHeaderOutputStream;

@Provider
@Priority(value=4000)
public class GZIPEncodingInterceptor
implements AsyncWriterInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        LogMessages.LOGGER.debugf("Interceptor : %s,  Method : aroundWriteTo", this.getClass().getName());
        if (this.isGzipEnconding((MultivaluedMap<String, Object>)context.getHeaders())) {
            OutputStream old = context.getOutputStream();
            this.removeContentLengthHeader((MultivaluedMap<String, Object>)context.getHeaders());
            CommittedGZIPOutputStream gzipOutputStream = this.replaceOutputStream(new BlockingAsyncOutputStream(old), arg_0 -> ((WriterInterceptorContext)context).setOutputStream(arg_0));
            try {
                context.proceed();
            }
            finally {
                gzipOutputStream.finish();
                context.setOutputStream(old);
            }
        } else {
            context.proceed();
        }
    }

    @Override
    public CompletionStage<Void> asyncAroundWriteTo(AsyncWriterInterceptorContext context) {
        LogMessages.LOGGER.debugf("Interceptor : %s,  Method : asyncAroundWriteTo", this.getClass().getName());
        if (this.isGzipEnconding(context.getHeaders())) {
            AsyncOutputStream old = context.getAsyncOutputStream();
            this.removeContentLengthHeader(context.getHeaders());
            CommittedGZIPOutputStream gzipOutputStream = this.replaceOutputStream(old, context::setAsyncOutputStream);
            return context.asyncProceed().handle((v, e) -> gzipOutputStream.asyncFinish().thenAccept(f -> context.setAsyncOutputStream(old))).thenCompose(x -> x);
        }
        return context.asyncProceed();
    }

    private boolean isGzipEnconding(MultivaluedMap<String, Object> headers) {
        Object encoding = headers.getFirst((Object)"Content-Encoding");
        return encoding != null && encoding.toString().equalsIgnoreCase("gzip");
    }

    private void removeContentLengthHeader(MultivaluedMap<String, Object> headers) {
        headers.remove((Object)"Content-Length");
    }

    private CommittedGZIPOutputStream replaceOutputStream(AsyncOutputStream originalStream, Consumer<AsyncOutputStream> contextSetter) {
        CommittedGZIPOutputStream gzipOutputStream = new CommittedGZIPOutputStream(originalStream, null);
        contextSetter.accept(gzipOutputStream);
        return gzipOutputStream;
    }

    public static class CommittedGZIPOutputStream
    extends CommitHeaderAsyncOutputStream {
        protected GZIPOutputStream gzip;

        protected CommittedGZIPOutputStream(OutputStream delegate, CommitHeaderOutputStream.CommitCallback headers) {
            this(new BlockingAsyncOutputStream(delegate), headers);
        }

        protected CommittedGZIPOutputStream(AsyncOutputStream delegate, CommitHeaderOutputStream.CommitCallback headers) {
            super(delegate, headers);
        }

        public GZIPOutputStream getGzip() {
            return this.gzip;
        }

        @Override
        public synchronized void commit() {
            if (this.isHeadersCommitted) {
                return;
            }
            this.isHeadersCommitted = true;
            try {
                this.gzip = new EndableGZIPOutputStream(this.delegate);
                this.delegate = new BlockingAsyncOutputStream(this.gzip);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        synchronized void finish() throws IOException {
            if (this.gzip != null) {
                this.gzip.finish();
            }
        }

        CompletionStage<Void> asyncFinish() {
            try {
                this.finish();
            }
            catch (IOException e) {
                CompletableFuture<Void> ret = new CompletableFuture<Void>();
                ret.completeExceptionally(e);
                return ret;
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    public static class EndableGZIPOutputStream
    extends GZIPOutputStream {
        public EndableGZIPOutputStream(OutputStream os) throws IOException {
            super(os);
        }

        @Override
        public void finish() throws IOException {
            super.finish();
            this.def.end();
        }
    }
}

