/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bytebuffer.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.bytebuffer.internal.WsByteBufferImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.NonWritableChannelException;

public class FCWsByteBufferImpl
extends WsByteBufferImpl {
    private static final long serialVersionUID = 4029999822511452951L;
    private static final String CLASS_NAME = FCWsByteBufferImpl.class.getName();
    private int status = 0;
    private int fcLimit = 0;
    private int fcSize = 0;
    private FileChannel fc = null;
    private static final TraceComponent tc = Tr.register(FCWsByteBufferImpl.class, (String)"WsByteBuffer", (String)"com.ibm.ws.bytebuffer.internal.resources.ByteBufferMessages");

    public FCWsByteBufferImpl() {
    }

    private final boolean isFCEnabled() {
        return (this.status & 2) != 0;
    }

    public FCWsByteBufferImpl(FileChannel _fc) {
        this.fc = _fc;
        this.status = 2;
        try {
            this.fcSize = this.fcLimit = (int)this.fc.size();
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("got IOException in FCWsByteBufferImpl: " + ioe), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)ioe, (String)(CLASS_NAME + ".ctor(FileChannel)"), (String)"57", (Object)this);
            throw new RuntimeException(ioe);
        }
        this.oByteBuffer = null;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setStatus(int) : " + value), (Object[])new Object[0]);
        }
        if (value == 1) {
            this.convertBufferIfNeeded();
        }
        this.status = value;
    }

    public FileChannel getFileChannel() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getFileChannel(): " + this.fc), (Object[])new Object[0]);
        }
        return this.fc;
    }

    private void convertBufferIfNeeded() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("convertBufferIfNeeded status: " + this.status), (Object[])new Object[0]);
        }
        if (this.isFCEnabled()) {
            this.status &= 0xFFFFFFFD;
            this.status |= 1;
            try {
                int bufPosition = (int)this.fc.position();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("creating a MappedByteBuffer from the FileChannel. position: 0  size: " + this.fc.size()), (Object[])new Object[0]);
                }
                try {
                    this.oByteBuffer = this.fc.map(FileChannel.MapMode.PRIVATE, 0L, this.fc.size());
                }
                catch (NonWritableChannelException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"FileChannel is readonly", (Object[])new Object[0]);
                    }
                    this.oByteBuffer = this.fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.fc.size());
                    this.setReadOnly(true);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("set MappedByteBuffer position to: " + bufPosition + " limit to: " + this.fcLimit), (Object[])new Object[0]);
                }
                this.position(bufPosition);
                this.limit(this.fcLimit);
            }
            catch (IOException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("got IOException: " + e), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".convertBufferIfNeeded"), (String)"112", (Object)this);
                throw new RuntimeException(e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("convertBufferIfNeeded status: " + this.status));
        }
    }

    @Override
    public void release() {
        block3: {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Closing FileChannel: " + this.fc), (Object[])new Object[0]);
                }
                this.fc.close();
            }
            catch (IOException ioe) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block3;
                Tr.event((TraceComponent)tc, (String)("Error closing filechannel: " + ioe), (Object[])new Object[0]);
            }
        }
        super.release();
    }

    @Override
    public byte[] array() {
        this.convertBufferIfNeeded();
        return super.array();
    }

    @Override
    public int arrayOffset() {
        this.convertBufferIfNeeded();
        return super.arrayOffset();
    }

    @Override
    public int capacity() {
        if (this.isFCEnabled()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("FileChannel capacity: " + this.fcSize), (Object[])new Object[0]);
            }
            return this.fcSize;
        }
        return super.capacity();
    }

    @Override
    public WsByteBuffer clear() {
        this.convertBufferIfNeeded();
        return super.clear();
    }

    @Override
    public WsByteBuffer compact() {
        this.convertBufferIfNeeded();
        return super.compact();
    }

    @Override
    public int compareTo(Object obj) {
        this.convertBufferIfNeeded();
        return super.compareTo(((WsByteBuffer)obj).getWrappedByteBufferNonSafe());
    }

    @Override
    public WsByteBuffer duplicate() {
        this.convertBufferIfNeeded();
        return super.duplicate();
    }

    @Override
    public WsByteBuffer flip() {
        this.convertBufferIfNeeded();
        return super.flip();
    }

    @Override
    public byte get() {
        this.convertBufferIfNeeded();
        return super.get();
    }

    @Override
    public WsByteBuffer get(byte[] dst) {
        this.convertBufferIfNeeded();
        return super.get(dst);
    }

    @Override
    public WsByteBuffer get(byte[] dst, int offset, int length) {
        this.convertBufferIfNeeded();
        return super.get(dst, offset, length);
    }

    @Override
    public byte get(int index) {
        this.convertBufferIfNeeded();
        return super.get(index);
    }

    @Override
    public char getChar() {
        this.convertBufferIfNeeded();
        return super.getChar();
    }

    @Override
    public char getChar(int index) {
        this.convertBufferIfNeeded();
        return super.getChar(index);
    }

    @Override
    public double getDouble() {
        this.convertBufferIfNeeded();
        return super.getDouble();
    }

    @Override
    public double getDouble(int index) {
        this.convertBufferIfNeeded();
        return super.getDouble(index);
    }

    @Override
    public float getFloat() {
        this.convertBufferIfNeeded();
        return super.getFloat();
    }

    @Override
    public float getFloat(int index) {
        this.convertBufferIfNeeded();
        return super.getFloat(index);
    }

    @Override
    public int getInt() {
        this.convertBufferIfNeeded();
        return super.getInt();
    }

    @Override
    public int getInt(int index) {
        this.convertBufferIfNeeded();
        return super.getInt(index);
    }

    @Override
    public long getLong() {
        this.convertBufferIfNeeded();
        return super.getLong();
    }

    @Override
    public long getLong(int index) {
        this.convertBufferIfNeeded();
        return super.getLong(index);
    }

    @Override
    public short getShort() {
        this.convertBufferIfNeeded();
        return super.getShort();
    }

    @Override
    public short getShort(int index) {
        this.convertBufferIfNeeded();
        return super.getShort(index);
    }

    @Override
    public ByteBuffer getWrappedByteBuffer() {
        this.convertBufferIfNeeded();
        return super.getWrappedByteBuffer();
    }

    @Override
    public ByteBuffer getWrappedByteBufferNonSafe() {
        this.convertBufferIfNeeded();
        return super.getWrappedByteBufferNonSafe();
    }

    @Override
    public boolean hasArray() {
        this.convertBufferIfNeeded();
        return super.hasArray();
    }

    @Override
    public boolean hasRemaining() {
        if (this.isFCEnabled()) {
            int remaining = this.fcLimit - this.position();
            if (remaining < 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"hasRmeaining, less than 0", (Object[])new Object[0]);
                }
                RuntimeException rte = new RuntimeException("FCWsByteBufferImpl.hasRemaining(): value is less than 0");
                FFDCFilter.processException((Throwable)rte, (String)(CLASS_NAME + ".hasRemaining()"), (String)"1115", (Object)this);
                throw rte;
            }
            return remaining > 0;
        }
        return super.hasRemaining();
    }

    @Override
    public boolean isDirect() {
        this.convertBufferIfNeeded();
        return super.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        this.convertBufferIfNeeded();
        return super.isReadOnly();
    }

    @Override
    public int limit() {
        if (this.isFCEnabled()) {
            return this.fcLimit;
        }
        return super.limit();
    }

    @Override
    public WsByteBuffer limit(int newLimit) {
        if (this.isFCEnabled()) {
            String errorMsg = null;
            if (newLimit > this.fcSize) {
                errorMsg = "Requested value for the WsByteBuffer limit was greater than the capacity";
            } else if (newLimit < 0) {
                errorMsg = "Requested value for the WsByteBuffer limit was less than 0";
            }
            if (errorMsg != null) {
                IllegalArgumentException iae = new IllegalArgumentException(errorMsg);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)iae, (String)(CLASS_NAME + ".limit(int)"), (String)"625", (Object)this);
                throw iae;
            }
            this.fcLimit = newLimit;
            return this;
        }
        return super.limit(newLimit);
    }

    @Override
    public WsByteBuffer mark() {
        this.convertBufferIfNeeded();
        return super.mark();
    }

    @Override
    public ByteOrder order() {
        this.convertBufferIfNeeded();
        return super.order();
    }

    @Override
    public WsByteBuffer order(ByteOrder bo) {
        this.convertBufferIfNeeded();
        return super.order(bo);
    }

    @Override
    public int position() {
        if (this.isFCEnabled()) {
            try {
                return (int)this.fc.position();
            }
            catch (IOException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception in position(): " + e), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".position"), (String)"656", (Object)this);
                throw new RuntimeException(e);
            }
        }
        return super.position();
    }

    @Override
    public WsByteBuffer position(int p) {
        if (this.isFCEnabled()) {
            try {
                this.fc.position(p);
                return this;
            }
            catch (IOException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception in position(int): " + e), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".position(int)"), (String)"687", (Object)this);
                throw new RuntimeException(e);
            }
        }
        return super.position(p);
    }

    @Override
    public WsByteBuffer put(byte b) {
        this.convertBufferIfNeeded();
        return super.put(b);
    }

    @Override
    public WsByteBuffer put(byte[] src) {
        this.convertBufferIfNeeded();
        return super.put(src);
    }

    @Override
    public WsByteBuffer put(byte[] src, int offset, int length) {
        this.convertBufferIfNeeded();
        return super.put(src, offset, length);
    }

    @Override
    public WsByteBuffer put(ByteBuffer src) {
        this.convertBufferIfNeeded();
        return super.put(src);
    }

    @Override
    public WsByteBuffer put(int index, byte b) {
        this.convertBufferIfNeeded();
        return super.put(index, b);
    }

    @Override
    public WsByteBuffer put(WsByteBuffer src) {
        this.convertBufferIfNeeded();
        return super.put(src);
    }

    @Override
    public WsByteBuffer put(WsByteBuffer[] src) {
        this.convertBufferIfNeeded();
        return super.put(src);
    }

    @Override
    public WsByteBuffer putChar(char value) {
        this.convertBufferIfNeeded();
        return super.putChar(value);
    }

    @Override
    public WsByteBuffer putChar(char[] values) {
        this.convertBufferIfNeeded();
        return super.putChar(values);
    }

    @Override
    public WsByteBuffer putChar(char[] values, int off, int len) {
        this.convertBufferIfNeeded();
        return super.putChar(values, off, len);
    }

    @Override
    public WsByteBuffer putChar(int index, char value) {
        this.convertBufferIfNeeded();
        return super.putChar(index, value);
    }

    @Override
    public WsByteBuffer putDouble(double value) {
        this.convertBufferIfNeeded();
        return super.putDouble(value);
    }

    @Override
    public WsByteBuffer putDouble(int index, double value) {
        this.convertBufferIfNeeded();
        return super.putDouble(index, value);
    }

    @Override
    public WsByteBuffer putFloat(float value) {
        this.convertBufferIfNeeded();
        return super.putFloat(value);
    }

    @Override
    public WsByteBuffer putFloat(int index, float value) {
        this.convertBufferIfNeeded();
        return super.putFloat(index, value);
    }

    @Override
    public WsByteBuffer putInt(int value) {
        this.convertBufferIfNeeded();
        return super.putInt(value);
    }

    @Override
    public WsByteBuffer putInt(int index, int value) {
        this.convertBufferIfNeeded();
        return super.putInt(index, value);
    }

    @Override
    public WsByteBuffer putLong(int index, long value) {
        this.convertBufferIfNeeded();
        return super.putLong(index, value);
    }

    @Override
    public WsByteBuffer putLong(long value) {
        this.convertBufferIfNeeded();
        return super.putLong(value);
    }

    @Override
    public WsByteBuffer putShort(int index, short value) {
        this.convertBufferIfNeeded();
        return super.putShort(index, value);
    }

    @Override
    public WsByteBuffer putShort(short value) {
        this.convertBufferIfNeeded();
        return super.putShort(value);
    }

    @Override
    public WsByteBuffer putString(String value) {
        this.convertBufferIfNeeded();
        return super.putString(value);
    }

    @Override
    public void readExternal(ObjectInput s) throws IOException, ClassNotFoundException {
        this.status = 1;
        super.readExternal(s);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"readExternal(ObjectInput)", (Object[])new Object[0]);
        }
    }

    @Override
    public int remaining() {
        if (this.isFCEnabled()) {
            int remaining = this.fcLimit - this.position();
            if (remaining < 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"remaining is less than 0", (Object[])new Object[0]);
                }
                RuntimeException rte = new RuntimeException("FCWsByteBufferImpl.remaining(): value is less than 0");
                FFDCFilter.processException((Throwable)rte, (String)(CLASS_NAME + ".remaining()"), (String)"1115", (Object)this);
                throw rte;
            }
            return remaining;
        }
        return super.remaining();
    }

    @Override
    public WsByteBuffer reset() {
        this.convertBufferIfNeeded();
        return super.reset();
    }

    @Override
    public WsByteBuffer rewind() {
        this.convertBufferIfNeeded();
        return super.rewind();
    }

    @Override
    public void setByteBuffer(ByteBuffer buffer) {
        this.convertBufferIfNeeded();
        super.setByteBuffer(buffer);
    }

    @Override
    public void setByteBufferNonSafe(ByteBuffer buffer) {
        this.convertBufferIfNeeded();
        super.setByteBufferNonSafe(buffer);
    }

    @Override
    public void setDirectShadowBuffer(ByteBuffer buffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setDirectShadowBuffer(ByteBuffer)", (Object[])new Object[0]);
        }
        this.convertBufferIfNeeded();
        super.setDirectShadowBuffer(buffer);
    }

    @Override
    public WsByteBuffer slice() {
        this.convertBufferIfNeeded();
        return super.slice();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getClass().getSimpleName());
        sb.append('@');
        sb.append(Integer.toHexString(this.hashCode()));
        sb.append(" [");
        if (this.isFCEnabled()) {
            if (null == this.fc) {
                sb.append("null");
            } else {
                sb.append(this.fc.toString());
                try {
                    sb.append(" pos=").append(this.fc.position());
                }
                catch (IOException x) {
                    sb.append(" pos=error");
                }
                sb.append(" lim=").append(this.fcLimit);
                sb.append(" cap=").append(this.fcSize);
            }
            sb.append(" status=").append(this.status);
        } else {
            sb.append(super.toString());
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput s) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"writeExternal(ObjectOutput)", (Object[])new Object[0]);
        }
        this.convertBufferIfNeeded();
        super.writeExternal(s);
    }
}

