/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.accesslists;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import io.openliberty.accesslists.AccessListKeysFacade;
import io.openliberty.accesslists.AddressAccessLists;
import io.openliberty.accesslists.filterlist.FilterList;
import io.openliberty.accesslists.filterlist.FilterListFastStr;
import io.openliberty.accesslists.filterlist.FilterListStr;
import java.net.InetAddress;

public class AddressAndHostNameAccessLists
extends AddressAccessLists {
    public FilterListStr hostNameExcludeList = null;
    public FilterListStr hostNameIncludeList = null;
    protected boolean caseInsensitiveHostnames = true;
    public static final TraceComponent tc = Tr.register(AddressAndHostNameAccessLists.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");

    public AddressAndHostNameAccessLists(FilterList _addressExcludeList, FilterList _addressIncludeList) {
        super(_addressExcludeList, _addressIncludeList);
    }

    public AddressAndHostNameAccessLists(FilterList _addressExcludeList, FilterListStr _hostNameExcludeList, FilterList _includeAccess, FilterListStr _hostNameIncludeList, boolean _caseInsensitiveHostnames) {
        super(_addressExcludeList, _includeAccess);
        this.hostNameExcludeList = _hostNameExcludeList;
        this.hostNameIncludeList = _hostNameIncludeList;
        this.caseInsensitiveHostnames = _caseInsensitiveHostnames;
    }

    public AddressAndHostNameAccessLists(Lists l, boolean caseInsensitiveHostsNames) {
        this(l.addressExcludeList, l.hostNameExcludeList, l.addressIncludeList, l.hostNameIncludeList, caseInsensitiveHostsNames);
    }

    protected boolean allIncludesEmpty() {
        return !this.addressIncludeList.getActive() && !this.hostNameIncludeList.getActive();
    }

    protected boolean inHostNameIncludeList(InetAddress addr) {
        if (!this.hostNameIncludeList.getActive()) {
            return false;
        }
        String hostname = addr.getHostName();
        if (this.caseInsensitiveHostnames && hostname != null) {
            hostname = hostname.toLowerCase();
        }
        return this.hostNameIncludeList.findInList(hostname);
    }

    protected boolean inHostNameExcludeList(InetAddress remoteAddr) {
        if (!this.hostNameExcludeList.getActive()) {
            return false;
        }
        String hostname = remoteAddr.getHostName();
        if (this.caseInsensitiveHostnames && hostname != null) {
            hostname = hostname.toLowerCase();
        }
        if (this.hostNameExcludeList.findInList(hostname)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Host name in exclude list, host name: " + remoteAddr.getHostName()), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean inExcludeList(InetAddress addr) {
        return this.inAddressExcludeList(addr) || this.inHostNameExcludeList(addr);
    }

    @Override
    protected boolean nonEmptyIncludesAndNotFound(InetAddress addr) {
        if (this.allIncludesEmpty()) {
            return false;
        }
        if (this.inAddressIncludeList(addr) || this.inHostNameIncludeList(addr)) {
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Address and host name not in include list, address: " + addr.getHostAddress() + " host name: " + addr.getHostName()), (Object[])new Object[0]);
        }
        return true;
    }

    public static AddressAndHostNameAccessLists getInstance(AccessListKeysFacade lists) {
        Lists filterLists = new Lists(lists);
        if (filterLists.active()) {
            return new AddressAndHostNameAccessLists(filterLists, lists.getCaseInsensitiveHostnames());
        }
        return null;
    }

    public static class Lists {
        public FilterList addressExcludeList;
        public FilterList addressIncludeList;
        public FilterListStr hostNameExcludeList;
        public FilterListStr hostNameIncludeList;

        public Lists(AccessListKeysFacade lists) {
            this.addressExcludeList = FilterList.create(lists.getAddressExcludeList());
            this.addressIncludeList = FilterList.create(lists.getAddressIncludeList());
            this.hostNameExcludeList = FilterListFastStr.create(lists.getHostNameExcludeList());
            this.hostNameIncludeList = FilterListFastStr.create(lists.getHostNameIncludeList());
        }

        private Lists() {
        }

        public boolean active() {
            return this.addressExcludeList != null && this.addressExcludeList.getActive() || this.addressIncludeList != null && this.addressIncludeList.getActive() || this.hostNameExcludeList != null && this.hostNameExcludeList.getActive() || this.hostNameIncludeList != null && this.hostNameIncludeList.getActive();
        }
    }
}

