/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jpa.JPAAccessor;
import com.ibm.ws.jpa.JPAPuId;
import com.ibm.ws.jpa.management.AbstractJPAComponent;
import com.ibm.ws.jpa.management.JPAEMPool;
import com.ibm.ws.jpa.management.JPAEntityManager;
import com.ibm.ws.jpa.management.JPAExEmInvocation;
import com.ibm.ws.jpa.management.JPANoTxEmInvocation;
import com.ibm.ws.jpa.management.JPAPUnitInfo;
import com.ibm.ws.jpa.management.JPARuntime;
import com.ibm.ws.jpa.management.JPATxEmInvocation;
import com.ibm.ws.uow.embeddable.SynchronizationRegistryUOWScope;
import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.TransactionRequiredException;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import jakarta.transaction.Synchronization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;

public class JPATxEntityManager
extends JPAEntityManager {
    private static final long serialVersionUID = -100536503951157420L;
    private static final String CLASS_NAME = JPATxEntityManager.class.getName();
    private static final TraceComponent tc = Tr.register(JPATxEntityManager.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    protected JPAPuId ivPuRefId;
    protected JPAPuId ivTxKeyPuId;
    protected J2EEName ivJ2eeName;
    protected String ivRefName;
    protected JPAEMPool ivEntityManagerPool;
    protected JPAPUnitInfo ivPuInfo;
    protected Map<?, ?> ivProperties;
    protected transient AbstractJPAComponent ivAbstractJPAComponent;

    private JPATxEntityManager() {
    }

    JPATxEntityManager(JPAEMPool pool, AbstractJPAComponent abstractJPAComponent, boolean txIsUnsynchronized) {
        super(txIsUnsynchronized);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[]{pool, abstractJPAComponent, txIsUnsynchronized});
        }
        this.ivEntityManagerPool = pool;
        this.ivAbstractJPAComponent = abstractJPAComponent;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    protected Object readResolve() {
        JPARuntime jpaRuntime = this.ivAbstractJPAComponent.getJPARuntime();
        return jpaRuntime.isDefault() ? this : jpaRuntime.createJPATxEntityManager(this.ivPuRefId, this.ivPuInfo, this.ivJ2eeName, this.ivRefName, this.ivProperties, this.ivUnsynchronized, this.ivAbstractJPAComponent);
    }

    public JPATxEntityManager(JPAPuId puRefId, JPAPUnitInfo puInfo, J2EEName j2eeName, String refName, Map<?, ?> properties, boolean isUnsynchronized, AbstractJPAComponent abstractJPAComponent) {
        super(isUnsynchronized);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[]{puRefId, puInfo, j2eeName, refName, properties, abstractJPAComponent, isUnsynchronized});
        }
        if (puInfo.getTransactionType() != PersistenceUnitTransactionType.JTA) {
            throw new RuntimeException("See JPA spec 5.5: " + puRefId + " must specify JTA transaction type.");
        }
        this.ivPuRefId = puRefId;
        this.ivPuInfo = puInfo;
        this.ivJ2eeName = j2eeName;
        this.ivRefName = refName;
        this.ivTxKeyPuId = puInfo.getPuId();
        this.ivProperties = properties;
        puRefId.setPuName(puInfo.getPersistenceUnitName());
        this.ivEntityManagerPool = puInfo.getEntityManagerPool(j2eeName, refName, properties);
        this.ivAbstractJPAComponent = abstractJPAComponent;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    protected EntityManager getEMInvocationInfo(boolean requireTx) {
        return this.getEMInvocationInfo(requireTx, null);
    }

    protected static String txIdToString(UOWCoordinator uowCoord) {
        if (uowCoord.isGlobal()) {
            String string = uowCoord.toString();
            int index = string.indexOf(35);
            return index == -1 ? "NoTx" : string.substring(index + 5);
        }
        return Integer.toHexString(System.identityHashCode(uowCoord)) + "(LTC)";
    }

    protected JPATxEmInvocation createJPATxEmInvocation(UOWCoordinator uowCoord, EntityManager em) {
        return new JPATxEmInvocation(uowCoord, em, this, this.ivUnsynchronized);
    }

    protected JPANoTxEmInvocation createJPANoTxEmInvocation(UOWCoordinator uowCoord, EntityManager em) {
        return new JPANoTxEmInvocation(uowCoord, em, this, this.ivUnsynchronized);
    }

    protected static SynchronizationRegistryUOWScope getSynchronizationRegistryUOWScope(UOWCoordinator uowCoord) {
        return (SynchronizationRegistryUOWScope)uowCoord;
    }

    protected static JPAExEmInvocation getInvocation(SynchronizationRegistryUOWScope uowSyncRegistry, JPAPuId txKeyPuId) {
        return (JPAExEmInvocation)uowSyncRegistry.getResource((Object)txKeyPuId);
    }

    protected static void setInvocation(SynchronizationRegistryUOWScope uowSyncRegistry, JPAPuId txKeyPuId, JPAExEmInvocation invocationEm) {
        uowSyncRegistry.putResource((Object)txKeyPuId, (Object)invocationEm);
    }

    @Override
    EntityManager getEMInvocationInfo(boolean requireTx, LockModeType mode) {
        boolean globalTx;
        UOWCoordinator uowCoord = this.ivAbstractJPAComponent.getUOWCurrent().getUOWCoord();
        SynchronizationRegistryUOWScope uowSyncRegistry = JPATxEntityManager.getSynchronizationRegistryUOWScope(uowCoord);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEMInvocationInfo : " + requireTx + " : tid=" + JPATxEntityManager.txIdToString(uowCoord)), (Object[])new Object[0]);
        }
        if (!(globalTx = uowCoord.isGlobal()) && (requireTx || mode != null && !LockModeType.NONE.equals((Object)mode))) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getEMInvocationInfo : TransactionRequiredException: No active transaction for " + this.ivPuRefId));
            }
            throw new TransactionRequiredException("No active transaction for " + this.ivPuRefId);
        }
        JPAExEmInvocation invocationEm = JPATxEntityManager.getInvocation(uowSyncRegistry, this.ivTxKeyPuId);
        if (invocationEm == null) {
            EntityManager em = this.ivEntityManagerPool.getEntityManager(globalTx, this.ivUnsynchronized);
            if (globalTx) {
                JPATxEmInvocation txEmInvocation = this.createJPATxEmInvocation(uowCoord, em);
                this.registerEmInvocation(uowCoord, txEmInvocation);
                invocationEm = txEmInvocation;
            } else {
                JPANoTxEmInvocation noTxEmInvocation = this.createJPANoTxEmInvocation(uowCoord, em);
                LocalTransactionCoordinator ltCoord = (LocalTransactionCoordinator)uowCoord;
                ltCoord.enlistSynchronization((Synchronization)noTxEmInvocation);
                invocationEm = noTxEmInvocation;
            }
            JPATxEntityManager.setInvocation(uowSyncRegistry, this.ivTxKeyPuId, invocationEm);
        } else if (invocationEm.isTxUnsynchronized() && !this.isTxUnsynchronized()) {
            Tr.error((TraceComponent)tc, (String)"JPATXSYNC_ILLEGAL_PROPAGATION_CWWJP0046E", (Object[])new Object[0]);
            String msgTxt = "CWWJP0046E: An UNSYNCHRONIZED JPA persistence context cannot be propagated into a SYNCHRONIZED EntityManager.";
            throw new IllegalStateException(msgTxt);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEMInvocationInfo : " + invocationEm));
        }
        return invocationEm;
    }

    @Override
    void closeTxEntityManager(EntityManager em, boolean allowPooling) {
        if (em != null && em.isOpen()) {
            if (allowPooling) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("closeTxEntityManager is pooling JTA em: " + em), (Object[])new Object[0]);
                }
                this.ivEntityManagerPool.putEntityManager(em);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("closeTxEntityManager is closing JTA em: " + em), (Object[])new Object[0]);
                }
                em.close();
            }
        }
    }

    @Override
    void closeNoTxEntityManager(JPANoTxEmInvocation noTxInvocation) {
        EntityManager em = noTxInvocation.ivEm;
        if (em != null && em.isOpen()) {
            if (noTxInvocation.ivAllowPooling) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("closeNoTxEntityManager is pooling noTx em: " + em), (Object[])new Object[0]);
                }
                this.ivEntityManagerPool.putEntityManager(em);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("closeNoTxEntityManager is closing noTx em: " + em), (Object[])new Object[0]);
                }
                em.close();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(this)) + "[" + this.ivPuRefId + ", " + this.ivJ2eeName + "#" + this.ivRefName + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("writeObject : " + this), (Object[])new Object[0]);
        }
        out.writeObject(this.ivPuRefId);
        out.writeObject(this.ivJ2eeName);
        out.writeObject(this.ivRefName);
        out.writeObject(this.ivProperties);
        out.writeBoolean(this.ivUnsynchronized);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("writeObject : " + this));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("readObject : " + this), (Object[])new Object[0]);
        }
        this.ivAbstractJPAComponent = (AbstractJPAComponent)JPAAccessor.getJPAComponent();
        this.ivPuRefId = (JPAPuId)in.readObject();
        this.ivJ2eeName = (J2EEName)in.readObject();
        this.ivRefName = (String)in.readObject();
        this.ivProperties = (Map)in.readObject();
        this.ivUnsynchronized = in.readBoolean();
        this.ivPuInfo = this.ivAbstractJPAComponent.findPersistenceUnitInfo(this.ivPuRefId);
        this.ivTxKeyPuId = this.ivPuInfo.getPuId();
        this.ivEntityManagerPool = this.ivPuInfo.getEntityManagerPool(this.ivJ2eeName, this.ivRefName, this.ivProperties);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("readObject : " + this));
        }
    }

    protected void registerEmInvocation(UOWCoordinator uowCoord, Synchronization emInvocation) {
        try {
            this.ivAbstractJPAComponent.getEmbeddableWebSphereTransactionManager().registerSynchronization(uowCoord, emInvocation, 0);
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("registerEmInvocation experienced unexpected exception while registering with transaction: " + e), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".registerEmInvocation"), (String)"507", (Object)this);
            throw new RuntimeException("Registration of Entity Manager invocation with Transaction failed.", e);
        }
    }
}

