/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.utils.LoggingUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CloudUtils {
    private static final TraceComponent tc = Tr.register(CloudUtils.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    static final long serialVersionUID = 3606865677063584841L;

    @FFDCIgnore(value={Exception.class})
    public static String getVCAPHost() {
        String vcapHost;
        block4: {
            vcapHost = null;
            String vcapApplication = System.getenv("VCAP_APPLICATION");
            if (vcapApplication != null) {
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    JsonNode node = (JsonNode)objectMapper.readValue(vcapApplication, JsonNode.class);
                    ArrayNode uris = (ArrayNode)node.get("uris");
                    if (uris != null && uris.size() > 0 && uris.get(0) != null) {
                        vcapHost = uris.get(0).textValue();
                    }
                }
                catch (Exception e) {
                    if (!LoggingUtils.isEventEnabled(tc)) break block4;
                    Tr.event((TraceComponent)tc, (String)("Exception while parsing VCAP_APPLICATION env: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
        return vcapHost;
    }

    public static InputStream getUrlAsStream(URL url, String acceptValue) throws IOException {
        int responseCode;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        if (acceptValue != null && !acceptValue.trim().isEmpty()) {
            connection.setRequestProperty("Accept", acceptValue);
        }
        if ((responseCode = connection.getResponseCode()) == 200) {
            return connection.getInputStream();
        }
        if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("Did not find resource at " + url + ".  ResponseCode: " + responseCode), (Object[])new Object[0]);
        }
        return null;
    }

    private CloudUtils() {
    }
}

