/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.css;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIUIBundlesListener
implements ServiceListener {
    private final ConcurrentHashMap<String, Boolean> expectedBundleNames;
    private final CountDownLatch countDownLatch;
    private final BundleContext bundleContext;
    static final long serialVersionUID = -8527346097707226358L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public OpenAPIUIBundlesListener(Set<Bundle> openAPIUIBundles, BundleContext context) throws InvalidSyntaxException {
        this.bundleContext = context;
        ConcurrentHashMap<String, Boolean> expectedBundleNames = new ConcurrentHashMap<String, Boolean>();
        for (Bundle bundle : openAPIUIBundles) {
            expectedBundleNames.put(bundle.getSymbolicName(), Boolean.TRUE);
        }
        this.expectedBundleNames = expectedBundleNames;
        this.countDownLatch = new CountDownLatch(expectedBundleNames.size());
    }

    private void removeIfExpectedBundle(ServiceReference<Bundle> ref) {
        String bundleName;
        String bundleKey = (String)ref.getProperty("web.module.key");
        if (bundleKey != null && this.expectedBundleNames.remove(bundleName = bundleKey.substring(0, bundleKey.indexOf(35))) != null) {
            this.countDownLatch.countDown();
        }
    }

    private void checkExistingServices(ServiceReference<Bundle>[] refs) {
        if (refs != null) {
            for (ServiceReference<Bundle> ref : refs) {
                this.removeIfExpectedBundle(ref);
            }
        }
    }

    public synchronized void serviceChanged(ServiceEvent event) {
        ServiceReference ref = event.getServiceReference();
        this.removeIfExpectedBundle((ServiceReference<Bundle>)ref);
    }

    public void await() throws InterruptedException, InvalidSyntaxException {
        this.bundleContext.addServiceListener((ServiceListener)this, "(&(objectClass=org.osgi.framework.Bundle)(installed.wab.contextRoot=*))");
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(Bundle.class.getName(), "(installed.wab.contextRoot=*)");
            this.checkExistingServices(refs);
            this.countDownLatch.await();
        }
        finally {
            this.bundleContext.removeServiceListener((ServiceListener)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi20.internal.css.OpenAPIUIBundlesListener", OpenAPIUIBundlesListener.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    }
}

