/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.util;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;

public class HashedArray {
    private static TraceComponent tc = SibTr.register(HashedArray.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private Element[][] buckets;
    private int[] counts;
    private int initBucketSize;
    private int totalSize;

    public HashedArray(int nbuckets, int initBucketSize) {
        this.init(nbuckets, initBucketSize);
    }

    private final void init(int nbuckets, int initBucketSize) {
        this.buckets = new Element[nbuckets][];
        this.counts = new int[nbuckets];
        this.initBucketSize = initBucketSize;
    }

    public synchronized Element get(long index) {
        int bind = ((int)index & Integer.MAX_VALUE) % this.buckets.length;
        Element[] bucket = this.buckets[bind];
        if (bucket == null) {
            return null;
        }
        for (int i = 0; i < this.counts[bind]; ++i) {
            if (bucket[i].getIndex() != index) continue;
            return bucket[i];
        }
        return null;
    }

    public synchronized void set(Element value) {
        int bind = ((int)value.getIndex() & Integer.MAX_VALUE) % this.buckets.length;
        Element[] bucket = this.buckets[bind];
        int count = this.counts[bind];
        if (bucket == null) {
            bucket = new Element[this.initBucketSize];
            this.buckets[bind] = bucket;
        } else if (bucket.length == count) {
            bucket = new Element[count * 2];
            System.arraycopy(this.buckets[bind], 0, bucket, 0, count);
            this.buckets[bind] = bucket;
        }
        bucket[count] = value;
        this.counts[bind] = count + 1;
        ++this.totalSize;
    }

    public int size() {
        return this.totalSize;
    }

    public synchronized Object[] toArray(Object[] values) {
        int count = 0;
        for (int bind = 0; bind < this.buckets.length; ++bind) {
            if (this.counts[bind] > 0) {
                System.arraycopy(this.buckets[bind], 0, values, count, this.counts[bind]);
            }
            count += this.counts[bind];
        }
        return values;
    }

    public synchronized Element remove(long index) {
        Element oldValue = this.get(index);
        if (oldValue != null) {
            int bind = ((int)index & Integer.MAX_VALUE) % this.buckets.length;
            Element[] bucket = this.buckets[bind];
            int count = this.counts[bind];
            int i = 0;
            while (bucket[i].getIndex() != index) {
                ++i;
            }
            System.arraycopy(bucket, i + 1, bucket, i, count - (i + 1));
            this.counts[bind] = count - 1;
            --this.totalSize;
        }
        return oldValue;
    }

    public static interface Element {
        public long getIndex();
    }
}

