/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class PagesVersionHandler {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.PagesVersionHandler";
    public static String LOADED_SPEC_LEVEL = PagesVersionHandler.loadPagesVersion();
    private static String DEFAULT_VERSION = "2.2";
    static final long serialVersionUID = -3042765420882985509L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public PagesVersionHandler() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    /*
     * Loose catch block
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static synchronized String loadPagesVersion() {
        block16: {
            InputStream input;
            String methodName;
            block13: {
                String string;
                block15: {
                    String string2;
                    block14: {
                        if (logger != null && logger.isLoggable(Level.FINER)) {
                            logger.entering(CLASS_NAME, "loadPagesVersion", new Object[0]);
                        }
                        methodName = "loadServletVersion";
                        input = PagesVersionHandler.class.getClassLoader().getResourceAsStream("com/ibm/ws/jsp/speclevel/jspSpecLevel.properties");
                        if (input == null) break block13;
                        Properties prop = new Properties();
                        prop.load(input);
                        string2 = prop.getProperty("version");
                        if (input == null) break block14;
                        input.close();
                    }
                    string = string2;
                    if (logger == null || !logger.isLoggable(Level.FINER)) break block15;
                    string = string;
                    logger.exiting(CLASS_NAME, "loadPagesVersion", string);
                }
                return string;
            }
            try {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, methodName, "InputStream was null for jspSpecLevel.properties");
                }
                break block16;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                }
            }
            catch (Exception ex) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block16;
                logger.logp(Level.FINE, CLASS_NAME, methodName, "Exception occured: " + ex.getCause());
            }
        }
        logger.logp(Level.WARNING, CLASS_NAME, "getLoadedPagesSpecLevel", "jsp.feature.not.loaded.correctly");
        String string = DEFAULT_VERSION;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "loadPagesVersion", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isPages30Loaded() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isPages30Loaded", new Object[0]);
        }
        if (LOADED_SPEC_LEVEL.equals("3.0")) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "isPages30Loaded", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isPages30Loaded", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isPages31Loaded() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isPages31Loaded", new Object[0]);
        }
        if (LOADED_SPEC_LEVEL.equals("3.1")) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "isPages31Loaded", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isPages31Loaded", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isPages31OrHigherLoaded() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isPages31OrHigherLoaded", new Object[0]);
        }
        if (Double.parseDouble(LOADED_SPEC_LEVEL) >= 3.1) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "isPages31OrHigherLoaded", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isPages31OrHigherLoaded", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isPages30OrLowerLoaded() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isPages30OrLowerLoaded", new Object[0]);
        }
        if (Double.parseDouble(LOADED_SPEC_LEVEL) <= 3.0) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "isPages30OrLowerLoaded", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isPages30OrLowerLoaded", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isPages31OrLowerLoaded() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isPages31OrLowerLoaded", new Object[0]);
        }
        if (Double.parseDouble(LOADED_SPEC_LEVEL) <= 3.1) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "isPages31OrLowerLoaded", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isPages31OrLowerLoaded", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isPages40OrHigherLoaded() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isPages40OrHigherLoaded", new Object[0]);
        }
        if (Double.parseDouble(LOADED_SPEC_LEVEL) >= 4.0) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "isPages40OrHigherLoaded", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isPages40OrHigherLoaded", bl);
        }
        return bl;
    }
}

