/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.InputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DefaultBufferedBlockCipher;
import org.bouncycastle.crypto.RawAgreement;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.OpenPGPCFBBlockCipher;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;
import org.bouncycastle.util.BigIntegers;

public class BcUtil {
    static BufferedBlockCipher createStreamCipher(boolean bl, BlockCipher blockCipher, boolean bl2, byte[] byArray) {
        DefaultBufferedBlockCipher defaultBufferedBlockCipher = bl2 ? new DefaultBufferedBlockCipher((BlockCipher)CFBBlockCipher.newInstance((BlockCipher)blockCipher, (int)(blockCipher.getBlockSize() * 8))) : new DefaultBufferedBlockCipher((BlockCipher)new OpenPGPCFBBlockCipher(blockCipher));
        KeyParameter keyParameter = new KeyParameter(byArray);
        if (bl2) {
            ((BufferedBlockCipher)defaultBufferedBlockCipher).init(bl, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, new byte[blockCipher.getBlockSize()]));
        } else {
            ((BufferedBlockCipher)defaultBufferedBlockCipher).init(bl, (CipherParameters)keyParameter);
        }
        return defaultBufferedBlockCipher;
    }

    public static PGPDataDecryptor createDataDecryptor(boolean bl, BlockCipher blockCipher, byte[] byArray) {
        final BufferedBlockCipher bufferedBlockCipher = BcUtil.createStreamCipher(false, blockCipher, bl, byArray);
        return new PGPDataDecryptor(){

            @Override
            public InputStream getInputStream(InputStream inputStream) {
                return new CipherInputStream(inputStream, bufferedBlockCipher);
            }

            @Override
            public int getBlockSize() {
                return bufferedBlockCipher.getBlockSize();
            }

            @Override
            public PGPDigestCalculator getIntegrityCalculator() {
                return new SHA1PGPDigestCalculator();
            }
        };
    }

    public static BufferedBlockCipher createSymmetricKeyWrapper(boolean bl, BlockCipher blockCipher, byte[] byArray, byte[] byArray2) {
        DefaultBufferedBlockCipher defaultBufferedBlockCipher = new DefaultBufferedBlockCipher((BlockCipher)CFBBlockCipher.newInstance((BlockCipher)blockCipher, (int)(blockCipher.getBlockSize() * 8)));
        ((BufferedBlockCipher)defaultBufferedBlockCipher).init(bl, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(byArray), byArray2));
        return defaultBufferedBlockCipher;
    }

    static X9ECParameters getX9Parameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParameters x9ECParameters = CustomNamedCurves.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        if (x9ECParameters == null) {
            x9ECParameters = ECNamedCurveTable.getByOID(aSN1ObjectIdentifier);
        }
        return x9ECParameters;
    }

    static ECPoint decodePoint(BigInteger bigInteger, ECCurve eCCurve) {
        return eCCurve.decodePoint(BigIntegers.asUnsignedByteArray(bigInteger));
    }

    static byte[] getSecret(RawAgreement rawAgreement, AsymmetricKeyParameter asymmetricKeyParameter, AsymmetricKeyParameter asymmetricKeyParameter2) {
        rawAgreement.init(asymmetricKeyParameter);
        byte[] byArray = new byte[rawAgreement.getAgreementSize()];
        rawAgreement.calculateAgreement(asymmetricKeyParameter2, byArray, 0);
        return byArray;
    }
}

