/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.CommsByteBufferPool;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.server.CommsServerByteBuffer;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.ConversationStateFullException;
import com.ibm.ws.sib.comms.server.IdToTransactionTable;
import com.ibm.ws.sib.comms.server.ServerLinkLevelState;
import com.ibm.ws.sib.comms.server.clientsupport.CATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.CATOrderingContext;
import com.ibm.ws.sib.comms.server.clientsupport.ChunkedMessageWrapper;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.HandshakeProperties;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.impl.JsMessageFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationSession;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;

public class StaticCATProducer {
    private static String CLASS_NAME = StaticCATProducer.class.getName();
    private static CommsByteBufferPool poolManager = CommsByteBufferPool.getInstance();
    private static final TraceComponent tc = SibTr.register(StaticCATProducer.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");

    static void rcvCreateProducerSess(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvCreateProducerSess", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool, "" + partOfExchange});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        short connectionObjectID = request.getShort();
        short orderId = request.getShort();
        short destinationTypeShort = request.getShort();
        boolean bindToQueuePoint = false;
        boolean preferLocalQueuePoint = true;
        HandshakeProperties handshakeProps = conversation.getHandshakeProperties();
        if (handshakeProps.getFapLevel() >= 9) {
            short producerFlags = request.getShort();
            if (producerFlags > 3) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Producer flags (" + producerFlags + ") > " + 3));
                }
                SIErrorException e = new SIErrorException(nls.getFormattedMessage("INVALID_PROP_SICO8018", new Object[]{"" + producerFlags}, null));
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateProducerSess"), (String)"3-008-0003");
                throw e;
            }
            bindToQueuePoint = (producerFlags & 1) != 0;
            boolean bl = preferLocalQueuePoint = (producerFlags & 2) != 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"ConnectionObjectID", (Object)connectionObjectID);
            SibTr.debug((TraceComponent)tc, (String)"MessageOrderId", (Object)orderId);
            SibTr.debug((TraceComponent)tc, (String)"DestinationType", (Object)destinationTypeShort);
            SibTr.debug((TraceComponent)tc, (String)"BindToQueuePoint", (Object)bindToQueuePoint);
            SibTr.debug((TraceComponent)tc, (String)"PreferLocalQueuePoint", (Object)preferLocalQueuePoint);
        }
        DestinationType destType = null;
        if (destinationTypeShort != -1) {
            destType = DestinationType.getDestinationType((int)destinationTypeShort);
        }
        try {
            SIDestinationAddress destAddress = request.getSIDestinationAddress(conversation.getHandshakeProperties().getFapLevel());
            String discriminator = request.getString();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Discriminator:", (Object)discriminator);
            }
            String alternateUser = request.getString();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Alternate User Id:", (Object)alternateUser);
            }
            SICoreConnection connection = ((CATConnection)convState.getObject(connectionObjectID)).getSICoreConnection();
            OrderingContext siOrder = null;
            if (orderId != 0) {
                siOrder = ((CATOrderingContext)convState.getObject(orderId)).getOrderingContext();
            }
            ProducerSession prodSession = connection.createProducerSession(destAddress, discriminator, destType, siOrder, alternateUser, bindToQueuePoint, preferLocalQueuePoint);
            short prodSessionObjectID = (short)convState.addObject(prodSession);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Producer Session Id:", (Object)prodSessionObjectID);
            }
            StaticCATHelper.sendSessionCreateResponse(200, requestNumber, conversation, prodSessionObjectID, (DestinationSession)prodSession, destAddress);
        }
        catch (SINotAuthorizedException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
        }
        catch (SIException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-008-0001", conversation, requestNumber);
        }
        catch (ConversationStateFullException e) {
            SILimitExceededException ex = new SILimitExceededException(nls.getFormattedMessage("MAX_SESSIONS_REACHED_SICO1019", new Object[]{"32767"}, null));
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".rcvCreateProducerSess"), (String)"3-008-0002");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
            }
            StaticCATHelper.sendExceptionToClient(e, "3-008-0002", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvCreateProducerSess");
        }
    }

    static void rcvCloseProducerSess(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvCloseProducerSess", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool, "" + partOfExchange});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        short connectionObjectID = request.getShort();
        short producerObjectID = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"connectionObjectID", (Object)connectionObjectID);
            SibTr.debug((TraceComponent)tc, (String)"producerObjectID", (Object)producerObjectID);
        }
        ProducerSession producerSession = (ProducerSession)convState.getObject(producerObjectID);
        try {
            producerSession.close();
            convState.removeObject(producerObjectID);
            try {
                conversation.send((JFapByteBuffer)poolManager.allocate(), 202, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCloseProducerSess"), (String)"3-008-0003");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2024", (Object)((Object)e));
            }
        }
        catch (SIException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-008-0004", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvCloseProducerSess");
        }
    }

    static void rcvSendSessMsg(CommsServerByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvSendSessMsg");
        }
        boolean optimizedTx = CommsUtils.requiresOptimizedTransaction((Conversation)conversation);
        StaticCATProducer.sendSessMsg(request, conversation, requestNumber, partOfExchange, allocatedFromBufferPool, true, optimizedTx);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvSendSessMsg");
        }
    }

    static void rcvSendSessMsgNoReply(CommsServerByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvSendSessMsgNoReply");
        }
        boolean optimizedTx = CommsUtils.requiresOptimizedTransaction((Conversation)conversation);
        StaticCATProducer.sendSessMsg(request, conversation, requestNumber, partOfExchange, allocatedFromBufferPool, false, optimizedTx);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvSendSessMsgNoReply");
        }
    }

    private static void sendSessMsg(CommsServerByteBuffer request, Conversation conversation, int requestNumber, boolean partOfExchange, boolean allocatedFromBufferPool, boolean sendReply, boolean txOptimized) {
        block22: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"sendSessMsg", (Object)new Object[]{request, conversation, "" + requestNumber, "" + partOfExchange, "" + allocatedFromBufferPool, "" + sendReply, "" + txOptimized});
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (sendReply) {
                    SibTr.debug((TraceComponent)tc, (String)"The client will be informed of the outcome");
                } else {
                    SibTr.debug((TraceComponent)tc, (String)"The client will NOT be informed of the outcome");
                }
            }
            ConversationState convState = (ConversationState)conversation.getAttachment();
            ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
            short connectionObjectId = request.getShort();
            short producerObjectId = request.getShort();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"connectionObjectId", (Object)connectionObjectId);
                SibTr.debug((TraceComponent)tc, (String)"producerObjectId", (Object)producerObjectId);
            }
            int transactionId = request.getSITransactionId(connectionObjectId, linkState, txOptimized);
            SITransaction siTran = linkState.getTransactionTable().get(transactionId);
            try {
                try {
                    int messageLength = (int)request.peekLong();
                    SIBusMessage sibMessage = request.getMessage(null);
                    ProducerSession producer = (ProducerSession)convState.getObject(producerObjectId);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Sending client message - " + sibMessage));
                        SibTr.debug((TraceComponent)tc, (String)("Destination: " + producer.getDestinationAddress()));
                        SibTr.debug((TraceComponent)tc, (String)("Discriminator: " + sibMessage.getDiscriminator()));
                        SibTr.debug((TraceComponent)tc, (String)("Reliability: " + sibMessage.getReliability()));
                    }
                    if (siTran != IdToTransactionTable.INVALID_TRANSACTION) {
                        producer.send(sibMessage, siTran);
                    }
                    if (!sendReply) break block22;
                    try {
                        conversation.send((JFapByteBuffer)poolManager.allocate(), 203, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                    }
                    catch (SIException e) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendSessMsg"), (String)"3-008-0005");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                        }
                        SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2024", (Object)((Object)e));
                    }
                }
                catch (Exception e) {
                    if (sendReply) {
                        throw e;
                    }
                    if (transactionId != 0) {
                        linkState.getTransactionTable().markAsRollbackOnly(transactionId, e);
                    }
                    if (!(e instanceof SIException) || !convState.hasMETerminated()) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendSessMsg"), (String)"3-008-0006");
                    }
                    SibTr.error((TraceComponent)tc, (SibTr.Suppressor)SibTr.Suppressor.ALL_FOR_A_WHILE_SIMILAR_INSERTS, (String)"UNABLE_TO_SEND_MESSAGE_SICO2009", (Object)e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Failed to send a message", (Object)e);
                    }
                }
            }
            catch (SIException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                StaticCATHelper.sendExceptionToClient(e, "3-008-0007", conversation, requestNumber);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendSessMsg"), (String)"3-008-0008");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
                }
                StaticCATHelper.sendExceptionToClient(e, "3-008-0008", conversation, requestNumber);
            }
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendSessMsg");
        }
    }

    static void rcvSendConnMsg(CommsServerByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvSendConnMsg");
        }
        boolean optimizedTx = CommsUtils.requiresOptimizedTransaction((Conversation)conversation);
        StaticCATProducer.sendConnMsg(request, conversation, requestNumber, partOfExchange, allocatedFromBufferPool, true, optimizedTx);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvSendConnMsg");
        }
    }

    static void rcvSendConnMsgNoReply(CommsServerByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvSendConnMsgNoReply");
        }
        boolean optimizedTx = CommsUtils.requiresOptimizedTransaction((Conversation)conversation);
        StaticCATProducer.sendConnMsg(request, conversation, requestNumber, partOfExchange, allocatedFromBufferPool, false, optimizedTx);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvSendConnMsgNoReply");
        }
    }

    private static void sendConnMsg(CommsServerByteBuffer request, Conversation conversation, int requestNumber, boolean partOfExchange, boolean allocatedFromBufferPool, boolean sendReply, boolean optimizedTx) {
        block27: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"sendConnMsg", (Object)new Object[]{request, conversation, "" + requestNumber, "" + partOfExchange, "" + allocatedFromBufferPool, "" + sendReply, "" + optimizedTx});
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (sendReply) {
                    SibTr.debug((TraceComponent)tc, (String)"The client will be informed of the outcome");
                } else {
                    SibTr.debug((TraceComponent)tc, (String)"The client will NOT be informed of the outcome");
                }
            }
            ConversationState convState = (ConversationState)conversation.getAttachment();
            ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
            short connectionObjectId = request.getShort();
            short orderId = request.getShort();
            int transactionId = request.getSITransactionId(connectionObjectId, linkState, optimizedTx);
            short destinationTypeShort = request.getShort();
            String alternateUser = request.getString();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"connectionObjectId", (Object)connectionObjectId);
                SibTr.debug((TraceComponent)tc, (String)"orderId", (Object)orderId);
                SibTr.debug((TraceComponent)tc, (String)"transactionId", (Object)transactionId);
                SibTr.debug((TraceComponent)tc, (String)"destinationType", (Object)destinationTypeShort);
                SibTr.debug((TraceComponent)tc, (String)"alternateUser", (Object)alternateUser);
            }
            SICoreConnection connection = ((CATConnection)convState.getObject(connectionObjectId)).getSICoreConnection();
            DestinationType destType = null;
            if (destinationTypeShort != -1) {
                destType = DestinationType.getDestinationType((int)destinationTypeShort);
            }
            try {
                SIDestinationAddress destAddress = request.getSIDestinationAddress(conversation.getHandshakeProperties().getFapLevel());
                int messageLength = (int)request.peekLong();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Message length", (Object)("" + messageLength));
                }
                SITransaction siTran = null;
                siTran = linkState.getTransactionTable().get(transactionId);
                OrderingContext siOrder = null;
                if (orderId != 0) {
                    siOrder = ((CATOrderingContext)convState.getObject(orderId)).getOrderingContext();
                }
                try {
                    SIBusMessage sibMessage = request.getMessage(null);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Sending client message - " + sibMessage));
                        SibTr.debug((TraceComponent)tc, (String)("Destination: " + destAddress));
                        SibTr.debug((TraceComponent)tc, (String)("Discriminator: " + sibMessage.getDiscriminator()));
                        SibTr.debug((TraceComponent)tc, (String)("Reliability: " + sibMessage.getReliability()));
                    }
                    if (siTran != IdToTransactionTable.INVALID_TRANSACTION) {
                        connection.send(sibMessage, siTran, destAddress, destType, siOrder, alternateUser);
                    }
                    if (!sendReply) break block27;
                    try {
                        conversation.send((JFapByteBuffer)poolManager.allocate(), 197, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                    }
                    catch (SIException e) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendConnMsg"), (String)"3-008-0009");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                        }
                        SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2024", (Object)((Object)e));
                    }
                }
                catch (Exception e) {
                    if (sendReply) {
                        throw e;
                    }
                    if (transactionId != 0) {
                        linkState.getTransactionTable().markAsRollbackOnly(transactionId, e);
                    }
                    if (!(e instanceof SIException) || !convState.hasMETerminated()) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendConnMsg"), (String)"3-008-0010");
                    }
                    SibTr.error((TraceComponent)tc, (SibTr.Suppressor)SibTr.Suppressor.ALL_FOR_A_WHILE_SIMILAR_INSERTS, (String)"UNABLE_TO_SEND_MESSAGE_SICO2009", (Object)e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Failed to send a message", (Object)e);
                    }
                }
            }
            catch (SINotAuthorizedException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
            }
            catch (SIException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                StaticCATHelper.sendExceptionToClient(e, "3-008-0011", conversation, requestNumber);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendConnMsg"), (String)"3-008-0012");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
                }
                StaticCATHelper.sendExceptionToClient(e, "3-008-0012", conversation, requestNumber);
            }
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendConnMsg");
        }
    }

    static void rcvSendChunkedSessMsg(CommsServerByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean sendReply) {
        block30: {
            ProducerSession producer;
            boolean last;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rcvSendSegmentedSessMsg", (Object)new Object[]{request, conversation, requestNumber, allocatedFromBufferPool, sendReply});
            }
            boolean txOptimized = CommsUtils.requiresOptimizedTransaction((Conversation)conversation);
            ConversationState convState = (ConversationState)conversation.getAttachment();
            ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
            ChunkedMessageWrapper wrapper = null;
            short connectionObjectId = request.getShort();
            short producerObjectId = request.getShort();
            int transactionId = request.getSITransactionId(connectionObjectId, linkState, txOptimized);
            byte flags = request.get();
            boolean first = (flags & 1) == 1;
            boolean bl = last = (flags & 4) == 4;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"connectionObjectId", (Object)connectionObjectId);
                SibTr.debug((TraceComponent)tc, (String)"producerObjectId", (Object)producerObjectId);
                SibTr.debug((TraceComponent)tc, (String)"transactionId", (Object)transactionId);
                SibTr.debug((TraceComponent)tc, (String)"flags", (Object)flags);
            }
            long wrapperId = StaticCATProducer.getWrapperId(connectionObjectId, producerObjectId, transactionId);
            if (first) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"This is the first chunk of data");
                }
                SITransaction siTran = linkState.getTransactionTable().get(transactionId);
                producer = (ProducerSession)convState.getObject(producerObjectId);
                wrapper = new ChunkedMessageWrapper(siTran, producer);
                convState.putChunkedMessageWrapper(wrapperId, wrapper);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Appending to chunks already collected");
                }
                wrapper = convState.getChunkedMessageWrapper(wrapperId);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Appending to wrapper: ", (Object)wrapper);
                }
            }
            if (wrapper == null) {
                SIErrorException e = new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.comms.CWSICMessages", (String)"CHUNK_WRAPPER_NULL_SICO2165", null, null));
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvSendSegmentedSessMsg"), (String)"3-008-0013", (Object)("" + wrapperId));
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Chunked message wrapper is null!");
                }
                throw e;
            }
            wrapper.addDataSlice(request.getDataSlice());
            if (last) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"This is the last chunk - sending message");
                    if (sendReply) {
                        SibTr.debug((TraceComponent)tc, (String)"The client will be informed of the outcome");
                    } else {
                        SibTr.debug((TraceComponent)tc, (String)"The client will NOT be informed of the outcome");
                    }
                }
                convState.removeChunkedMessageWrapper(wrapperId);
                try {
                    JsMessage sibMessage = JsMessageFactory.getInstance().createInboundJsMessage(wrapper.getMessageData());
                    producer = wrapper.getProducerSession();
                    SITransaction siTran = wrapper.getTransaction();
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Sending client message - " + sibMessage));
                            SibTr.debug((TraceComponent)tc, (String)("Destination: " + producer.getDestinationAddress()));
                            SibTr.debug((TraceComponent)tc, (String)("Discriminator: " + sibMessage.getDiscriminator()));
                            SibTr.debug((TraceComponent)tc, (String)("Reliability: " + sibMessage.getReliability()));
                        }
                        if (siTran != IdToTransactionTable.INVALID_TRANSACTION) {
                            producer.send((SIBusMessage)sibMessage, siTran);
                        }
                        if (!sendReply) break block30;
                        try {
                            conversation.send((JFapByteBuffer)poolManager.allocate(), 245, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                        }
                        catch (SIException e) {
                            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvSendSegmentedSessMsg"), (String)"3-008-0014");
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                            }
                            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2024", (Object)((Object)e));
                        }
                    }
                    catch (Exception e) {
                        if (sendReply) {
                            throw e;
                        }
                        if (transactionId != 0) {
                            linkState.getTransactionTable().markAsRollbackOnly(transactionId, e);
                        }
                        if (!(e instanceof SIException) || !convState.hasMETerminated()) {
                            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvSendSegmentedSessMsg"), (String)"3-008-0015");
                        }
                        SibTr.error((TraceComponent)tc, (SibTr.Suppressor)SibTr.Suppressor.ALL_FOR_A_WHILE_SIMILAR_INSERTS, (String)"UNABLE_TO_SEND_MESSAGE_SICO2009", (Object)e);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Failed to send a message", (Object)e);
                        }
                    }
                }
                catch (SIException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                    }
                    StaticCATHelper.sendExceptionToClient(e, "3-008-0016", conversation, requestNumber);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvSendSegmentedSessMsg"), (String)"3-008-0017");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
                    }
                    StaticCATHelper.sendExceptionToClient(e, "3-008-0017", conversation, requestNumber);
                }
            }
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvSendSegmentedSessMsg");
        }
    }

    static void rcvSendChunkedConnMsg(CommsServerByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean sendReply) {
        block34: {
            boolean last;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rcvSendSegmentedConnMsg", (Object)new Object[]{request, conversation, requestNumber, allocatedFromBufferPool, sendReply});
            }
            boolean txOptimized = CommsUtils.requiresOptimizedTransaction((Conversation)conversation);
            ConversationState convState = (ConversationState)conversation.getAttachment();
            ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
            ChunkedMessageWrapper wrapper = null;
            short connectionObjectId = request.getShort();
            short orderId = request.getShort();
            int transactionId = request.getSITransactionId(connectionObjectId, linkState, txOptimized);
            byte flags = request.get();
            boolean first = (flags & 1) == 1;
            boolean bl = last = (flags & 4) == 4;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"connectionObjectId", (Object)connectionObjectId);
                SibTr.debug((TraceComponent)tc, (String)"orderId", (Object)orderId);
                SibTr.debug((TraceComponent)tc, (String)"transactionId", (Object)transactionId);
                SibTr.debug((TraceComponent)tc, (String)"flags", (Object)flags);
            }
            long wrapperId = StaticCATProducer.getWrapperId(connectionObjectId, orderId, transactionId);
            if (first) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"This is the first chunk of data");
                }
                short destinationTypeShort = request.getShort();
                String alternateUser = request.getString();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"destinationType", (Object)destinationTypeShort);
                    SibTr.debug((TraceComponent)tc, (String)"alternateUser", (Object)alternateUser);
                }
                SICoreConnection connection = ((CATConnection)convState.getObject(connectionObjectId)).getSICoreConnection();
                DestinationType destType = null;
                if (destinationTypeShort != -1) {
                    destType = DestinationType.getDestinationType((int)destinationTypeShort);
                }
                SIDestinationAddress destAddress = request.getSIDestinationAddress(conversation.getHandshakeProperties().getFapLevel());
                int messageLength = (int)request.peekLong();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Message length", (Object)("" + messageLength));
                }
                SITransaction siTran = linkState.getTransactionTable().get(transactionId);
                OrderingContext siOrder = null;
                if (orderId != 0) {
                    siOrder = ((CATOrderingContext)convState.getObject(orderId)).getOrderingContext();
                }
                wrapper = new ChunkedMessageWrapper(siTran, connection, destType, destAddress, siOrder, alternateUser);
                convState.putChunkedMessageWrapper(wrapperId, wrapper);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Appending to chunks already collected");
                }
                wrapper = convState.getChunkedMessageWrapper(wrapperId);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Appending to wrapper: ", (Object)wrapper);
                }
            }
            if (wrapper == null) {
                SIErrorException e = new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.comms.CWSICMessages", (String)"CHUNK_WRAPPER_NULL_SICO2165", null, null));
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvSendSegmentedSessMsg"), (String)"3-008-0018", (Object)("" + wrapperId));
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Chunked message wrapper is null!");
                }
                throw e;
            }
            wrapper.addDataSlice(request.getDataSlice());
            if (last) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"This is the last chunk - sending message");
                    if (sendReply) {
                        SibTr.debug((TraceComponent)tc, (String)"The client will be informed of the outcome");
                    } else {
                        SibTr.debug((TraceComponent)tc, (String)"The client will NOT be informed of the outcome");
                    }
                }
                convState.removeChunkedMessageWrapper(wrapperId);
                try {
                    JsMessage sibMessage = JsMessageFactory.getInstance().createInboundJsMessage(wrapper.getMessageData());
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Sending client message - " + sibMessage));
                            SibTr.debug((TraceComponent)tc, (String)("Destination: " + wrapper.getDestinationAddress()));
                            SibTr.debug((TraceComponent)tc, (String)("Discriminator: " + sibMessage.getDiscriminator()));
                            SibTr.debug((TraceComponent)tc, (String)("Reliability: " + sibMessage.getReliability()));
                        }
                        if (wrapper.getTransaction() != IdToTransactionTable.INVALID_TRANSACTION) {
                            wrapper.getConnection().send((SIBusMessage)sibMessage, wrapper.getTransaction(), wrapper.getDestinationAddress(), wrapper.getDestinationType(), wrapper.getOrderingContext(), wrapper.getAlternateUser());
                        }
                        if (!sendReply) break block34;
                        try {
                            conversation.send((JFapByteBuffer)poolManager.allocate(), 246, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                        }
                        catch (SIException e) {
                            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvSendChunkedConnMsg"), (String)"3-008-0019");
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                            }
                            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2024", (Object)((Object)e));
                        }
                    }
                    catch (Exception e) {
                        if (sendReply) {
                            throw e;
                        }
                        if (transactionId != 0) {
                            linkState.getTransactionTable().markAsRollbackOnly(transactionId, e);
                        }
                        if (!(e instanceof SIException) || !convState.hasMETerminated()) {
                            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvSendChunkedConnMsg"), (String)"3-008-0020");
                        }
                        SibTr.error((TraceComponent)tc, (SibTr.Suppressor)SibTr.Suppressor.ALL_FOR_A_WHILE_SIMILAR_INSERTS, (String)"UNABLE_TO_SEND_MESSAGE_SICO2009", (Object)e);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Failed to send a message", (Object)e);
                        }
                    }
                }
                catch (SIException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                    }
                    StaticCATHelper.sendExceptionToClient(e, "3-008-0021", conversation, requestNumber);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvSendChunkedConnMsg"), (String)"3-008-0022");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
                    }
                    StaticCATHelper.sendExceptionToClient(e, "3-008-0022", conversation, requestNumber);
                }
            }
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvSendSegmentedConnMsg");
        }
    }

    static long getWrapperId(short connectionId, short producerId, int transactionId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getWrapperId", (Object)new Object[]{connectionId, producerId, transactionId});
        }
        long wrapperId = ((long)connectionId << 48) + ((long)producerId << 32) + (long)transactionId;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getWrapperId", (Object)wrapperId);
        }
        return wrapperId;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/StaticCATProducer.java, SIB.comms, WASX.SIB, aa1225.01 1.78");
        }
    }
}

