/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.session;

import java.util.List;

public class SessionAffinityContext {
    public static final String SSLSessionId = "SESSIONMANAGEMENTAFFINI";
    private boolean _reqFromCookie = false;
    private String _redirectCloneId = null;
    private boolean _reqFromURL = false;
    private boolean _reqFromSSL = false;
    private boolean _reqFromClient = false;
    private String _requestedSessionID = null;
    private String _firstRequestedSessionId = null;
    private int _numSessIds = 0;
    private List _allSessionIds = null;
    private boolean _allSessionIdsSetViaSet = false;
    private String _inputCloneInfo = "";
    private String _outputCloneInfo = null;
    private int _requestedSessionVersion = 0;
    private String _responseSessionID = null;
    private int _responseSessionVersion = -1;
    private boolean sessionCookieSet = false;
    private boolean firstSessionIdValid = true;

    public SessionAffinityContext(boolean reqFromCookie, boolean reqFromURL, String reqSessionID, int reqSessionVersion) {
        this._reqFromCookie = reqFromCookie;
        this._reqFromURL = reqFromURL;
        this._requestedSessionID = reqSessionID;
        this._requestedSessionVersion = reqSessionVersion;
        if (reqSessionID != null) {
            this._firstRequestedSessionId = reqSessionID;
            this._numSessIds = 1;
        }
    }

    public SessionAffinityContext(List allSessionIds, boolean reqFromCookie, boolean reqFromURL, boolean reqFromSSL) {
        this._allSessionIds = allSessionIds;
        this._reqFromCookie = reqFromCookie;
        this._reqFromURL = reqFromURL;
        this._reqFromSSL = reqFromSSL;
        if (allSessionIds != null && !allSessionIds.isEmpty()) {
            this._firstRequestedSessionId = (String)allSessionIds.get(0);
            this._numSessIds = allSessionIds.size();
        }
    }

    public SessionAffinityContext(List allSessionIds, boolean reqFromCookie, boolean reqFromURL, boolean reqFromSSL, boolean reqFromClient) {
        this._allSessionIds = allSessionIds;
        this._reqFromCookie = reqFromCookie;
        this._reqFromURL = reqFromURL;
        this._reqFromSSL = reqFromSSL;
        this._reqFromClient = reqFromClient;
        if (allSessionIds != null && !allSessionIds.isEmpty()) {
            this._firstRequestedSessionId = (String)allSessionIds.get(0);
            this._numSessIds = allSessionIds.size();
        }
        if (this._reqFromClient) {
            this.setFirstSessionIdValid(false);
        }
    }

    public final boolean isRequestedSessionIDFromCookie() {
        return this._reqFromCookie;
    }

    public final boolean isRequestedSessionIDFromURL() {
        return this._reqFromURL;
    }

    public final boolean isRequestedSessionIDFromSSL() {
        return this._reqFromSSL;
    }

    public final String getRequestedSessionID() {
        return this._requestedSessionID;
    }

    public final String getFirstRequestedSessionID() {
        return this._firstRequestedSessionId;
    }

    public final int getNumSessionIds() {
        return this._numSessIds;
    }

    public final void setRequestedSessionID(String id) {
        this._requestedSessionID = id;
    }

    public final String getInputCloneInfo() {
        return this._inputCloneInfo;
    }

    public final void setInputCloneInfo(String cloneInfo) {
        this._inputCloneInfo = cloneInfo;
    }

    public final void setOutputCloneInfo(String outputCloneInfo) {
        this._outputCloneInfo = outputCloneInfo;
    }

    public final String getOutputCloneInfo() {
        return this._outputCloneInfo;
    }

    public final List getAllSessionIds() {
        return this._allSessionIds;
    }

    public final int getRequestedSessionVersion() {
        return this._requestedSessionVersion;
    }

    public final void setRequestedVersion(int version) {
        this._requestedSessionVersion = version;
    }

    public final String getResponseSessionID() {
        return this._responseSessionID;
    }

    public void setResponseSessionID(String sessionID) {
        this._responseSessionID = this.isRequestedSessionIDFromSSL() ? SSLSessionId : sessionID;
    }

    public final int getResponseSessionVersion() {
        return this._responseSessionVersion;
    }

    public final void setResponseSessionVersion(int version) {
        this._responseSessionVersion = version;
    }

    public final void setRedirectCloneID(String cloneId) {
        this._redirectCloneId = cloneId;
    }

    public final String getRedirectCloneID() {
        return this._redirectCloneId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("# SessionAffinityContext # \n { ").append("\n _reqFromCookie=").append(this._reqFromCookie).append("\n _reqFromURL=").append(this._reqFromURL).append("\n _requestedSessionID=").append(this._requestedSessionID).append("\n _requestedSessionVersion=").append(this._requestedSessionVersion).append("\n _redirectCloneId=").append(this._redirectCloneId).append("\n _reqFromSSL=").append(this._reqFromSSL).append("\n _allSessionIds=").append(this._allSessionIds).append("\n _inputCloneInfo=").append(this._inputCloneInfo).append("\n _responseSessionVersion=").append(this._responseSessionVersion).append("\n _responseSessionID=").append(this._responseSessionID).append("\n _outputCloneInfo=").append(this._outputCloneInfo).append("\n } \n");
        return sb.toString();
    }

    public final boolean isResponseIdSet() {
        return this._responseSessionID != null;
    }

    public final boolean isRequestedIdSet() {
        return this._requestedSessionID != null;
    }

    public final boolean isAllSessionIdsSetViaSet() {
        return this._allSessionIdsSetViaSet;
    }

    public final boolean isOutputCloneInfoSet() {
        return this._outputCloneInfo != null;
    }

    public final void setAllSessionIds(List allSessionIds) {
        if (allSessionIds != null && allSessionIds.size() > 0) {
            this._allSessionIds = allSessionIds;
            this._numSessIds = allSessionIds.size();
            if (this._firstRequestedSessionId.equals((String)allSessionIds.get(0))) {
                allSessionIds.remove(0);
            }
        }
        this._allSessionIdsSetViaSet = true;
    }

    public boolean isSessionCookieSet() {
        return this.sessionCookieSet;
    }

    public void setSessionCookieSet(boolean sessionCookieSet) {
        this.sessionCookieSet = sessionCookieSet;
    }

    public void setFirstSessionIdValid(boolean firstSessionIdValid) {
        this.firstSessionIdValid = firstSessionIdValid;
    }

    public boolean isFirstSessionIdValid() {
        return this.firstSessionIdValid;
    }
}

