/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.session.IBMSessionListener;
import com.ibm.ws.session.http.HttpSessionObserver;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.wsspi.session.IProtocolAdapter;
import com.ibm.wsspi.session.ISession;
import jakarta.servlet.http.HttpSessionListener;
import java.util.ArrayList;
import java.util.logging.Level;

public class WasHttpSessionObserver
extends HttpSessionObserver {
    private static final String methodClassName = "WasHttpSessionObserver";
    private boolean doesContainIBMSessionListener = false;

    public WasHttpSessionObserver(ArrayList listeners, IProtocolAdapter adapter) {
        super(listeners, adapter);
    }

    public WasHttpSessionObserver(ArrayList listeners, ArrayList idListeners, IProtocolAdapter adapter) {
        super(listeners, idListeners, adapter);
    }

    @Override
    public void sessionCacheDiscard(Object value) {
        HttpSessionListener listener = null;
        if (this.doesContainIBMSessionListener) {
            for (int i = this._sessionListeners.size() - 1; i >= 0; --i) {
                listener = (HttpSessionListener)this._sessionListeners.get(i);
                if (listener == null || !(listener instanceof IBMSessionListener)) continue;
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "sessionCacheDiscard", "Calling sessionCacheDiscard on listener:" + listener);
                }
                ((IBMSessionListener)listener).sessionRemovedFromCache(((ISession)value).getId());
            }
        }
    }

    public void setDoesContainIBMSessionListener(boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "setDoesContainIBMSessionListener", "" + value);
        }
        this.doesContainIBMSessionListener = value;
    }

    public boolean getDoesContainIBMSessionListener() {
        return this.doesContainIBMSessionListener;
    }
}

