/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ras;

import com.ibm.ejs.ras.TrLevelConstants;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceEnabledToken;
import com.ibm.websphere.ras.TraceStateChangeListener;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.kernel.provisioning.packages.PackageIndex;
import com.ibm.ws.logging.internal.TraceSpecification;
import com.ibm.ws.logging.internal.WsLogger;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TraceComponent
implements FFDCSelfIntrospectable {
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final int INFO_FINE_LEVEL;
    private static final int INFO_FINE_LEVELS_ENABLED;
    private static final int INFO_TRACE_LEVEL;
    private final String name;
    private final Class<?> aClass;
    private String[] groups;
    private String bundle;
    private volatile Logger logger;
    private TraceStateChangeListener trStateChangeListener;
    protected int specTraceLevel;
    private int fineLevel;
    private int fineLevelsEnabled;
    private boolean isTraceOff;
    private static TraceEnabledToken fineTraceEnabled;

    static void setAnyTracingEnabled(boolean useFineTrace) {
        fineTraceEnabled = useFineTrace ? new TraceEnabledToken() : null;
    }

    public static boolean isAnyTracingEnabled() {
        return fineTraceEnabled != null;
    }

    protected TraceComponent(Class<?> aClass) {
        this(null, aClass, (String)null, null);
    }

    protected TraceComponent(String name) {
        this(name, null, (String)null, null);
    }

    protected TraceComponent(String name, Class<?> aClass) {
        this(name, aClass, (String)null, null);
    }

    protected TraceComponent(String name, Class<?> aClass, String group, String bundle) {
        String[] stringArray;
        if (group == null) {
            stringArray = EMPTY_STRING_ARRAY;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = group;
        }
        this(name, aClass, stringArray, false, bundle);
    }

    protected TraceComponent(String name, Class<?> aClass, String[] groups, String bundle) {
        this(name, aClass, groups == null ? EMPTY_STRING_ARRAY : groups, true, bundle);
    }

    TraceComponent(String name, Class<?> aClass, String[] groups, boolean cloneGroups, String bundle) {
        this.logger = null;
        this.trStateChangeListener = null;
        this.fineLevel = 11;
        this.isTraceOff = false;
        if (name == null) {
            if (aClass == null) {
                throw new NullPointerException("Must declare a trace component with either a name, a class, or both");
            }
            name = aClass.getName();
        }
        this.name = name;
        this.aClass = aClass;
        this.groups = TraceComponent.uniquify(groups, cloneGroups);
        this.bundle = bundle;
    }

    static String[] uniquify(String[] arr, boolean alwaysClone) {
        int numUnique = TraceComponent.uniquifyCountAndCopy(arr, null);
        if (numUnique == 0) {
            return EMPTY_STRING_ARRAY;
        }
        if (numUnique == arr.length) {
            return alwaysClone ? (String[])arr.clone() : arr;
        }
        String[] out = new String[numUnique];
        TraceComponent.uniquifyCountAndCopy(arr, out);
        return out;
    }

    private static int uniquifyCountAndCopy(String[] in, String[] out) {
        int count = 0;
        block0: for (int i = 0; i < in.length; ++i) {
            if (in[i] == null) continue;
            for (int j = 0; j < i; ++j) {
                if (in[i].equals(in[j])) continue block0;
            }
            if (out != null) {
                out[count] = in[i];
            }
            ++count;
        }
        return count;
    }

    public Class<?> getTraceClass() {
        return this.aClass;
    }

    public synchronized Logger getLogger() {
        if (this.logger == null) {
            WsLogger.loggerRegistrationComponent.set(this);
            try {
                this.logger = Logger.getLogger(this.name, this.bundle);
                this.logger.setLevel(this.getLoggerLevel());
            }
            finally {
                WsLogger.loggerRegistrationComponent.remove();
            }
        }
        return this.logger;
    }

    synchronized void addGroup(String group) {
        if (!TraceComponent.contains(this.groups, group)) {
            String[] newGroups = Arrays.copyOf(this.groups, this.groups.length + 1);
            newGroups[this.groups.length] = group;
            this.groups = newGroups;
            this.setTraceSpec(TrConfigurator.getTraceSpec());
        }
    }

    private static boolean contains(String[] haystack, String needle) {
        for (String value : haystack) {
            if (!needle.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    protected void setTraceSpec(String s) {
        if (s != null) {
            TraceSpecification ts = new TraceSpecification(s, null, false);
            this.setTraceSpec(ts);
        }
    }

    final synchronized void setTraceSpec(TraceSpecification ts) {
        if (this.updateTraceSpec(ts)) {
            if (this.trStateChangeListener != null) {
                this.trStateChangeListener.traceStateChanged();
            }
            if (this.logger != null) {
                this.logger.setLevel(this.getLoggerLevel());
            }
            TrConfigurator.traceComponentUpdated(this);
        }
    }

    final void setResourceBundleName(String name) {
        this.bundle = name;
    }

    public final String getResourceBundleName() {
        String rb = this.bundle;
        if (rb == null && this.logger != null) {
            rb = this.logger.getResourceBundleName();
        }
        return rb;
    }

    public final synchronized void setLoggerForCallback(TraceStateChangeListener listener) {
        this.trStateChangeListener = listener;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isDumpEnabled() {
        return !this.isTraceOff && (this.fineLevelsEnabled & 1) != 0;
    }

    public final boolean isDebugEnabled() {
        return !this.isTraceOff && (this.fineLevelsEnabled & 2) != 0;
    }

    public final boolean isEntryEnabled() {
        return !this.isTraceOff && (this.fineLevelsEnabled & 4) != 0;
    }

    public final boolean isEventEnabled() {
        return !this.isTraceOff && (this.fineLevelsEnabled & 8) != 0;
    }

    public final boolean isDetailEnabled() {
        return !this.isTraceOff && (this.fineLevelsEnabled & 0x10) != 0;
    }

    public final boolean isConfigEnabled() {
        return !this.isTraceOff && (this.fineLevelsEnabled & 0x20) != 0;
    }

    public final boolean isInfoEnabled() {
        return (this.fineLevelsEnabled & 0x40) != 0;
    }

    public final boolean isAuditEnabled() {
        return (this.fineLevelsEnabled & 0x80) != 0;
    }

    public final boolean isWarningEnabled() {
        return (this.fineLevelsEnabled & 0x100) != 0;
    }

    public final boolean isErrorEnabled() {
        return (this.fineLevelsEnabled & 0x200) != 0;
    }

    public final boolean isFatalEnabled() {
        return (this.fineLevelsEnabled & 0x400) != 0;
    }

    public final boolean isServiceEnabled() {
        return this.isAuditEnabled();
    }

    private boolean updateTraceSpec(TraceSpecification ts) {
        int newFineLevel = this.fineLevel;
        int newFineLevelsEnabled = 0;
        int newSpecTraceLevel = 16;
        if (ts == Tr.defaultTraceSpec) {
            newFineLevel = INFO_FINE_LEVEL;
            newFineLevelsEnabled = INFO_FINE_LEVELS_ENABLED;
            newSpecTraceLevel = INFO_TRACE_LEVEL;
            this.isTraceOff = true;
        } else {
            List<TraceSpecification.TraceElement> traceSpecs = ts.getSpecs();
            Integer minimumLevel = null;
            if (ts.isSensitiveTraceSuppressed()) {
                minimumLevel = this.findMinimumSafeLevel(ts.getSafeLevelsIndex());
            }
            for (TraceSpecification.TraceElement spec : traceSpecs) {
                String clazz = spec.groupName;
                int traceElementFineLevel = spec.fineLevel;
                int specTraceLevel = spec.specTraceLevel;
                boolean setValue = spec.action;
                boolean process = false;
                if (clazz.endsWith("*")) {
                    if (1 == clazz.length()) {
                        process = true;
                    } else {
                        clazz = clazz.substring(0, clazz.length() - 1);
                        for (String group : this.groups) {
                            if (!group.startsWith(clazz)) continue;
                            process = true;
                            break;
                        }
                        process = process || this.name.startsWith(clazz);
                    }
                } else {
                    String packageName;
                    int lastDot = this.name.lastIndexOf(46);
                    if (lastDot > 0 && (packageName = this.name.substring(0, lastDot)).startsWith(clazz)) {
                        process = true;
                    }
                    for (String group : this.groups) {
                        lastDot = group.lastIndexOf(46);
                        if (lastDot <= 0) continue;
                        String packageName2 = group.substring(0, lastDot);
                        if (!packageName2.startsWith(clazz)) break;
                        process = true;
                        break;
                    }
                    for (String group : this.groups) {
                        if (!group.equalsIgnoreCase(clazz)) continue;
                        process = true;
                        break;
                    }
                    boolean bl = process = process || this.name.equalsIgnoreCase(clazz);
                }
                if (!process) continue;
                newFineLevel = traceElementFineLevel;
                newSpecTraceLevel = specTraceLevel;
                if (minimumLevel != null && newFineLevel < minimumLevel) {
                    newFineLevel = minimumLevel;
                }
                for (int level = newFineLevel; level < 11; ++level) {
                    if (setValue) {
                        newFineLevelsEnabled |= 1 << level;
                        continue;
                    }
                    newFineLevelsEnabled &= ~(1 << level);
                }
                this.isTraceOff = newFineLevel == 11;
                spec.setMatched(true);
            }
        }
        boolean updated = false;
        if (newFineLevel != this.fineLevel) {
            this.fineLevel = newFineLevel;
            updated = true;
        }
        if (newFineLevelsEnabled != this.fineLevelsEnabled) {
            this.fineLevelsEnabled = newFineLevelsEnabled;
            updated = true;
        }
        if (newSpecTraceLevel != this.specTraceLevel) {
            this.specTraceLevel = newSpecTraceLevel;
            updated = true;
        }
        return updated;
    }

    private Integer findMinimumSafeLevel(PackageIndex<Integer> index) {
        if (index == null) {
            return null;
        }
        Integer minimumLevel = (Integer)index.find(this.name);
        if (minimumLevel == null) {
            String group;
            String[] stringArray = this.groups;
            int n = stringArray.length;
            for (int i = 0; i < n && (minimumLevel = (Integer)index.find(group = stringArray[i])) == null; ++i) {
            }
        }
        return minimumLevel;
    }

    public final Level getLoggerLevel() {
        if (this.fineLevel < TrLevelConstants.levels.length) {
            return TrLevelConstants.levels[this.fineLevel];
        }
        return Level.OFF;
    }

    @Override
    public String[] introspectSelf() {
        return new String[]{this.toString()};
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.name + "," + this.aClass + "," + Arrays.toString(this.groups) + "," + this.bundle + "," + this.logger + "]";
    }

    static {
        int infoLevel = 0;
        for (int level = 6; level < 11; ++level) {
            infoLevel |= 1 << level;
        }
        INFO_FINE_LEVELS_ENABLED = infoLevel;
        int found = -1;
        int traceLevel = 0;
        int traceLevelCount = 0;
        for (int i = 0; i < TrLevelConstants.traceLevels.length; ++i) {
            String[] traceLevelsRow = TrLevelConstants.traceLevels[i];
            for (int j = 0; j < traceLevelsRow.length; ++j) {
                if ("info".equalsIgnoreCase(traceLevelsRow[j])) {
                    found = i;
                    traceLevel = traceLevelCount;
                    break;
                }
                ++traceLevelCount;
            }
            if (found >= 0) break;
        }
        INFO_FINE_LEVEL = found;
        INFO_TRACE_LEVEL = traceLevel;
        fineTraceEnabled = null;
    }
}

