/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

public enum JPAVersion {
    DEFAULT_VERSION(2.1),
    VERSION_1_0(1.0),
    VERSION_2_0(2.0),
    VERSION_2_1(2.1),
    VERSION_2_2(2.2),
    VERSION_3_0(3.0),
    VERSION_3_1(3.1),
    VERSION_3_2(3.2);

    private final double version;

    private JPAVersion(double version) {
        this.version = version;
    }

    public static JPAVersion value(String value) {
        for (JPAVersion version : JPAVersion.versions()) {
            if (!version.getVersion().equals(value)) continue;
            return version;
        }
        return DEFAULT_VERSION;
    }

    public static JPAVersion[] versions() {
        JPAVersion[] values = new JPAVersion[]{VERSION_1_0, VERSION_2_0, VERSION_2_1, VERSION_2_2, VERSION_3_0, VERSION_3_1};
        values[6] = VERSION_3_2;
        return values;
    }

    public String getVersion() {
        return String.valueOf(this.version);
    }

    public boolean isNewerThan(JPAVersion version) {
        return this.version > version.version;
    }

    public boolean isNewerThanOrEqual(JPAVersion version) {
        return this.version >= version.version;
    }

    public boolean isOlderThan(JPAVersion version) {
        return this.version < version.version;
    }

    public boolean isOlderThanOrEqual(JPAVersion version) {
        return this.version <= version.version;
    }

    public JPAVersion toCurrentVersion() {
        if (this == DEFAULT_VERSION) {
            String currentVersion = this.getVersion();
            for (JPAVersion version : JPAVersion.versions()) {
                if (!currentVersion.equals(String.valueOf(version.version))) continue;
                return version;
            }
        }
        return this;
    }

    public String toString() {
        return this.getVersion();
    }
}

