/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataField;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataConverter;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.EnumTypeConverter;

public class EnumeratedMetadata
extends MetadataConverter {
    private String m_enumeratedType;

    public EnumeratedMetadata() {
        super("<enumerated>");
        this.m_enumeratedType = "ORDINAL";
    }

    public EnumeratedMetadata(MetadataAccessor accessor) {
        super(null, accessor);
    }

    public EnumeratedMetadata(MetadataAnnotation enumerated, MetadataAccessor accessor) {
        super(enumerated, accessor);
        this.m_enumeratedType = enumerated.getAttributeString("value");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof EnumeratedMetadata) {
            EnumeratedMetadata enumerated = (EnumeratedMetadata)objectToCompare;
            return this.valuesMatch(this.m_enumeratedType, enumerated.getEnumeratedType());
        }
        return false;
    }

    public int hashCode() {
        return this.m_enumeratedType != null ? this.m_enumeratedType.hashCode() : 0;
    }

    public String getEnumeratedType() {
        return this.m_enumeratedType;
    }

    public static boolean isValidEnumeratedType(MetadataClass cls) {
        return cls.isEnum();
    }

    @Override
    public void process(DatabaseMapping mapping, MappingAccessor accessor, MetadataClass referenceClass, boolean isForMapKey) {
        if (!EnumeratedMetadata.isValidEnumeratedType(referenceClass)) {
            throw ValidationException.invalidTypeForEnumeratedAttribute(mapping.getAttributeName(), referenceClass, accessor.getJavaClass());
        }
        ArrayList<MetadataField> annotatedFields = new ArrayList<MetadataField>();
        Collection<MetadataField> fields = referenceClass.getFields().values();
        for (MetadataField field : fields) {
            if (!field.isAnnotationPresent("jakarta.persistence.EnumeratedValue")) continue;
            annotatedFields.add(field);
        }
        if (annotatedFields.size() > 1) {
            throw ValidationException.incorrectNumberOfEnumeratedValueAnnotation(referenceClass.getName());
        }
        MetadataField annotatedField = null;
        Class<?> fieldType = null;
        if (annotatedFields.size() == 1) {
            MetadataClass metadataClass = this.getMetadataFactory().getMetadataClass(referenceClass.getName());
            annotatedField = metadataClass.getField(((MetadataField)annotatedFields.get(0)).getName());
            fieldType = MetadataHelper.getClassForName(annotatedField.getType(), this.getMetadataFactory().getLoader());
        }
        boolean isOrdinal = true;
        if (this.m_enumeratedType != null) {
            isOrdinal = this.m_enumeratedType.equals("ORDINAL");
        }
        EnumTypeConverter enumTypeConverter = new EnumTypeConverter(mapping, referenceClass.getName());
        enumTypeConverter.setUseOrdinalValues(isOrdinal);
        if (annotatedField != null) {
            if (isOrdinal) {
                if (!BasicTypeHelperImpl.getInstance().isIntegralType(fieldType) || Character.TYPE.equals(fieldType) || Character.class.equals(fieldType)) {
                    throw ValidationException.invalidFieldTypeForOrdinalEnumType(((MetadataField)annotatedFields.get(0)).getName(), referenceClass);
                }
            } else if (!String.class.equals(fieldType)) {
                throw ValidationException.invalidFieldTypeForStringEnumType(((MetadataField)annotatedFields.get(0)).getName(), referenceClass);
            }
            enumTypeConverter.setEnumFieldName(annotatedField.getName());
        }
        this.setConverter(mapping, enumTypeConverter, isForMapKey);
    }

    public void setEnumeratedType(String enumerated) {
        this.m_enumeratedType = enumerated;
    }
}

