/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import org.eclipse.persistence.descriptors.InstantLockingPolicy;
import org.eclipse.persistence.descriptors.LocalDateTimeLockingPolicy;
import org.eclipse.persistence.descriptors.TimestampLockingPolicy;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;

public class VersionAccessor
extends BasicAccessor {
    public VersionAccessor() {
        super("<version>");
    }

    public VersionAccessor(MetadataAnnotation version, MetadataAnnotatedElement annotatedElement, ClassAccessor classAccessor) {
        super(version, (MetadataAccessibleObject)annotatedElement, classAccessor);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        return super.equals(objectToCompare) && objectToCompare instanceof VersionAccessor;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    protected boolean isValidVersionLockingType(MetadataClass cls) {
        return cls.isClass(Integer.TYPE) || cls.isClass(Integer.class) || cls.isClass(Short.TYPE) || cls.isClass(Short.class) || cls.isClass(Long.TYPE) || cls.isClass(Long.class) || cls.isClass(Timestamp.class) || cls.isClass(LocalDateTime.class) || cls.isClass(Instant.class);
    }

    @Override
    public void process() {
        super.process();
        if (this.getDescriptor().usesOptimisticLocking()) {
            this.getLogger().logConfigMessage("metadata_warning_ignore_version_locking", this);
        } else {
            MetadataClass lockType = this.getRawClass();
            this.getDatabaseField().setTypeName(this.getJavaClassName(lockType));
            if (this.isValidVersionLockingType(lockType)) {
                for (MetadataDescriptor owningDescriptor : this.getOwningDescriptors()) {
                    VersionLockingPolicy policy = VersionAccessor.createVersionLockingPolicy(lockType.getName(), this.getDatabaseField());
                    policy.storeInObject();
                    policy.setIsCascaded(this.getDescriptor().usesCascadedOptimisticLocking());
                    owningDescriptor.setOptimisticLockingPolicy(policy);
                }
            } else {
                throw ValidationException.invalidTypeForVersionAttribute(this.getAttributeName(), lockType, this.getJavaClass());
            }
        }
    }

    private static VersionLockingPolicy createVersionLockingPolicy(String typeName, DatabaseField field) {
        switch (typeName) {
            case "int": 
            case "java.lang.Integer": 
            case "long": 
            case "java.lang.Long": 
            case "short": 
            case "java.lang.Short": {
                return new VersionLockingPolicy(field);
            }
            case "java.sql.Timestamp": {
                return new TimestampLockingPolicy(field);
            }
            case "java.time.LocalDateTime": {
                return new LocalDateTimeLockingPolicy(field);
            }
            case "java.time.Instant": {
                return new InstantLockingPolicy(field);
            }
        }
        throw new UnsupportedOperationException("Cannot create VersionLockingPolicy for " + typeName);
    }
}

