/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.config.ssl.yoko;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.security.config.ssl.SSLSessionManager;
import java.net.Socket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.yoko.orb.OCI.IIOP.TransportInfo_impl;
import org.apache.yoko.orb.PortableInterceptor.ServerRequestInfoExt;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
final class ServiceContextInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private static final TraceComponent tc = Tr.register(ServiceContextInterceptor.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    static final long serialVersionUID = -6424311754076345381L;

    public ServiceContextInterceptor() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"<init>", (Object[])new Object[0]);
        }
    }

    public void receive_request(ServerRequestInfo ri) {
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) {
        Socket socket;
        ServerRequestInfoExt riExt;
        TransportInfo_impl connection;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Looking for SSL Session", (Object[])new Object[0]);
        }
        if ((connection = (TransportInfo_impl)(riExt = (ServerRequestInfoExt)ri).getTransportInfo()) != null && (socket = connection.getSocket()) != null && socket instanceof SSLSocket) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Found SSL Session", (Object[])new Object[0]);
            }
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLSessionManager.setSSLSession(ri.request_id(), sslSocket.getSession());
        }
    }

    public void send_exception(ServerRequestInfo ri) {
        SSLSession old = SSLSessionManager.clearSSLSession(ri.request_id());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && old != null) {
            Tr.debug((TraceComponent)tc, (String)"Removing SSL Session for send_exception", (Object[])new Object[0]);
        }
    }

    public void send_other(ServerRequestInfo ri) {
        SSLSession old = SSLSessionManager.clearSSLSession(ri.request_id());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && old != null) {
            Tr.debug((TraceComponent)tc, (String)"Removing SSL Session for send_reply", (Object[])new Object[0]);
        }
    }

    public void send_reply(ServerRequestInfo ri) {
        SSLSession old = SSLSessionManager.clearSSLSession(ri.request_id());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && old != null) {
            Tr.debug((TraceComponent)tc, (String)"Removing SSL Session for send_reply", (Object[])new Object[0]);
        }
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Destroy", (Object[])new Object[0]);
        }
    }

    public String name() {
        return "org.apache.geronimo.yoko.ServiceContextInterceptor";
    }
}

