/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.asn1.x509;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.asn1.ASN1Choice;
import com.ibm.ws.transport.iiop.asn1.ASN1Encodable;
import com.ibm.ws.transport.iiop.asn1.ASN1TaggedObject;
import com.ibm.ws.transport.iiop.asn1.DERGeneralizedTime;
import com.ibm.ws.transport.iiop.asn1.DERObject;
import com.ibm.ws.transport.iiop.asn1.DERUTCTime;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Time
extends ASN1Encodable
implements ASN1Choice {
    DERObject time;
    static final long serialVersionUID = -7005203962399568540L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static Time getInstance(ASN1TaggedObject obj, boolean explicit) {
        return Time.getInstance(obj.getObject());
    }

    public Time(DERObject time) {
        if (!(time instanceof DERUTCTime) && !(time instanceof DERGeneralizedTime)) {
            throw new IllegalArgumentException("unknown object passed to Time");
        }
        this.time = time;
    }

    public Time(Date date) {
        SimpleTimeZone tz = new SimpleTimeZone(0, "Z");
        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmss");
        dateF.setTimeZone(tz);
        String d = dateF.format(date) + "Z";
        int year = Integer.parseInt(d.substring(0, 4));
        this.time = year < 1950 || year > 2049 ? new DERGeneralizedTime(d) : new DERUTCTime(d.substring(2));
    }

    public static Time getInstance(Object obj) {
        if (obj instanceof Time) {
            return (Time)obj;
        }
        if (obj instanceof DERUTCTime) {
            return new Time((DERUTCTime)obj);
        }
        if (obj instanceof DERGeneralizedTime) {
            return new Time((DERGeneralizedTime)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public String getTime() {
        if (this.time instanceof DERUTCTime) {
            return ((DERUTCTime)this.time).getAdjustedTime();
        }
        return ((DERGeneralizedTime)this.time).getTime();
    }

    public Date getDate() {
        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmssz");
        return dateF.parse(this.getTime(), new ParsePosition(0));
    }

    @Override
    public DERObject toASN1Object() {
        return this.time;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.transport.iiop.asn1.x509.Time", Time.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    }
}

