/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointInvoker;
import com.ibm.ws.sib.ra.inbound.impl.SibRaAbstractConsumerSession;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AbstractConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.ra.SibRaMessageListener;
import jakarta.resource.spi.ResourceAdapterInternalException;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import java.lang.reflect.Method;

final class SibRaEndpointInvokerImpl
implements SibRaEndpointInvoker {
    private static Method ON_MESSAGE_METHOD;
    private static TraceComponent TRACE;
    private static TraceNLS NLS;
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String CLASS_NAME;

    SibRaEndpointInvokerImpl() {
    }

    public Method getEndpointMethod() throws ResourceAdapterInternalException {
        String methodName = "getEndpointMethod";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getEndpointMethod");
        }
        if (ON_MESSAGE_METHOD == null) {
            try {
                ON_MESSAGE_METHOD = SibRaMessageListener.class.getMethod("onMessage", SIBusMessage.class, AbstractConsumerSession.class, SITransaction.class);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "getEndpointMethod"), (String)FFDC_PROBE_2);
                if (TRACE.isEntryEnabled()) {
                    SibTr.exception((TraceComponent)TRACE, (Exception)exception);
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("ON_MESSAGE_CWSIV0851", new Object[]{exception}, null), (Throwable)exception);
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getEndpointMethod", (Object)ON_MESSAGE_METHOD);
        }
        return ON_MESSAGE_METHOD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeEndpoint(MessageEndpoint endpoint, SIBusMessage message, AbstractConsumerSession session, SITransaction transaction, String debugMEName) throws ResourceAdapterInternalException {
        boolean success;
        String methodName = "invokeEndpoint";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"invokeEndpoint", (Object)new Object[]{endpoint, message, session, transaction});
        }
        if (!(endpoint instanceof SibRaMessageListener)) {
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("UNEXPECTED_ENDPOINT_CWSIV0850", new Object[]{endpoint, SibRaMessageListener.class}, null));
        }
        SibRaMessageListener listener = (SibRaMessageListener)endpoint;
        SibRaAbstractConsumerSession wrappedSession = new SibRaAbstractConsumerSession(session);
        try {
            listener.onMessage(message, (AbstractConsumerSession)wrappedSession, transaction);
            success = true;
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)(CLASS_NAME + "." + "invokeEndpoint"), (String)FFDC_PROBE_1, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Throwable)exc);
            }
            success = false;
            if (exc instanceof ThreadDeath) {
                throw (ThreadDeath)exc;
            }
        }
        finally {
            wrappedSession.outOfScope();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"invokeEndpoint", (Object)success);
        }
        return success;
    }

    static {
        TRACE = SibRaUtils.getTraceComponent(SibRaEndpointInvokerImpl.class);
        NLS = SibRaUtils.getTraceNls();
        CLASS_NAME = SibRaEndpointInvokerImpl.class.getName();
    }
}

