/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AbstractConsumerSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SIMessageNotLockedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.ra.SibRaNotSupportedException;
import jakarta.resource.spi.ResourceAdapterInternalException;

final class SibRaAbstractConsumerSession
implements AbstractConsumerSession {
    private final AbstractConsumerSession _delegate;
    private final SICoreConnection _connectionClone;
    private boolean _outOfScope = false;
    private static TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaAbstractConsumerSession.class);
    private static final TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String RA_INBOUND_CONS_PROBE_1 = "RA_INB_CONS1";
    private static final String RA_INBOUND_CONS_PROBE_2 = "RA_INB_CONS2";

    SibRaAbstractConsumerSession(AbstractConsumerSession delegate) throws ResourceAdapterInternalException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaAbstractConsumerSession", (Object)delegate);
        }
        this._delegate = delegate;
        try {
            this._connectionClone = delegate.getConnection().cloneConnection();
        }
        catch (SIException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.inbound.impl.SibRaAbstractConsumerSession.SibRaAbstractConsumerSession", (String)RA_INBOUND_CONS_PROBE_1, (Object)this);
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("CLONE_EXCEPTION_CWSIV0700", new Object[]{exception, delegate}, null), (Throwable)exception);
        }
        catch (SIErrorException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.inbound.impl.SibRaAbstractConsumerSession.SibRaAbstractConsumerSession", (String)RA_INBOUND_CONS_PROBE_2, (Object)this);
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("CLONE_EXCEPTION_CWSIV0700", new Object[]{exception, delegate}, null), (Throwable)exception);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaAbstractConsumerSession");
        }
    }

    public void close() throws SibRaNotSupportedException {
        throw new SibRaNotSupportedException(NLS.getFormattedMessage("NOT_SUPPORTED_CWSIV0701", new Object[]{"close"}, null));
    }

    public SICoreConnection getConnection() throws SISessionUnavailableException {
        this.checkInScope();
        return this._connectionClone;
    }

    public SIDestinationAddress getDestinationAddress() {
        return this._delegate.getDestinationAddress();
    }

    private void checkInScope() throws SISessionUnavailableException {
        if (this._outOfScope) {
            throw new SISessionUnavailableException(NLS.getString("OUT_OF_SCOPE_CWSIV0702"));
        }
    }

    void outOfScope() {
        block6: {
            String methodName = "outOfScope";
            if (TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"outOfScope");
            }
            this._outOfScope = true;
            try {
                this._connectionClone.close();
            }
            catch (SIException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.inbound.impl.SibRaAbstractConsumerSession.outOfScope", (String)FFDC_PROBE_1, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
            }
            catch (SIErrorException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.ra.inbound.impl.SibRaAbstractConsumerSession.outOfScope", (String)FFDC_PROBE_2, (Object)this);
                if (!TRACE.isEventEnabled()) break block6;
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"outOfScope");
        }
    }

    public void deleteSet(SIMessageHandle[] msgHandles, SITransaction tran) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException, SIMessageNotLockedException {
        String methodName = "deleteSet";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"deleteSet", (Object)new Object[]{msgHandles, tran});
        }
        this.checkInScope();
        this._delegate.deleteSet(msgHandles, tran);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"deleteSet");
        }
    }

    public void unlockSet(SIMessageHandle[] msgHandles) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIIncorrectCallException, SIMessageNotLockedException {
        String methodName = "unlockSet";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"unlockSet", (Object)new Object[]{msgHandles});
        }
        this.checkInScope();
        this._delegate.unlockSet(msgHandles);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"unlockSet");
        }
    }

    public void unlockSet(SIMessageHandle[] msgHandles, boolean incrementLockCount) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIIncorrectCallException, SIMessageNotLockedException {
        String methodName = "unlockSet";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"unlockSet", (Object)new Object[]{msgHandles});
        }
        this.checkInScope();
        this._delegate.unlockSet(msgHandles, incrementLockCount);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"unlockSet");
        }
    }

    public String toString() {
        SibRaStringGenerator generator = new SibRaStringGenerator(this);
        generator.addParent("delegate", this._delegate);
        generator.addField("connectionClone", this._connectionClone);
        generator.addField("outOfScope", this._outOfScope);
        return generator.getStringRepresentation();
    }
}

