/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jmsra.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.adapter.WSConnectionManager;
import com.ibm.ws.resource.ResourceRefInfo;
import com.ibm.ws.sib.api.jms.service.JmsServiceFacade;
import com.ibm.ws.sib.api.jms.ute.UTEHelperFactory;
import com.ibm.ws.sib.api.jmsra.JmsJcaConnection;
import com.ibm.ws.sib.api.jmsra.JmsJcaConnectionFactory;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaConnectionImpl;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaConnectionRequestInfo;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaManagedConnection;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaManagedConnectionFactoryImpl;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaSessionImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.SICoreConnectionFactorySelector;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.selector.FactoryType;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.ResourceAdapterInternalException;
import java.util.Map;
import javax.naming.Reference;

final class JmsJcaConnectionFactoryImpl
implements JmsJcaConnectionFactory {
    private final JmsJcaManagedConnectionFactoryImpl _managedConnectionFactory;
    private ConnectionManager _connectionManager;
    private final boolean _managed;
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";
    private static final String FFDC_PROBE_4 = "4";
    private static final String FFDC_PROBE_5 = "5";
    private static final String FFDC_PROBE_6 = "6";
    private static final String FFDC_PROBE_7 = "7";
    private static final String CLASS_NAME = JmsJcaConnectionFactoryImpl.class.getName();
    private static final long serialVersionUID = 6803409986837640579L;
    private static TraceComponent TRACE = SibTr.register(JmsJcaConnectionFactoryImpl.class, (String)"SIBJmsRa", (String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static TraceNLS NLS = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");

    JmsJcaConnectionFactoryImpl(JmsJcaManagedConnectionFactoryImpl managedConnectionFactory, ConnectionManager connectionManager) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"JmsJcaConnectionFactoryImpl", (Object)new Object[]{managedConnectionFactory, connectionManager});
        }
        this._managedConnectionFactory = managedConnectionFactory;
        this._connectionManager = connectionManager;
        boolean bl = this._managed = !JmsServiceFacade.isClientContainer();
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"JmsJcaConnectionFactoryImpl");
        }
    }

    JmsJcaConnectionFactoryImpl(JmsJcaManagedConnectionFactoryImpl managedConnectionFactory) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"JmsJcaConnectionFactoryImpl", (Object)new Object[]{managedConnectionFactory});
        }
        this._managedConnectionFactory = managedConnectionFactory;
        this._managed = false;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"JmsJcaConnectionFactoryImpl");
        }
    }

    @Override
    public JmsJcaConnection createConnection() throws ResourceException, SIException, SIErrorException {
        JmsJcaConnectionImpl connection;
        block26: {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createConnection");
            }
            connection = null;
            JmsJcaConnectionRequestInfo requestInfo = new JmsJcaConnectionRequestInfo();
            boolean runningInWAS = false;
            boolean containerAuth = false;
            String containerAlias = null;
            try {
                if (this._managed) {
                    if (this._connectionManager instanceof WSConnectionManager) {
                        runningInWAS = true;
                        ResourceRefInfo info = ((WSConnectionManager)this._connectionManager).getResourceRefInfo();
                        containerAuth = info.getAuth() == 0;
                        for (ResourceRefInfo.Property loginConfigProp : info.getLoginPropertyList()) {
                            if (!"DefaultPrincipalMapping".equals(loginConfigProp.getName())) continue;
                            containerAlias = loginConfigProp.getValue();
                        }
                    }
                    Object object = null;
                    boolean tryAgain = true;
                    do {
                        if ((object = this._connectionManager.allocateConnection((ManagedConnectionFactory)this._managedConnectionFactory, (ConnectionRequestInfo)requestInfo)) instanceof JmsJcaSessionImpl) {
                            SICoreConnection coreConnection = ((JmsJcaSessionImpl)object).getManagedConnection().getCoreConnection();
                            if (requestInfo.getSICoreConnection() == null) {
                                requestInfo.setSICoreConnection(coreConnection);
                            }
                            SICoreConnection clonedCoreConnection = null;
                            Throwable clonedException = null;
                            if (coreConnection != null) {
                                JmsJcaManagedConnection mc;
                                try {
                                    clonedCoreConnection = coreConnection.cloneConnection();
                                }
                                catch (SIException e) {
                                    if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)TRACE, (String)"Clone connection failed");
                                    }
                                    mc = ((JmsJcaSessionImpl)object).getManagedConnection();
                                    mc.connectionErrorOccurred((Exception)((Object)e), true);
                                    clonedException = e;
                                }
                                catch (SIErrorException e) {
                                    if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)TRACE, (String)"Clone connection failed");
                                    }
                                    mc = ((JmsJcaSessionImpl)object).getManagedConnection();
                                    mc.connectionErrorOccurred((Exception)((Object)e), true);
                                    clonedException = e;
                                }
                            }
                            if (clonedCoreConnection != null) {
                                connection = new JmsJcaConnectionImpl(this, clonedCoreConnection, (JmsJcaSessionImpl)object, requestInfo);
                            }
                            boolean bl = tryAgain = clonedCoreConnection == null;
                            if (!tryAgain) continue;
                            SibTr.info((TraceComponent)TRACE, (String)NLS.getFormattedMessage("CONNECTION_ERROR_RETRY_CWSJR1067", new Object[]{clonedException}, null));
                            requestInfo = (JmsJcaConnectionRequestInfo)requestInfo.clone();
                            requestInfo.incrementRequestCounter();
                            continue;
                        }
                        throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1061", new Object[]{"createConnection", JmsJcaSessionImpl.class.getName(), object.getClass().getName()}, null));
                    } while (tryAgain);
                    break block26;
                }
                SICoreConnection coreConnection = this.createCoreConnection();
                connection = new JmsJcaConnectionImpl(this, coreConnection, requestInfo);
            }
            catch (ResourceException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".createConnection"), (String)FFDC_PROBE_1, (Object)this);
                Throwable cause = exception.getCause();
                if (runningInWAS) {
                    if (cause instanceof SIAuthenticationException) {
                        SIAuthenticationException authentEx = null;
                        authentEx = containerAuth ? (containerAlias != null && !containerAlias.isEmpty() ? new SIAuthenticationException(NLS.getFormattedMessage("CONTAINER_AUTHENTICATION_EXCEPTION_1068", new Object[]{containerAlias}, null)) : new SIAuthenticationException(NLS.getString("AUTHENTICATION_EXCEPTION_1077"))) : new SIAuthenticationException(NLS.getString("AUTHENTICATION_EXCEPTION_1077"));
                        throw authentEx;
                    }
                    if (cause instanceof SINotAuthorizedException) {
                        if (containerAuth) {
                            if (containerAlias == null) {
                                throw new SINotAuthorizedException(NLS.getString("CONTAINER_AUTHORIZATION_EXCEPTION_1070"));
                            }
                        } else {
                            String userName = this.getUserName();
                            if (userName == null || "".equals(userName)) {
                                throw new SINotAuthorizedException(NLS.getString("CONTAINER_AUTHORIZATION_EXCEPTION_1071"));
                            }
                        }
                    }
                }
                if (cause instanceof SIException) {
                    throw (SIException)cause;
                }
                if (cause instanceof SIErrorException) {
                    throw (SIErrorException)cause;
                }
                throw exception;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createConnection", (Object)connection);
        }
        return connection;
    }

    @Override
    public JmsJcaConnection createConnection(String userName, String password) throws ResourceException, SIException, SIErrorException {
        JmsJcaConnectionImpl connection;
        block18: {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createConnection", (Object)new Object[]{userName, "*****"});
            }
            connection = null;
            JmsJcaConnectionRequestInfo requestInfo = new JmsJcaConnectionRequestInfo(userName, password);
            try {
                if (this._managed) {
                    Object object = null;
                    boolean tryAgain = true;
                    do {
                        if ((object = this._connectionManager.allocateConnection((ManagedConnectionFactory)this._managedConnectionFactory, (ConnectionRequestInfo)requestInfo)) instanceof JmsJcaSessionImpl) {
                            SICoreConnection coreConnection = ((JmsJcaSessionImpl)object).getManagedConnection().getCoreConnection();
                            if (requestInfo.getSICoreConnection() == null) {
                                requestInfo.setSICoreConnection(coreConnection);
                            }
                            SICoreConnection clonedCoreConnection = null;
                            Throwable clonedException = null;
                            if (coreConnection != null) {
                                JmsJcaManagedConnection mc;
                                try {
                                    clonedCoreConnection = coreConnection.cloneConnection();
                                }
                                catch (SIException e) {
                                    if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)TRACE, (String)"Clone connection failed");
                                    }
                                    mc = ((JmsJcaSessionImpl)object).getManagedConnection();
                                    mc.connectionErrorOccurred((Exception)((Object)e), true);
                                    clonedException = e;
                                }
                                catch (SIErrorException e) {
                                    if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)TRACE, (String)"Clone connection failed");
                                    }
                                    mc = ((JmsJcaSessionImpl)object).getManagedConnection();
                                    mc.connectionErrorOccurred((Exception)((Object)e), true);
                                    clonedException = e;
                                }
                            }
                            if (clonedCoreConnection != null) {
                                connection = new JmsJcaConnectionImpl(this, clonedCoreConnection, (JmsJcaSessionImpl)object, requestInfo);
                            }
                            boolean bl = tryAgain = clonedCoreConnection == null;
                            if (!tryAgain) continue;
                            SibTr.info((TraceComponent)TRACE, (String)NLS.getFormattedMessage("CONNECTION_ERROR_RETRY_CWSJR1067", new Object[]{clonedException}, null));
                            requestInfo = (JmsJcaConnectionRequestInfo)requestInfo.clone();
                            requestInfo.incrementRequestCounter();
                            continue;
                        }
                        throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1061", new Object[]{"createConnection", JmsJcaSessionImpl.class.getName(), object.getClass().getName()}, null));
                    } while (tryAgain);
                    break block18;
                }
                SICoreConnection coreConnection = this.createCoreConnection(userName, password);
                connection = new JmsJcaConnectionImpl(this, coreConnection, requestInfo);
            }
            catch (ResourceException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "createConnection"), (String)FFDC_PROBE_3, (Object)this);
                Throwable cause = exception.getCause();
                if (cause instanceof SIAuthenticationException) {
                    String m = NLS.getFormattedMessage("APPLICATION_AUTHENTICATION_EXCEPTION_1072", new Object[]{userName}, null);
                    throw (SIAuthenticationException)new SIAuthenticationException(m).initCause((Throwable)exception);
                }
                if (cause instanceof SIException) {
                    throw (SIException)cause;
                }
                if (cause instanceof SIErrorException) {
                    throw (SIErrorException)cause;
                }
                throw exception;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createConnection", (Object)connection);
        }
        return connection;
    }

    SICoreConnection createCoreConnection() throws ResourceException {
        return this.createCoreConnection(this._managedConnectionFactory.getUserName(), this._managedConnectionFactory.getPassword());
    }

    SICoreConnection createCoreConnection(String userName, String password) throws ResourceException {
        SICoreConnection coreConnection;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createCoreConnection", (Object)new Object[]{userName, "*****"});
        }
        SICoreConnectionFactory coreConnectionFactory = null;
        if (!UTEHelperFactory.jmsTestEnvironmentEnabled) {
            try {
                coreConnectionFactory = SICoreConnectionFactorySelector.getSICoreConnectionFactory((FactoryType)FactoryType.TRM_CONNECTION);
            }
            catch (SIException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".createManagedConnection"), (String)FFDC_PROBE_5, (Object)this);
                throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1064", new Object[]{exception, "getSICoreConnectionFactory"}, null), (Throwable)exception);
            }
        } else {
            coreConnectionFactory = UTEHelperFactory.getHelperInstance().setupJmsTestEnvironment();
        }
        if (coreConnectionFactory == null) {
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("SICORECONNECTION_ERROR_CWSJR1066", new Object[]{"createManagedConnection"}, null));
        }
        try {
            Map trmProperties = this._managedConnectionFactory.getTrmProperties();
            coreConnection = coreConnectionFactory.createConnection(userName, password, trmProperties);
        }
        catch (SIException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".createManagedConnection (Subject, ConnectionRequestInfo)"), (String)FFDC_PROBE_6, (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1065", new Object[]{exception, "createManagedConnection"}, null), (Throwable)exception);
        }
        catch (SIErrorException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".createManagedConnection (Subject, ConnectionRequestInfo)"), (String)FFDC_PROBE_7, (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
            }
            throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1065", new Object[]{exception, "createManagedConnection"}, null), (Throwable)exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createCoreConnection", (Object)coreConnection);
        }
        return coreConnection;
    }

    @Override
    public String getClientID() {
        return this._managedConnectionFactory.getClientID();
    }

    @Override
    public String getNonPersistentMapping() {
        return this._managedConnectionFactory.getNonPersistentMapping();
    }

    @Override
    public String getPersistentMapping() {
        return this._managedConnectionFactory.getPersistentMapping();
    }

    @Override
    public String getDurableSubscriptionHome() {
        return this._managedConnectionFactory.getDurableSubscriptionHome();
    }

    @Override
    public String getReadAhead() {
        return this._managedConnectionFactory.getReadAhead();
    }

    @Override
    public String getTemporaryQueueNamePrefix() {
        return this._managedConnectionFactory.getTemporaryQueueNamePrefix();
    }

    @Override
    public String getTemporaryTopicNamePrefix() {
        return this._managedConnectionFactory.getTemporaryTopicNamePrefix();
    }

    @Override
    public String getBusName() {
        return this._managedConnectionFactory.getBusName();
    }

    @Override
    public String getUserName() {
        return this._managedConnectionFactory.getUserName();
    }

    @Override
    public String getPassword() {
        return this._managedConnectionFactory.getPassword();
    }

    @Override
    public String getTarget() {
        return this._managedConnectionFactory.getTarget();
    }

    @Override
    public String getTargetSignificance() {
        return this._managedConnectionFactory.getTargetSignificance();
    }

    @Override
    public String getTargetType() {
        return this._managedConnectionFactory.getTargetType();
    }

    @Override
    public String getTargetTransportChain() {
        return this._managedConnectionFactory.getTargetTransportChain();
    }

    @Override
    public String getProviderEndpoints() {
        return this._managedConnectionFactory.getRemoteServerAddress();
    }

    @Override
    public String getConnectionProximity() {
        return this._managedConnectionFactory.getConnectionProximity();
    }

    @Override
    public String getShareDurableSubscriptions() {
        return this._managedConnectionFactory.getShareDurableSubscriptions();
    }

    @Override
    public String getSubscriptionProtocol() {
        return this._managedConnectionFactory.getSubscriptionProtocol();
    }

    @Override
    public String getMulticastInterface() {
        return this._managedConnectionFactory.getMulticastInterface();
    }

    @Override
    public String getProducerDoesNotModifyPayloadAfterSet() {
        return this._managedConnectionFactory.getProducerDoesNotModifyPayloadAfterSet();
    }

    @Override
    public String getConsumerDoesNotModifyPayloadAfterGet() {
        return this._managedConnectionFactory.getConsumerDoesNotModifyPayloadAfterGet();
    }

    @Override
    public boolean isManaged() {
        return this._managed;
    }

    ConnectionManager getConnectionManager() {
        return this._connectionManager;
    }

    JmsJcaManagedConnectionFactoryImpl getManagedConnectionFactory() {
        return this._managedConnectionFactory;
    }

    public boolean equals(Object other) {
        if (!(other instanceof JmsJcaConnectionFactoryImpl)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        boolean equal = this._managedConnectionFactory != null ? this._managedConnectionFactory.equals(((JmsJcaConnectionFactoryImpl)other).getManagedConnectionFactory()) : ((JmsJcaConnectionFactoryImpl)other).getManagedConnectionFactory() == null;
        return equal;
    }

    public int hashCode() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"hashCode");
        }
        int hash = 31;
        hash = 17 * hash + (this._managed ? 0 : 1);
        hash = 17 * hash + (this._managedConnectionFactory == null ? 0 : this._managedConnectionFactory.hashCode());
        hash = 17 * hash + (this._connectionManager == null ? 0 : this._connectionManager.hashCode());
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"hashCode", (Object)new Integer(hash));
        }
        return hash;
    }

    public Reference getReference() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getReference");
        }
        Reference reference = this._managedConnectionFactory.getReference();
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getReference", (Object)reference);
        }
        return reference;
    }

    public void setReference(Reference reference) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"setReference", (Object)reference);
        }
        this._managedConnectionFactory.setReference(reference);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"setReference");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(this.getClass().getName());
        sb.append("@");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" <managedConnectionFactory=");
        sb.append(this._managedConnectionFactory);
        sb.append("> <connectionManager=");
        sb.append(this._connectionManager);
        sb.append("> <managed=");
        sb.append(this._managed);
        sb.append(">]");
        return sb.toString();
    }
}

