/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.api.jms.impl.JmsMsgProducerImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;

public class JmsTopicPublisherImpl
extends JmsMsgProducerImpl
implements TopicPublisher {
    private static TraceComponent tc = SibTr.register(JmsTopicPublisherImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");

    JmsTopicPublisherImpl(Destination theDest, SICoreConnection coreConnection, JmsSessionImpl newSession) throws JMSException {
        super(theDest, coreConnection, newSession);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsTopicPublisherImpl", (Object)new Object[]{theDest, coreConnection, newSession});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsTopicPublisherImpl");
        }
    }

    public Topic getTopic() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTopic");
        }
        this.checkClosed();
        Topic topic = (Topic)this.getDestination();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTopic", (Object)topic);
        }
        return topic;
    }

    public void publish(Message message) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"publish", (Object)message);
        }
        this.send(message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"publish");
        }
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"publish", (Object)new Object[]{message, deliveryMode, priority, timeToLive});
        }
        this.send(message, deliveryMode, priority, timeToLive);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"publish");
        }
    }

    public void publish(Topic topic, Message message) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"publish", (Object)new Object[]{topic, message});
        }
        this.send((Destination)topic, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"publish");
        }
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"publish", (Object)new Object[]{topic, message, deliveryMode, priority, timeToLive});
        }
        this.send((Destination)topic, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"publish");
        }
    }
}

